/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.shape;

import dev.felnull.otyacraftengine.shape.VoxelEdge;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import org.apache.commons.lang3.tuple.Triple;

public enum RotateAngledAxis {
    Y90((sx, sy, sz, ex, ey, ez) -> new ConvertPos(sz, sy, 1.0 - sx, ez, ey, 1.0 - ex), class_2350.class_2351.field_11052, 90.0f),
    Y180((sx, sy, sz, ex, ey, ez) -> new ConvertPos(1.0 - sx, sy, 1.0 - sz, 1.0 - ex, ey, 1.0 - ez), class_2350.class_2351.field_11052, 180.0f),
    Y270((sx, sy, sz, ex, ey, ez) -> {
        ConvertPos pos = RotateAngledAxis.Y180.convert.convert(sx, sy, sz, ex, ey, ez);
        return new ConvertPos(pos.sz(), pos.sy(), 1.0 - pos.sx(), pos.ez(), pos.ey(), 1.0 - pos.ex());
    }, class_2350.class_2351.field_11052, 270.0f),
    X90((sx, sy, sz, ex, ey, ez) -> new ConvertPos(sy, sx, sz, ey, ex, ez), class_2350.class_2351.field_11048, 90.0f),
    X180((sx, sy, sz, ex, ey, ez) -> new ConvertPos(1.0 - sx, 1.0 - sy, sz, 1.0 - ex, 1.0 - ey, ez), class_2350.class_2351.field_11048, 180.0f),
    X270((sx, sy, sz, ex, ey, ez) -> {
        ConvertPos pos = RotateAngledAxis.Y180.convert.convert(sx, sy, sz, ex, ey, ez);
        return new ConvertPos(1.0 - pos.sy(), pos.sx(), pos.sz(), 1.0 - pos.ey(), pos.ex(), pos.ez());
    }, class_2350.class_2351.field_11048, 270.0f),
    Z90((sx, sy, sz, ex, ey, ez) -> new ConvertPos(sx, sz, sy, ex, ez, ey), class_2350.class_2351.field_11051, 90.0f),
    Z180((sx, sy, sz, ex, ey, ez) -> new ConvertPos(sx, 1.0 - sy, 1.0 - sz, ex, 1.0 - ey, 1.0 - ez), class_2350.class_2351.field_11051, 180.0f);

    private final ConvertRot convert;
    private final class_2350.class_2351 axis;
    private final float angle;

    private RotateAngledAxis(ConvertRot convert, class_2350.class_2351 axis, float angle) {
        this.convert = convert;
        this.axis = axis;
        this.angle = angle;
    }

    public class_2350.class_2351 getAxis() {
        return this.axis;
    }

    public float getAngle() {
        return this.angle;
    }

    public class_238 rotationAABB(class_238 aabb) {
        ConvertPos cp = this.convert.convert(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.field_1320, aabb.field_1325, aabb.field_1324);
        return new class_238(cp.sx(), cp.sy(), cp.sz(), cp.ex(), cp.ey(), cp.ez());
    }

    public VoxelEdge rotationEdge(VoxelEdge edge) {
        ConvertPos cp = this.convert.convert(edge.stX(), edge.stY(), edge.stZ(), edge.enX(), edge.enY(), edge.enZ());
        return new VoxelEdge(cp.sx(), cp.sy(), cp.sz(), cp.ex(), cp.ey(), cp.ez());
    }

    public Triple<Float, Float, Float> getRotation() {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        switch (this.axis) {
            case field_11048: {
                x = this.angle;
                break;
            }
            case field_11052: {
                y = this.angle;
                break;
            }
            case field_11051: {
                z = this.angle;
            }
        }
        return Triple.of((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z));
    }

    private static interface ConvertRot {
        public ConvertPos convert(double var1, double var3, double var5, double var7, double var9, double var11);
    }

    private record ConvertPos(double sx, double sy, double sz, double ex, double ey, double ez) {
    }
}

