/*
 * Decompiled with CFR 0.152.
 */
package link.infra.borderlessmining.util;

import java.nio.IntBuffer;
import link.infra.borderlessmining.config.ConfigHandler;
import net.minecraft.class_1041;
import net.minecraft.class_313;
import net.minecraft.class_319;
import net.minecraft.class_323;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.system.MemoryStack;

public class DimensionsResolver {
    private static final Logger LOGGER = LogManager.getLogger(DimensionsResolver.class);
    public int x;
    public int y;
    public int width;
    public int height;

    public boolean resolve(class_1041 window, class_323 tracker) {
        if (ConfigHandler.getInstance().customWindowDimensions != null && ConfigHandler.getInstance().customWindowDimensions.enabled && !ConfigHandler.getInstance().customWindowDimensions.useMonitorCoordinates) {
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
        } else if (ConfigHandler.getInstance().forceWindowMonitor < 0) {
            class_313 monitor = tracker.method_1681(window);
            if (monitor == null) {
                LOGGER.error("Failed to get a valid monitor for determining fullscreen size!");
                return false;
            }
            class_319 mode = monitor.method_1617();
            this.x = monitor.method_1616();
            this.y = monitor.method_1618();
            this.width = mode.method_1668();
            this.height = mode.method_1669();
        } else {
            long monitorHandle;
            PointerBuffer monitors = GLFW.glfwGetMonitors();
            if (monitors == null || monitors.limit() < 1) {
                LOGGER.error("Failed to get a valid monitor list for determining fullscreen position!");
                return false;
            }
            if (ConfigHandler.getInstance().forceWindowMonitor >= monitors.limit()) {
                LOGGER.warn("Monitor " + ConfigHandler.getInstance().forceWindowMonitor + " is greater than list size " + monitors.limit() + ", using monitor 0");
                monitorHandle = monitors.get(0);
            } else {
                monitorHandle = monitors.get(ConfigHandler.getInstance().forceWindowMonitor);
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer xBuf = stack.mallocInt(1);
                IntBuffer yBuf = stack.mallocInt(1);
                GLFW.glfwGetMonitorPos((long)monitorHandle, (IntBuffer)xBuf, (IntBuffer)yBuf);
                this.x = xBuf.get();
                this.y = yBuf.get();
            }
            GLFWVidMode mode = GLFW.glfwGetVideoMode((long)monitorHandle);
            if (mode == null) {
                LOGGER.error("Failed to get a video mode for the current monitor!");
                return false;
            }
            this.width = mode.width();
            this.height = mode.height();
        }
        if (ConfigHandler.getInstance().customWindowDimensions != null) {
            ConfigHandler.CustomWindowDimensions dims = ConfigHandler.getInstance().customWindowDimensions;
            if (dims.enabled) {
                if (dims.useMonitorCoordinates) {
                    this.x += dims.x;
                    this.y += dims.y;
                } else {
                    this.x = dims.x;
                    this.y = dims.y;
                }
                if (dims.width > 0 && dims.height > 0) {
                    this.width = dims.width;
                    this.height = dims.height;
                } else if (!dims.useMonitorCoordinates) {
                    LOGGER.error("Both width and height must be > 0 when specifying absolute coordinates!");
                    return false;
                }
            }
        }
        return true;
    }
}

