/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.util;

import de.siphalor.mousewheelie.MWConfig;
import de.siphalor.mousewheelie.client.util.StackMatcher;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;

public class CreativeSearchOrder {
    private static class_7699 lastFeatureSet = null;
    private static final Object2IntMap<StackMatcher> stackToSearchPositionLookup = new Object2IntOpenHashMap();
    private static final ReadWriteLock stackToSearchPositionLookupLock;

    public static Lock getReadLock() {
        return stackToSearchPositionLookupLock.readLock();
    }

    public static int getStackSearchPosition(class_1799 stack) {
        int pos = stackToSearchPositionLookup.getInt((Object)StackMatcher.of(stack));
        if (pos == Integer.MAX_VALUE) {
            pos = stackToSearchPositionLookup.getInt((Object)StackMatcher.ignoreNbt(stack));
        }
        return pos;
    }

    public static void refreshItemSearchPositionLookup() {
        if (MWConfig.sort.optimizeCreativeSearchSort) {
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null) {
                return;
            }
            class_7699 enabledFeatures = client.field_1687.method_45162();
            if (stackToSearchPositionLookup.isEmpty() || !Objects.equals(enabledFeatures, lastFeatureSet)) {
                class_7706.method_47330((class_7699)enabledFeatures, (boolean)true, (class_7225.class_7874)client.field_1687.method_30349());
                ArrayList displayStacks = new ArrayList(class_7706.method_47344().method_47313());
                new Thread(() -> {
                    Lock lock = stackToSearchPositionLookupLock.writeLock();
                    lock.lock();
                    stackToSearchPositionLookup.clear();
                    if (displayStacks.isEmpty()) {
                        lock.unlock();
                        return;
                    }
                    int i = 0;
                    for (class_1799 stack : displayStacks) {
                        StackMatcher plainMatcher = StackMatcher.ignoreNbt(stack);
                        if (!stack.method_7985() || !stackToSearchPositionLookup.containsKey((Object)plainMatcher)) {
                            stackToSearchPositionLookup.put((Object)plainMatcher, i);
                            ++i;
                        }
                        stackToSearchPositionLookup.put((Object)StackMatcher.of(stack), i);
                        ++i;
                    }
                    lock.unlock();
                }, "Mouse Wheelie: creative search stack position lookup builder").start();
            }
        } else {
            Lock lock = stackToSearchPositionLookupLock.writeLock();
            lock.lock();
            stackToSearchPositionLookup.clear();
            lock.unlock();
        }
    }

    static {
        stackToSearchPositionLookup.defaultReturnValue(Integer.MAX_VALUE);
        stackToSearchPositionLookupLock = new ReentrantReadWriteLock();
    }
}

