/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.core.WithPersistentData;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.net.PaintMessage;
import dev.latvian.mods.kubejs.net.ReloadStartupScriptsMessage;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.ExportablePackResources;
import dev.latvian.mods.kubejs.server.CustomCommandEventJS;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Scriptable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2179;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2214;
import net.minecraft.class_2232;
import net.minecraft.class_2233;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_266;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3097;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_5219;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;

public class KubeJSCommands {
    private static final char UNICODE_TICK = '\u2714';
    private static final char UNICODE_CROSS = '\u2718';
    public static final DynamicCommandExceptionType NO_REGISTRY = new DynamicCommandExceptionType(id -> class_2561.method_43470((String)("No builtin or static registry found for " + id)));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode cmd = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kubejs").then(class_2170.method_9247((String)"help").executes(context -> KubeJSCommands.help((class_2168)context.getSource())))).then(class_2170.method_9247((String)"custom_command").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9264(ServerEvents.CUSTOM_COMMAND.findUniqueExtraIds(ScriptType.SERVER).stream().map(String::valueOf), (SuggestionsBuilder)builder)).executes(context -> KubeJSCommands.customCommand((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id")))))).then(class_2170.method_9247((String)"hand").executes(context -> KubeJSCommands.hand(((class_2168)context.getSource()).method_9207(), class_1268.field_5808)))).then(class_2170.method_9247((String)"offhand").executes(context -> KubeJSCommands.hand(((class_2168)context.getSource()).method_9207(), class_1268.field_5810)))).then(class_2170.method_9247((String)"inventory").executes(context -> KubeJSCommands.inventory(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"hotbar").executes(context -> KubeJSCommands.hotbar(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"errors").executes(context -> KubeJSCommands.errors((class_2168)context.getSource())))).then(class_2170.method_9247((String)"warnings").executes(context -> KubeJSCommands.warnings((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.reloadConfig((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"startup_scripts").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.reloadStartup((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server_scripts").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.reloadServer((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"client_scripts").requires(source -> true)).executes(context -> KubeJSCommands.reloadClient((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"textures").requires(source -> true)).executes(context -> KubeJSCommands.reloadTextures((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lang").requires(source -> true)).executes(context -> KubeJSCommands.reloadLang((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.export((class_2168)context.getSource()))).then(class_2170.method_9247((String)"pack_zips").executes(context -> KubeJSCommands.exportPacks((class_2168)context.getSource(), true)))).then(class_2170.method_9247((String)"pack_folders").executes(context -> KubeJSCommands.exportPacks((class_2168)context.getSource(), false))))).then(class_2170.method_9247((String)"list_tag").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"registry", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> class_2172.method_9264(((class_2168)ctx.getSource()).method_30497().method_40311().map(entry -> entry.comp_350().method_29177().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.listTagsFor((class_2168)ctx.getSource(), KubeJSCommands.registry((CommandContext<class_2168>)ctx, "registry")))).then(class_2170.method_9244((String)"tag", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> class_2172.method_9264(KubeJSCommands.allTags((class_2168)ctx.getSource(), KubeJSCommands.registry((CommandContext<class_2168>)ctx, "registry")).map(class_6862::comp_327).map(class_2960::toString), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.tagObjects((class_2168)ctx.getSource(), class_6862.method_40092(KubeJSCommands.registry((CommandContext<class_2168>)ctx, "registry"), (class_2960)class_2232.method_9443((CommandContext)ctx, (String)"tag")))))))).then(class_2170.method_9247((String)"dump_registry").then(class_2170.method_9244((String)"registry", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> class_2172.method_9264(((class_2168)ctx.getSource()).method_30497().method_40311().map(entry -> entry.comp_350().method_29177().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.dumpRegistry((class_2168)ctx.getSource(), KubeJSCommands.registry((CommandContext<class_2168>)ctx, "registry")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stages").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.addStage((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.removeStage((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> KubeJSCommands.clearStages((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> KubeJSCommands.listStages((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))))).then(class_2170.method_9247((String)"painter").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"object", (ArgumentType)class_2179.method_9284()).executes(context -> KubeJSCommands.painter((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), class_2179.method_9285((CommandContext)context, (String)"object"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"generate_typings").requires(source -> source.method_9211().method_3724())).executes(context -> KubeJSCommands.generateTypings((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"packmode").executes(context -> KubeJSCommands.packmode((class_2168)context.getSource(), ""))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> KubeJSCommands.packmode((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(class_2170.method_9247((String)"dump_internals").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"events").requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> KubeJSCommands.dumpEvents((class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"persistent_data").requires(source -> source.method_9259(2))).then(KubeJSCommands.addPersistentDataCommands(class_2170.method_9247((String)"server"), ctx -> Set.of(((class_2168)ctx.getSource()).method_9211())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dimension").then(KubeJSCommands.addPersistentDataCommands(class_2170.method_9247((String)"*"), ctx -> (Collection)((class_2168)ctx.getSource()).method_9211().method_3738()))).then(KubeJSCommands.addPersistentDataCommands(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()), ctx -> Set.of(class_2181.method_9289((CommandContext)ctx, (String)"dimension")))))).then(class_2170.method_9247((String)"entity").then(KubeJSCommands.addPersistentDataCommands(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9306()), ctx -> class_2186.method_9317((CommandContext)ctx, (String)"entity"))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"kjs").redirect((CommandNode)cmd));
    }

    private static int dumpEvents(class_2168 source) {
        Map<String, EventGroup> groups = EventGroup.getGroups();
        Path output = KubeJSPaths.LOCAL.resolve("event_groups");
        for (Map.Entry<String, EventGroup> entry : groups.entrySet()) {
            String groupName = entry.getKey();
            EventGroup group = entry.getValue();
            Path groupFolder = output.resolve(groupName);
            try {
                Files.createDirectories(groupFolder, new FileAttribute[0]);
                FileUtils.cleanDirectory((File)groupFolder.toFile());
            }
            catch (IOException e) {
                ConsoleJS.SERVER.handleError(e, null, "Failed to create folder for event group " + groupName);
                source.method_9213((class_2561)class_2561.method_43470((String)("Failed to create folder for event group " + groupName)));
                return 0;
            }
            for (Map.Entry<String, EventHandler> handlerEntry : group.getHandlers().entrySet()) {
                String handlerName = handlerEntry.getKey();
                EventHandler handler = handlerEntry.getValue();
                Path handlerFile = groupFolder.resolve(handlerName + ".md");
                String fullName = "%s.%s".formatted(groupName, handlerName);
                Class<? extends EventJS> eventType = handler.eventType.get();
                StringBuilder builder = new StringBuilder();
                builder.append("# ").append(fullName).append("\n\n");
                builder.append("## Basic info\n\n");
                builder.append("- Valid script types: ").append(handler.scriptTypePredicate.getValidTypes()).append("\n\n");
                builder.append("- Has result? ").append(handler.getHasResult() ? (char)'\u2714' : '\u2718').append("\n\n");
                builder.append("- Event class: ");
                if (eventType.getPackageName().startsWith("dev.latvian.mods.kubejs")) {
                    builder.append('[').append(UtilsJS.toMappedTypeString(eventType)).append(']').append('(').append("https://github.com/KubeJS-Mods/KubeJS/tree/").append(2001).append("/common/src/main/java/").append(eventType.getPackageName().replace('.', '/')).append('/').append(eventType.getSimpleName()).append(".java").append(')');
                } else {
                    builder.append(UtilsJS.toMappedTypeString(eventType)).append(" (third-party)");
                }
                builder.append("\n\n");
                Info classInfo = eventType.getAnnotation(Info.class);
                if (classInfo != null) {
                    builder.append("```\n").append(classInfo.value()).append("```");
                    builder.append("\n\n");
                }
                ScriptManager scriptManager = ScriptType.SERVER.manager.get();
                Context cx = scriptManager.context;
                JavaMembers members = JavaMembers.lookupClass((Context)cx, (Scriptable)scriptManager.topLevelScope, eventType, null, (boolean)false);
                boolean hasDocumentedMembers = false;
                StringBuilder documentedMembers = new StringBuilder("### Documented members:\n\n");
                builder.append("### Available fields:\n\n");
                builder.append("| Name | Type | Static? |\n");
                builder.append("| ---- | ---- | ------- |\n");
                for (JavaMembers.FieldInfo field : members.getAccessibleFields(cx, false)) {
                    if (field.field.getDeclaringClass() == Object.class) continue;
                    String typeName = UtilsJS.toMappedTypeString(field.field.getGenericType());
                    builder.append("| ").append(field.name).append(" | ").append(typeName).append(" | ");
                    builder.append(Modifier.isStatic(field.field.getModifiers()) ? (char)'\u2714' : '\u2718').append(" |\n");
                    Info info = field.field.getAnnotation(Info.class);
                    if (info == null) continue;
                    hasDocumentedMembers = true;
                    documentedMembers.append("- `").append(typeName).append(' ').append(field.name).append("`\n");
                    documentedMembers.append("```\n");
                    String desc = info.value();
                    documentedMembers.append(desc);
                    if (!desc.endsWith("\n")) {
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n\n");
                }
                builder.append("\n").append("Note: Even if no fields are listed above, some methods are still available as fields through *beans*.\n\n");
                builder.append("### Available methods:\n\n");
                builder.append("| Name | Parameters | Return type | Static? |\n");
                builder.append("| ---- | ---------- | ----------- | ------- |\n");
                for (JavaMembers.MethodInfo method : members.getAccessibleMethods(cx, false)) {
                    int i;
                    if (method.hidden || method.method.getDeclaringClass() == Object.class) continue;
                    builder.append("| ").append(method.name).append(" | ");
                    Type[] params = method.method.getGenericParameterTypes();
                    CharSequence[] paramTypes = new String[params.length];
                    for (int i2 = 0; i2 < params.length; ++i2) {
                        paramTypes[i2] = UtilsJS.toMappedTypeString(params[i2]);
                    }
                    builder.append(String.join((CharSequence)", ", paramTypes)).append(" | ");
                    String returnType = UtilsJS.toMappedTypeString(method.method.getGenericReturnType());
                    builder.append(" | ").append(returnType).append(" | ");
                    builder.append(Modifier.isStatic(method.method.getModifiers()) ? (char)'\u2714' : '\u2718').append(" |\n");
                    Info info = method.method.getAnnotation(Info.class);
                    if (info == null) continue;
                    hasDocumentedMembers = true;
                    documentedMembers.append("- ").append('`');
                    if (Modifier.isStatic(method.method.getModifiers())) {
                        documentedMembers.append("static ");
                    }
                    documentedMembers.append(returnType).append(' ').append(method.name).append('(');
                    Param[] namedParams = info.params();
                    String[] paramNames = new String[params.length];
                    CharSequence[] signature = new String[params.length];
                    for (i = 0; i < params.length; ++i) {
                        String name1;
                        Object name = "var" + i;
                        if (namedParams.length > i && !Strings.isNullOrEmpty((String)(name1 = namedParams[i].name()))) {
                            name = name1;
                        }
                        paramNames[i] = name;
                        signature[i] = (String)paramTypes[i] + " " + (String)name;
                    }
                    documentedMembers.append(String.join((CharSequence)", ", signature)).append(')').append('`').append("\n");
                    if (params.length > 0) {
                        documentedMembers.append("\n  Parameters:\n");
                        for (i = 0; i < params.length; ++i) {
                            documentedMembers.append("  - ").append(paramNames[i]).append(": ").append((String)paramTypes[i]).append((String)(namedParams.length > i ? "- " + namedParams[i].value() : "")).append("\n");
                        }
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n");
                    String desc = info.value();
                    documentedMembers.append(desc);
                    if (!desc.endsWith("\n")) {
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n\n");
                }
                builder.append("\n\n");
                if (hasDocumentedMembers) {
                    builder.append((CharSequence)documentedMembers).append("\n\n");
                }
                builder.append("### Example script:\n\n");
                builder.append("```js\n");
                builder.append(fullName).append('(');
                if (handler.extra != null) {
                    builder.append(handler.extra.required ? "extra_id, " : "/* extra_id (optional), */ ");
                }
                builder.append("(event) => {\n");
                builder.append("\t// This space (un)intentionally left blank\n");
                builder.append("});\n");
                builder.append("```\n\n");
                try {
                    Files.writeString(handlerFile, (CharSequence)builder.toString(), new OpenOption[0]);
                }
                catch (IOException e) {
                    ConsoleJS.SERVER.handleError(e, null, "Failed to write file for event handler " + fullName);
                    source.method_9213((class_2561)class_2561.method_43470((String)("Failed to write file for event handler " + fullName)));
                    return 0;
                }
            }
        }
        source.method_45068((class_2561)class_2561.method_43470((String)("Successfully dumped event groups to " + output)));
        return 1;
    }

    private static <T> class_5321<class_2378<T>> registry(CommandContext<class_2168> ctx, String arg) {
        return class_5321.method_29180((class_2960)class_2232.method_9443(ctx, (String)arg));
    }

    private static <T> Stream<class_6862<T>> allTags(class_2168 source, class_5321<class_2378<T>> registry) throws CommandSyntaxException {
        return ((class_2378)source.method_30497().method_33310(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.method_29177()))).method_40273();
    }

    private static class_2561 copy(String s, class_124 col, String info) {
        class_5250 component = class_2561.method_43470((String)"- ");
        component.method_10862(component.method_10866().method_27703(class_5251.method_27718((class_124)class_124.field_1080)));
        component.method_10862(component.method_10866().method_10958(new class_2558(class_2558.class_2559.field_21462, s)));
        component.method_10862(component.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)(info + " (Click to copy)")))));
        component.method_10852((class_2561)class_2561.method_43470((String)s).method_27692(col));
        return component;
    }

    private static void link(class_2168 source, class_124 color, String name, String url) {
        source.method_45068((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)name).method_27692(color).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, url)))));
    }

    private static int help(class_2168 source) {
        KubeJSCommands.link(source, class_124.field_1065, "Wiki", "https://kubejs.com/?" + KubeJS.QUERY);
        KubeJSCommands.link(source, class_124.field_1060, "Support", "https://kubejs.com/support?" + KubeJS.QUERY);
        KubeJSCommands.link(source, class_124.field_1078, "Changelog", "https://kubejs.com/changelog?" + KubeJS.QUERY);
        return 1;
    }

    private static int customCommand(class_2168 source, String id) {
        if (ServerEvents.CUSTOM_COMMAND.hasListeners()) {
            EventResult result = ServerEvents.CUSTOM_COMMAND.post(new CustomCommandEventJS((class_1937)source.method_9225(), source.method_9228(), class_2338.method_49638((class_2374)source.method_9222()), id), id);
            if (result.type() == EventResult.Type.ERROR) {
                source.method_9213((class_2561)class_2561.method_43470((String)result.value().toString()));
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private static int hand(class_3222 player, class_1268 hand) {
        player.method_43496((class_2561)class_2561.method_43470((String)"Item in hand:"));
        class_1799 stack = player.method_5998(hand);
        player.method_43496(KubeJSCommands.copy(ItemStackJS.toItemString(stack), class_124.field_1060, "Item ID"));
        ArrayList tags = new ArrayList(stack.kjs$getTags());
        tags.sort(null);
        for (class_2960 class_29602 : tags) {
            player.method_43496(KubeJSCommands.copy("'#" + class_29602 + "'", class_124.field_1054, "Item Tag [" + IngredientPlatformHelper.get().tag(class_29602.toString()).kjs$getStacks().size() + " items]"));
        }
        player.method_43496(KubeJSCommands.copy("'@" + stack.kjs$getMod() + "'", class_124.field_1075, "Mod [" + IngredientPlatformHelper.get().mod(stack.kjs$getMod()).kjs$getStacks().size() + " items]"));
        return 1;
    }

    private static int inventory(class_3222 player) {
        return KubeJSCommands.dump((List<class_1799>)player.method_31548().field_7547, player, "Inventory");
    }

    private static int hotbar(class_3222 player) {
        return KubeJSCommands.dump(player.method_31548().field_7547.subList(0, 9), player, "Hotbar");
    }

    private static int dump(List<class_1799> stacks, class_3222 player, String name) {
        List<String> dump = stacks.stream().filter(is -> !is.method_7960()).map(ItemStackJS::toItemString).toList();
        player.method_43496(KubeJSCommands.copy(dump.toString(), class_124.field_1068, name + " Item List"));
        return 1;
    }

    private static int errors(class_2168 source) {
        String[] lines = ScriptType.SERVER.errors.toArray(new String[0]);
        if (lines.length == 0) {
            source.method_45068((class_2561)class_2561.method_43470((String)"No errors found!").method_27692(class_124.field_1060));
            if (!ScriptType.SERVER.warnings.isEmpty()) {
                source.method_45068(ScriptType.SERVER.warningsComponent("/kubejs warnings"));
            }
            return 1;
        }
        for (int i = 0; i < lines.length; ++i) {
            class_5250 component = class_2561.method_43470((String)(i + 1 + ") ")).method_10852((class_2561)class_2561.method_43470((String)lines[i]).method_27692(class_124.field_1061)).method_27692(class_124.field_1079);
            source.method_45068((class_2561)component);
        }
        source.method_9226(() -> class_2561.method_43470((String)"More info in ").method_10852((class_2561)class_2561.method_43470((String)"'logs/kubejs/server.log'").kjs$clickOpenFile(ScriptType.SERVER.getLogFile().toString()).kjs$hover((class_2561)class_2561.method_43470((String)"Click to open"))).method_27692(class_124.field_1079), false);
        if (!ScriptType.SERVER.warnings.isEmpty()) {
            source.method_45068(ScriptType.SERVER.warningsComponent("/kubejs warnings"));
        }
        return 1;
    }

    private static int warnings(class_2168 source) {
        String[] lines = ScriptType.SERVER.warnings.toArray(new String[0]);
        if (lines.length == 0) {
            source.method_45068((class_2561)class_2561.method_43470((String)"No warnings found!").method_27692(class_124.field_1060));
            return 1;
        }
        for (int i = 0; i < lines.length; ++i) {
            class_5250 component = class_2561.method_43470((String)(i + 1 + ") ")).method_10852((class_2561)class_2561.method_43470((String)lines[i]).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16753920))).method_27692(class_124.field_1061));
            source.method_45068((class_2561)component);
        }
        return 1;
    }

    private static int reloadConfig(class_2168 source) {
        KubeJS.PROXY.reloadConfig();
        source.method_45068((class_2561)class_2561.method_43470((String)"Done!"));
        return 1;
    }

    private static int reloadStartup(class_2168 source) {
        KubeJS.getStartupScriptManager().reload(null);
        source.method_45068((class_2561)class_2561.method_43470((String)"Done!"));
        new ReloadStartupScriptsMessage(source.method_9211().method_3816()).sendToAll(source.method_9211());
        return 1;
    }

    private static int reloadServer(class_2168 source) {
        ServerScriptManager.instance.reloadScriptManager((class_3300)source.method_9211().kjs$getReloadableResources().comp_352());
        source.method_9226(() -> class_2561.method_43470((String)"Done! To reload recipes, tags, loot tables and other datapack things, run ").method_10852((class_2561)class_2561.method_43470((String)"'/reload'").kjs$clickRunCommand("/reload").kjs$hover((class_2561)class_2561.method_43470((String)"Click to run"))), false);
        return 1;
    }

    private static int reloadClient(class_2168 source) {
        KubeJS.PROXY.reloadClientInternal();
        source.method_45068((class_2561)class_2561.method_43470((String)"Done! To reload textures, models and other assets, press F3 + T"));
        return 1;
    }

    private static int reloadTextures(class_2168 source) {
        KubeJS.PROXY.reloadTextures();
        return 1;
    }

    private static int reloadLang(class_2168 source) {
        KubeJS.PROXY.reloadLang();
        return 1;
    }

    private static int export(class_2168 source) {
        if (DataExport.export != null) {
            return 0;
        }
        DataExport.export = new DataExport();
        DataExport.export.source = source;
        source.method_9226(() -> class_2561.method_43470((String)"Reloading server and exporting data..."), true);
        MinecraftServer minecraftServer = source.method_9211();
        class_3283 packRepository = minecraftServer.method_3836();
        class_5219 worldData = minecraftServer.method_27728();
        Collection collection = packRepository.method_29210();
        packRepository.method_14445();
        ArrayList collection2 = Lists.newArrayList((Iterable)collection);
        List collection3 = worldData.method_29589().comp_1010().method_29550();
        for (String string : packRepository.method_29206()) {
            if (collection3.contains(string) || collection2.contains(string)) continue;
            collection2.add(string);
        }
        class_3097.method_29480((Collection)collection2, (class_2168)source);
        return 1;
    }

    private static int exportPacks(class_2168 source, boolean exportZip) {
        ArrayList<ExportablePackResources> packs = new ArrayList<ExportablePackResources>();
        for (Object pack : source.method_9211().method_34864().method_29213().toList()) {
            if (!(pack instanceof ExportablePackResources)) continue;
            ExportablePackResources e = (ExportablePackResources)pack;
            packs.add(e);
        }
        KubeJS.PROXY.export(packs);
        int success = 0;
        for (ExportablePackResources pack : packs) {
            try {
                if (exportZip) {
                    path = KubeJSPaths.EXPORTED_PACKS.resolve(pack.method_14409() + ".zip");
                    Files.deleteIfExists(path);
                    try (FileSystem fs = FileSystems.newFileSystem(path, Map.of("create", true));){
                        pack.export(fs.getPath(".", new String[0]));
                    }
                } else {
                    path = KubeJSPaths.EXPORTED_PACKS.resolve(pack.method_14409());
                    if (Files.exists(path, new LinkOption[0])) {
                        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    Files.createDirectories(path, new FileAttribute[0]);
                    pack.export(path);
                }
                source.method_9226(() -> class_2561.method_43470((String)"Successfully exported ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)pack.method_14409()).method_27692(class_124.field_1078)), false);
                ++success;
            }
            catch (IOException e) {
                e.printStackTrace();
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to export %s!".formatted(pack)).method_27694(style -> style.method_10977(class_124.field_1061).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)e.getMessage())))));
            }
        }
        int success1 = success;
        if (source.method_9211().method_3724() && !source.method_9211().method_3860()) {
            source.method_9226(() -> class_2561.method_43470((String)("Exported " + success1 + " packs")).kjs$clickOpenFile(KubeJSPaths.EXPORTED_PACKS.toAbsolutePath().toString()), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Exported " + success1 + " packs")), false);
        }
        return success;
    }

    private static int outputRecipes(class_3222 player) {
        player.method_43496((class_2561)class_2561.method_43470((String)"WIP!"));
        return 1;
    }

    private static int inputRecipes(class_3222 player) {
        player.method_43496((class_2561)class_2561.method_43470((String)"WIP!"));
        return 1;
    }

    private static int checkRecipeConflicts(class_3222 player) {
        player.method_43496((class_2561)class_2561.method_43470((String)"WIP!"));
        return 1;
    }

    private static <T> int listTagsFor(class_2168 source, class_5321<class_2378<T>> registry) throws CommandSyntaxException {
        Stream<class_6862<class_6862>> tags = KubeJSCommands.allTags(source, registry);
        source.method_45068((class_2561)class_2561.method_43473());
        source.method_45068((class_2561)class_2561.method_43470((String)("List of all Tags for " + registry.method_29177() + ":")));
        source.method_45068((class_2561)class_2561.method_43473());
        long size = tags.map(class_6862::comp_327).map(tag -> class_2561.method_43470((String)"- %s".formatted(tag)).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/kubejs list_tag %s %s".formatted(registry.method_29177(), tag))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"[Show all entries for %s]".formatted(tag)))))).mapToLong(msg -> {
            source.method_45068((class_2561)msg);
            return 1L;
        }).sum();
        source.method_45068((class_2561)class_2561.method_43473());
        source.method_45068((class_2561)class_2561.method_43470((String)"Total: %d tags".formatted(size)));
        source.method_45068((class_2561)class_2561.method_43470((String)"(Click on any of the above tags to list their contents!)"));
        source.method_45068((class_2561)class_2561.method_43473());
        return 1;
    }

    private static <T> int tagObjects(class_2168 source, class_6862<T> key) throws CommandSyntaxException {
        class_2378 registry = (class_2378)source.method_30497().method_33310(key.comp_326()).orElseThrow(() -> NO_REGISTRY.create((Object)key.comp_326().method_29177()));
        Optional tag = registry.method_40266(key);
        if (tag.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Tag not found or empty!"));
            return 0;
        }
        source.method_45068((class_2561)class_2561.method_43473());
        source.method_45068((class_2561)class_2561.method_43470((String)("Contents of #" + key.comp_327() + " [" + key.comp_326().method_29177() + "]:")));
        source.method_45068((class_2561)class_2561.method_43473());
        class_6885.class_6888 items = (class_6885.class_6888)tag.get();
        for (class_6880 holder : items) {
            String id = (String)holder.method_40229().map(o -> o.method_29177().toString(), o -> o + " (unknown ID)");
            source.method_45068((class_2561)class_2561.method_43470((String)("- " + id)));
        }
        source.method_45068((class_2561)class_2561.method_43473());
        source.method_45068((class_2561)class_2561.method_43470((String)("Total: " + items.method_40247() + " elements")));
        source.method_45068((class_2561)class_2561.method_43473());
        return 1;
    }

    private static <T> int dumpRegistry(class_2168 source, class_5321<class_2378<T>> registry) throws CommandSyntaxException {
        Stream ids = ((class_2378)source.method_30497().method_33310(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.method_29177()))).method_40270();
        source.method_45068((class_2561)class_2561.method_43473());
        source.method_45068((class_2561)class_2561.method_43470((String)("List of all entries for registry " + registry.method_29177() + ":")));
        source.method_45068((class_2561)class_2561.method_43473());
        long size = ids.map(holder -> {
            class_2960 id = holder.method_40237().method_29177();
            return class_2561.method_43470((String)"- %s".formatted(id)).method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"%s [%s]".formatted(holder.comp_349(), holder.comp_349().getClass().getName())))));
        }).mapToLong(msg -> {
            source.method_45068((class_2561)msg);
            return 1L;
        }).sum();
        source.method_45068((class_2561)class_2561.method_43473());
        source.method_45068((class_2561)class_2561.method_43470((String)"Total: %d entries".formatted(size)));
        source.method_45068((class_2561)class_2561.method_43473());
        return 1;
    }

    private static int addStage(class_2168 source, Collection<class_3222> players, String stage) {
        for (class_3222 p : players) {
            if (!p.kjs$getStages().add(stage)) continue;
            source.method_9226(() -> class_2561.method_43470((String)("Added '" + stage + "' stage for " + p.method_5820())), true);
        }
        return 1;
    }

    private static int removeStage(class_2168 source, Collection<class_3222> players, String stage) {
        for (class_3222 p : players) {
            if (!p.kjs$getStages().remove(stage)) continue;
            source.method_9226(() -> class_2561.method_43470((String)("Removed '" + stage + "' stage for " + p.method_5820())), true);
        }
        return 1;
    }

    private static int clearStages(class_2168 source, Collection<class_3222> players) {
        for (class_3222 p : players) {
            if (!p.kjs$getStages().clear()) continue;
            source.method_9226(() -> class_2561.method_43470((String)("Cleared stages for " + p.method_5820())), true);
        }
        return 1;
    }

    private static int listStages(class_2168 source, Collection<class_3222> players) {
        for (class_3222 p : players) {
            source.method_45068((class_2561)class_2561.method_43470((String)(p.method_5820() + " stages:")));
            p.kjs$getStages().getAll().stream().sorted().forEach(s -> source.method_45068((class_2561)class_2561.method_43470((String)("- " + s))));
        }
        return 1;
    }

    private static int painter(class_2168 source, Collection<class_3222> players, class_2487 object) {
        new PaintMessage(object).sendTo(players);
        return 1;
    }

    private static int generateTypings(class_2168 source) {
        if (!source.method_9211().method_3724()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You can only run this command in singleplayer!"));
            return 0;
        }
        KubeJS.PROXY.generateTypings(source);
        return 1;
    }

    private static int packmode(class_2168 source, String packmode) {
        if (packmode.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("Current packmode: " + CommonProperties.get().packMode)), false);
        } else {
            CommonProperties.get().setPackMode(packmode);
            source.method_9226(() -> class_2561.method_43470((String)("Set packmode to: " + packmode)), true);
        }
        return 1;
    }

    private static ArgumentBuilder<class_2168, ?> addPersistentDataCommands(ArgumentBuilder<class_2168, ?> cmd, PersistentDataFactory factory) {
        cmd.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(class_2170.method_9247((String)"*").executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<class_2168>)ctx);
            for (WithPersistentData withPersistentData : objects) {
                class_2561 dataStr = class_2512.method_32270((class_2520)withPersistentData.kjs$getPersistentData());
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1054).method_10852(o.kjs$getDisplayName())).method_27693(": ").method_10852(dataStr), false);
            }
            return objects.size();
        }))).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<class_2168>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            for (WithPersistentData withPersistentData : objects) {
                class_2487 data = key.equals("*") ? withPersistentData.kjs$getPersistentData() : withPersistentData.kjs$getPersistentData().method_10580(key);
                class_2561 dataStr = data == null ? class_2561.method_43470((String)"null").method_27692(class_124.field_1061) : class_2512.method_32270((class_2520)data);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1054).method_10852(o.kjs$getDisplayName())).method_27693(": ").method_10852(dataStr), false);
            }
            return objects.size();
        })));
        cmd.then(class_2170.method_9247((String)"merge").then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<class_2168>)ctx);
            class_2487 tag = class_2179.method_9285((CommandContext)ctx, (String)"nbt");
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().method_10543(tag);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1054).method_10852(o.kjs$getDisplayName())).method_27693(" updated"), false);
            }
            return objects.size();
        })));
        cmd.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9247((String)"*").executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<class_2168>)ctx);
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().method_10541().removeIf(UtilsJS.ALWAYS_TRUE);
            }
            return objects.size();
        }))).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<class_2168>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().method_10551(key);
            }
            return objects.size();
        })));
        cmd.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"scoreboard").then(class_2170.method_9247((String)"import").then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"target", (ArgumentType)class_2233.method_9447()).suggests(class_2233.field_9951).then(class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(ctx -> {
            class_266 objective;
            class_2995 scoreboard = ((class_2168)ctx.getSource()).method_9211().method_3845();
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<class_2168>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            String target = class_2233.method_9452((CommandContext)ctx, (String)"target");
            int score = scoreboard.method_1183(target, objective = class_2214.method_9395((CommandContext)ctx, (String)"objective")) ? scoreboard.method_1180(target, objective).method_1126() : 0;
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().method_10569(key, score);
            }
            return objects.size();
        })))))).then(class_2170.method_9247((String)"export").then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2233.method_9451()).suggests(class_2233.field_9951).then(class_2170.method_9244((String)"objective", (ArgumentType)class_2214.method_9391()).executes(ctx -> {
            class_2995 scoreboard = ((class_2168)ctx.getSource()).method_9211().method_3845();
            WithPersistentData object = factory.getOne((CommandContext<class_2168>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            Collection targets = class_2233.method_9458((CommandContext)ctx, (String)"targets");
            class_266 objective = class_2214.method_9395((CommandContext)ctx, (String)"objective");
            int score = object.kjs$getPersistentData().method_10550(key);
            for (String target : targets) {
                scoreboard.method_1180(target, objective).method_1128(score);
            }
            return 1;
        }))))));
        return cmd;
    }

    @FunctionalInterface
    private static interface PersistentDataFactory {
        public static final SimpleCommandExceptionType EMPTY_LIST = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Expected at least one target"));

        public Collection<? extends WithPersistentData> apply(CommandContext<class_2168> var1) throws CommandSyntaxException;

        default public Collection<? extends WithPersistentData> getAll(CommandContext<class_2168> ctx) throws CommandSyntaxException {
            Collection<? extends WithPersistentData> list = this.apply(ctx);
            if (list.isEmpty()) {
                throw EMPTY_LIST.create();
            }
            return list;
        }

        default public WithPersistentData getOne(CommandContext<class_2168> ctx) throws CommandSyntaxException {
            Collection<? extends WithPersistentData> list = this.apply(ctx);
            if (list.isEmpty()) {
                throw EMPTY_LIST.create();
            }
            return list.iterator().next();
        }
    }
}

