/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.recipe.OutputReplacement;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class OutputItem
implements OutputReplacement {
    public static final OutputItem EMPTY = new OutputItem(class_1799.field_8037, Double.NaN, null);
    public final class_1799 item;
    public final double chance;
    public final class_6017 rolls;

    public static OutputItem of(class_1799 item, double chance) {
        return item.method_7960() ? EMPTY : new OutputItem(item, chance, null);
    }

    public static OutputItem of(Object from) {
        if (from instanceof OutputItem) {
            OutputItem out = (OutputItem)from;
            return out;
        }
        if (from instanceof class_1799) {
            class_1799 stack = (class_1799)from;
            return OutputItem.of(stack, Double.NaN);
        }
        class_1799 item = ItemStackJS.of(from);
        if (item.method_7960()) {
            return EMPTY;
        }
        double chance = Double.NaN;
        class_6019 rolls = null;
        if (from instanceof JsonObject) {
            JsonObject j = (JsonObject)from;
            if (j.has("chance")) {
                chance = j.get("chance").getAsDouble();
            }
            if (j.has("minRolls") && j.has("maxRolls")) {
                rolls = class_6019.method_35017((int)j.get("minRolls").getAsInt(), (int)j.get("maxRolls").getAsInt());
            }
        }
        return new OutputItem(item, chance, (class_6017)rolls);
    }

    @Deprecated
    protected OutputItem(class_1799 item, double chance) {
        this(item, chance, null);
    }

    protected OutputItem(class_1799 item, double chance, @Nullable class_6017 rolls) {
        this.item = item;
        this.chance = chance;
        this.rolls = rolls;
    }

    public OutputItem withCount(int count) {
        return new OutputItem(this.item.kjs$withCount(count), this.chance, this.rolls);
    }

    public OutputItem withChance(double chance) {
        return new OutputItem(this.item.method_7972(), chance, this.rolls);
    }

    public OutputItem withRolls(class_6017 rolls) {
        return new OutputItem(this.item.method_7972(), this.chance, rolls);
    }

    public OutputItem withRolls(int min, int max) {
        return this.withRolls((class_6017)class_6019.method_35017((int)min, (int)max));
    }

    public boolean hasChance() {
        return !Double.isNaN(this.chance);
    }

    public double getChance() {
        return this.chance;
    }

    public int getCount() {
        return this.item.method_7947();
    }

    public class_2487 getNbt() {
        return this.item.method_7969();
    }

    public String toString() {
        return this.item.kjs$toItemString();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public Object replaceOutput(RecipeJS recipe, ReplacementMatch match, OutputReplacement original) {
        if (original instanceof OutputItem) {
            OutputItem o = (OutputItem)original;
            OutputItem replacement = new OutputItem(this.item.method_7972(), o.chance, o.rolls);
            replacement.item.method_7939(o.getCount());
            return replacement;
        }
        return new OutputItem(this.item.method_7972(), Double.NaN, null);
    }

    @Deprecated
    public InputItem ignoreNBT() {
        ConsoleJS console = ConsoleJS.getCurrent(ConsoleJS.SERVER);
        console.warn("You don't need to call .ignoreNBT() anymore, all item ingredients ignore NBT by default!");
        return InputItem.of(this.item.method_7909().kjs$asIngredient(), this.item.method_7947());
    }

    public InputItem weakNBT() {
        return InputItem.of(IngredientPlatformHelper.get().weakNBT(this.item), this.item.method_7947());
    }

    public InputItem strongNBT() {
        return InputItem.of(IngredientPlatformHelper.get().strongNBT(this.item), this.item.method_7947());
    }
}

