/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import java.util.function.Predicate;
import net.minecraft.class_2960;

public record StringComponent(String error, Predicate<String> predicate) implements RecipeComponent<String>
{
    public static final RecipeComponent<String> ANY = new StringComponent("", s -> true);
    public static final RecipeComponent<String> NON_EMPTY = new StringComponent("can't be empty", s -> !s.isEmpty());
    public static final RecipeComponent<String> NON_BLANK = new StringComponent("can't be blank", s -> !s.isBlank());
    public static final RecipeComponent<String> ID = new StringComponent("invalid ID", class_2960::method_20207);
    public static final RecipeComponent<Character> CHARACTER = new RecipeComponent<Character>(){

        @Override
        public String componentType() {
            return "char";
        }

        @Override
        public Class<?> componentClass() {
            return Character.class;
        }

        @Override
        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.STRING;
        }

        @Override
        public JsonElement write(RecipeJS recipe, Character value) {
            return new JsonPrimitive(value);
        }

        @Override
        public Character read(RecipeJS recipe, Object from) {
            Character c;
            return from instanceof Character ? (c = (Character)from) : Character.valueOf(String.valueOf(from).charAt(0));
        }

        public String toString() {
            return this.componentType();
        }
    };

    @Override
    public String componentType() {
        return "string";
    }

    @Override
    public Class<?> componentClass() {
        return String.class;
    }

    @Override
    public TypeDescJS constructorDescription(DescriptionContext ctx) {
        return TypeDescJS.STRING;
    }

    public JsonPrimitive write(RecipeJS recipe, String value) {
        return new JsonPrimitive(value);
    }

    @Override
    public String read(RecipeJS recipe, Object from) {
        String str;
        if (from instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)from;
            v0 = json.getAsString();
        } else {
            v0 = str = String.valueOf(from);
        }
        if (!this.predicate.test(str)) {
            if (this.error.isEmpty()) {
                throw new IllegalArgumentException("Invalid string '" + str + "'");
            }
            throw new IllegalArgumentException("Invalid string '" + str + "': " + this.error);
        }
        return str;
    }

    @Override
    public boolean hasPriority(RecipeJS recipe, Object from) {
        JsonPrimitive json;
        return from instanceof CharSequence || from instanceof JsonPrimitive && (json = (JsonPrimitive)from).isString();
    }

    @Override
    public String toString() {
        return this.componentType();
    }
}

