/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public abstract class BuilderBase<T>
implements Supplier<T> {
    public final class_2960 id;
    protected T object;
    public String translationKey;
    public String displayName;
    public transient boolean dummyBuilder;
    public transient Set<class_2960> defaultTags;

    public BuilderBase(class_2960 i) {
        this.id = i;
        this.object = null;
        this.translationKey = "";
        this.displayName = "";
        this.dummyBuilder = false;
        this.defaultTags = new HashSet<class_2960>();
    }

    public abstract RegistryInfo getRegistryType();

    public abstract T createObject();

    public T transformObject(T obj) {
        return obj;
    }

    @Override
    public final T get() {
        try {
            return this.object;
        }
        catch (Exception ex) {
            if (this.dummyBuilder) {
                throw new RuntimeException("Object '" + this.id + "' of registry '" + this.getRegistryType().key.method_29177() + "' is from a dummy builder and doesn't have a value!");
            }
            throw new RuntimeException("Object '" + this.id + "' of registry '" + this.getRegistryType().key.method_29177() + "' hasn't been registered yet!", ex);
        }
    }

    public void createAdditionalObjects() {
    }

    public String getTranslationKeyGroup() {
        return this.getRegistryType().key.method_29177().method_12832();
    }

    @Info(value="Sets the translation key for this object, e.g. `block.minecraft.stone`.\n")
    public BuilderBase<T> translationKey(String key) {
        this.translationKey = key;
        return this;
    }

    @Info(value="Sets the display name for this object, e.g. `Stone`.\n\nThis will be overridden by a lang file if it exists.\n")
    public BuilderBase<T> displayName(String name) {
        this.displayName = name;
        return this;
    }

    @Info(value="Adds a tag to this object, e.g. `minecraft:stone`.\n")
    public BuilderBase<T> tag(class_2960 tag) {
        this.defaultTags.add(tag);
        this.getRegistryType().hasDefaultTags = true;
        return this;
    }

    public class_2960 newID(String pre, String post) {
        if (pre.isEmpty() && post.isEmpty()) {
            return this.id;
        }
        return new class_2960(this.id.method_12836() + ":" + pre + this.id.method_12832() + post);
    }

    public void generateDataJsons(DataJsonGenerator generator) {
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
    }

    public String getBuilderTranslationKey() {
        if (this.translationKey.isEmpty()) {
            return this.getTranslationKeyGroup() + "." + this.id.method_12836() + "." + this.id.method_12832();
        }
        return this.translationKey;
    }

    public void generateLang(LangEventJS lang) {
        String dname = this.displayName;
        if (dname.isEmpty()) {
            dname = UtilsJS.snakeCaseToTitleCase(this.id.method_12832());
        }
        lang.add(this.id.method_12836(), this.getBuilderTranslationKey(), dname);
    }

    protected T createTransformedObject() {
        this.object = this.transformObject(this.createObject());
        return this.object;
    }

    public String toString() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i != -1) {
            n = n.substring(i + 1);
        }
        return n + "[" + this.id + "]";
    }
}

