/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.script.ScriptTypePredicate;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public enum ScriptType implements ScriptTypePredicate,
ScriptTypeHolder
{
    STARTUP("startup", "KubeJS Startup", KubeJS::getStartupScriptManager),
    SERVER("server", "KubeJS Server", ServerScriptManager::getScriptManager),
    CLIENT("client", "KubeJS Client", KubeJS::getClientScriptManager);

    public static final ScriptType[] VALUES = ScriptType.values();
    public final String name;
    public final transient ConcurrentLinkedDeque<String> errors;
    public final transient ConcurrentLinkedDeque<String> warnings;
    public final ConsoleJS console;
    public final transient Supplier<ScriptManager> manager;
    public transient Executor executor;

    public static ScriptType getCurrent(Context cx) {
        return (ScriptType)cx.getProperty("Type");
    }

    private ScriptType(String n2, String cname, Supplier<ScriptManager> m) {
        this.name = n2;
        this.errors = new ConcurrentLinkedDeque();
        this.warnings = new ConcurrentLinkedDeque();
        this.console = new ConsoleJS(this, LoggerFactory.getLogger((String)cname));
        this.manager = m;
        this.executor = Runnable::run;
    }

    public Path getLogFile() {
        Path dir = Platform.getGameFolder().resolve("logs/kubejs");
        Path file = dir.resolve(this.name + ".log");
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                Path oldFile = dir.resolve(this.name + ".txt");
                if (Files.exists(oldFile, new LinkOption[0])) {
                    Files.move(oldFile, file, new CopyOption[0]);
                } else {
                    Files.createFile(file, new FileAttribute[0]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return file;
    }

    public boolean isClient() {
        return this == CLIENT;
    }

    public boolean isServer() {
        return this == SERVER;
    }

    public boolean isStartup() {
        return this == STARTUP;
    }

    @HideFromJS
    public void unload() {
        this.errors.clear();
        this.warnings.clear();
        this.console.resetFile();
        for (EventGroup group : EventGroup.getGroups().values()) {
            for (EventHandler handler : group.getHandlers().values()) {
                handler.clear(this);
            }
        }
    }

    public class_2561 errorsComponent(String command) {
        return class_2561.method_43470((String)("KubeJS errors found [" + this.errors.size() + "]! Run '" + command + "' for more info")).kjs$clickRunCommand(command).kjs$hover((class_2561)class_2561.method_43470((String)"Click to show")).method_27692(class_124.field_1079);
    }

    public class_2561 warningsComponent(String command) {
        return class_2561.method_43470((String)("KubeJS warnings found [" + this.warnings.size() + "]! Run '" + command + "' for more info")).kjs$clickRunCommand(command).kjs$hover((class_2561)class_2561.method_43470((String)"Click to show")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16753920)));
    }

    @Override
    public boolean test(ScriptType type) {
        return type == this;
    }

    @Override
    public List<ScriptType> getValidTypes() {
        return List.of(this);
    }

    @NotNull
    public ScriptTypePredicate negate() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case STARTUP -> ScriptTypePredicate.COMMON;
            case SERVER -> ScriptTypePredicate.STARTUP_OR_CLIENT;
            case CLIENT -> ScriptTypePredicate.STARTUP_OR_SERVER;
        };
    }

    @Override
    public ScriptType kjs$getScriptType() {
        return this;
    }
}

