/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script.data;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.script.data.ExportablePackResources;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualKubeJSDataPack
extends class_3255
implements ExportablePackResources {
    public final boolean high;
    private final Map<class_2960, String> locationToData;
    private final Map<String, String> pathToData;
    private final Set<String> namespaces;

    public VirtualKubeJSDataPack(boolean h) {
        super("dummy", false);
        this.high = h;
        this.locationToData = new HashMap<class_2960, String>();
        this.pathToData = new HashMap<String, String>();
        this.namespaces = new HashSet<String>();
    }

    public void addData(class_2960 id, String data) {
        this.locationToData.put(id, data);
        this.pathToData.put("data/" + id.method_12836() + "/" + id.method_12832(), data);
        this.namespaces.add(id.method_12836());
        if (DevProperties.get().dataPackOutput) {
            ConsoleJS.SERVER.info("Registered virtual file [" + (this.high ? "high" : "low") + " priority] '" + id + "': " + data);
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... path) {
        return switch (path.length == 1 ? path[0] : "") {
            case "pack.mcmeta" -> GeneratedData.PACK_META;
            case "pack.png" -> GeneratedData.PACK_ICON;
            default -> null;
        };
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        if (type != class_3264.field_14190) {
            return null;
        }
        String s = this.locationToData.get(location);
        if (s != null) {
            if (DevProperties.get().dataPackOutput) {
                ConsoleJS.SERVER.info("Served virtual file [" + (this.high ? "high" : "low") + " priority] '" + location + "': " + s);
            }
            return () -> new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 visitor) {
        for (class_2960 r : this.locationToData.keySet()) {
            if (r.method_12832().endsWith(".mcmeta") || !r.method_12836().equals(namespace) || !r.method_12832().startsWith(path)) continue;
            visitor.accept((Object)r, this.method_14405(packType, r));
        }
    }

    public Set<String> method_14406(class_3264 type) {
        return new HashSet<String>(this.namespaces);
    }

    @Nullable
    public <T> T method_14407(class_3270<T> serializer) {
        return null;
    }

    public String toString() {
        return this.method_14409();
    }

    @NotNull
    public String method_14409() {
        return "KubeJS Virtual Data Pack [" + (this.high ? "high" : "low") + " priority]";
    }

    @Override
    public void export(Path root) throws IOException {
        for (Map.Entry<String, String> file : this.pathToData.entrySet()) {
            Path path = root.resolve(file.getKey());
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)file.getValue(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    public void close() {
    }

    public boolean hasNamespace(String key) {
        return this.namespaces.contains(key);
    }
}

