/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawManager;
import com.yungnickyoung.minecraft.yungsapi.module.StructureTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptationType;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3785;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_5868;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import org.jetbrains.annotations.NotNull;

public class YungJigsawStructure
extends class_3195 {
    public static final int MAX_TOTAL_STRUCTURE_RADIUS = 128;
    public static final Codec<YungJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)YungJigsawStructure.method_42697((RecordCodecBuilder.Instance)builder), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)128).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_6017.method_35004((int)0, (int)15).optionalFieldOf("x_offset_in_chunk", (Object)class_6016.method_34998((int)0)).forGetter(structure -> structure.xOffsetInChunk), (App)class_6017.method_35004((int)0, (int)15).optionalFieldOf("z_offset_in_chunk", (Object)class_6016.method_34998((int)0)).forGetter(structure -> structure.zOffsetInChunk), (App)Codec.BOOL.optionalFieldOf("use_expansion_hack", (Object)false).forGetter(structure -> structure.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.optionalFieldOf("max_y").forGetter(structure -> structure.maxY), (App)Codec.INT.optionalFieldOf("min_y").forGetter(structure -> structure.minY), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation)).apply((Applicative)builder, YungJigsawStructure::new)).flatXmap(YungJigsawStructure.verifyRange(), YungJigsawStructure.verifyRange()).codec();
    public final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    public final int maxDepth;
    public final class_6122 startHeight;
    public final class_6017 xOffsetInChunk;
    public final class_6017 zOffsetInChunk;
    public final boolean useExpansionHack;
    public final Optional<class_2902.class_2903> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public final Optional<Integer> maxY;
    public final Optional<Integer> minY;
    public final EnhancedTerrainAdaptation enhancedTerrainAdaptation;

    public YungJigsawStructure(class_3195.class_7302 structureSettings, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int maxDepth, class_6122 startHeight, class_6017 xOffsetInChunk, class_6017 zOffsetInChunk, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxBlockDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY, EnhancedTerrainAdaptation enhancedTerrainAdaptation) {
        super(structureSettings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.xOffsetInChunk = xOffsetInChunk;
        this.zOffsetInChunk = zOffsetInChunk;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxBlockDistanceFromCenter;
        this.maxY = maxY;
        this.minY = minY;
        this.enhancedTerrainAdaptation = enhancedTerrainAdaptation;
    }

    private static Function<YungJigsawStructure, DataResult<YungJigsawStructure>> verifyRange() {
        return structure -> {
            int vanillaEdgeBuffer;
            if (structure.method_42701() != class_5847.field_28922 && structure.enhancedTerrainAdaptation != EnhancedTerrainAdaptation.NONE) {
                return DataResult.error(() -> "YUNG Structure cannot use both vanilla terrain_adaptation and enhanced_terrain_adaptation");
            }
            switch (structure.method_42701()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case field_28922: {
                    int n = 0;
                    break;
                }
                case field_28923: 
                case field_38431: 
                case field_38432: {
                    int n = vanillaEdgeBuffer = 12;
                }
            }
            if (structure.maxDistanceFromCenter + vanillaEdgeBuffer > 128) {
                return DataResult.error(() -> "YUNG Structure size including terrain adaptation must not exceed 128");
            }
            int enhancedEdgeBuffer = structure.enhancedTerrainAdaptation.getKernelRadius();
            return structure.maxDistanceFromCenter + enhancedEdgeBuffer > 128 ? DataResult.error(() -> "YUNG Structure size including enhanced terrain adaptation must not exceed 128") : DataResult.success((Object)structure);
        };
    }

    @NotNull
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        class_2919 randomSource = context.comp_566();
        int xOffset = this.xOffsetInChunk.method_35008((class_5819)randomSource);
        int zOffset = this.zOffsetInChunk.method_35008((class_5819)randomSource);
        int startY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 startPos = new class_2338(chunkPos.method_33939(xOffset), startY, chunkPos.method_33941(zOffset));
        return YungJigsawManager.assembleJigsawStructure(context, this.startPool, this.startJigsawName, this.maxDepth, startPos, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter, this.maxY, this.minY);
    }

    @NotNull
    public class_3341 method_41609(@NotNull class_3341 boundingBox) {
        return super.method_41609(boundingBox).method_35410(this.enhancedTerrainAdaptation.getKernelRadius());
    }

    @NotNull
    public class_7151<?> method_41618() {
        return StructureTypeModule.YUNG_JIGSAW;
    }
}

