/*
 * Decompiled with CFR 0.152.
 */
package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.entities.InfectedEntity;
import com.herobrinemod.herobrine.entities.SurvivorEntity;
import com.herobrinemod.herobrine.entities.goals.InfectedHorseAmbientStandGoal;
import com.herobrinemod.herobrine.items.ItemList;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1498;
import net.minecraft.class_1543;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedHorseEntity
extends InfectedEntity {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(InfectedHorseEntity.class, (class_2941)class_2943.field_13327);
    private static final int ANGRY_FLAG = 32;
    private static final int EATING_GRASS_FLAG = 16;
    private static final class_2940<Byte> FLAGS = class_2945.method_12791(InfectedHorseEntity.class, (class_2941)class_2943.field_13319);
    private int tailWagTicks;
    private int eatingGrassTicks;
    private float eatingGrassAnimationProgress;
    private float lastEatingGrassAnimationProgress;
    private float angryAnimationProgress;
    private float lastAngryAnimationProgress;
    private int angryTicks;

    public InfectedHorseEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.method_49477(1.0f);
        this.setConversionEntity(class_1299.field_6139);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1543.class, false));
        this.field_6201.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
        this.field_6201.method_6277(4, (class_1352)new class_1400((class_1308)this, SurvivorEntity.class, false));
        this.field_6201.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1427.class, false));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.3));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1543.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1427.class, 8.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(12, (class_1352)new InfectedHorseAmbientStandGoal(this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return InfectedHorseEntity.method_26918().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23719, 0.4);
    }

    @Override
    public void convert() {
        this.method_37908().method_8421((class_1297)this, (byte)16);
        this.method_5706((class_1935)ItemList.CURSED_DUST);
        class_1308 entity = this.method_29243(this.getConversionEntity(), false);
        assert (entity != null);
        entity.method_6092(new class_1293(class_1294.field_5924, 300, 1));
        entity.method_6092(new class_1293(class_1294.field_5914, 300, 1));
        entity.method_5943((class_5425)this.method_37908(), this.method_37908().method_8404(this.method_24515()), class_3730.field_16468, null, null);
        ((class_1498)entity).method_27076(this.getVariant(), this.getMarking());
    }

    public boolean method_6062() {
        return super.method_6062() || this.isEatingGrass() || this.isAngry();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(FLAGS, (Object)0);
    }

    protected boolean method_5795(int bitmask) {
        return ((Byte)this.field_6011.method_12789(FLAGS) & bitmask) != 0;
    }

    protected void method_5729(int bitmask, boolean flag) {
        byte b = (Byte)this.field_6011.method_12789(FLAGS);
        if (flag) {
            this.field_6011.method_12778(FLAGS, (Object)((byte)(b | bitmask)));
        } else {
            this.field_6011.method_12778(FLAGS, (Object)((byte)(b & ~bitmask)));
        }
    }

    public boolean isEatingGrass() {
        return this.method_5795(16);
    }

    public boolean isAngry() {
        return this.method_5795(32);
    }

    public void method_6007() {
        if (this.field_5974.method_43048(200) == 0) {
            this.wagTail();
        }
        super.method_6007();
        if (this.method_37908().field_9236 || !this.method_5805()) {
            return;
        }
        if (!this.isEatingGrass() && this.field_5974.method_43048(300) == 0 && this.method_37908().method_8320(this.method_24515().method_10074()).method_27852(class_2246.field_10219) && this.method_5968() == null) {
            this.setEatingGrass(true);
        }
        if (this.isEatingGrass() && ++this.eatingGrassTicks > 50) {
            this.eatingGrassTicks = 0;
            this.setEatingGrass(false);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_6034() && this.angryTicks > 0 && ++this.angryTicks > 20) {
            this.angryTicks = 0;
            this.setAngry(false);
        }
        if (this.tailWagTicks > 0 && ++this.tailWagTicks > 8) {
            this.tailWagTicks = 0;
        }
        this.lastEatingGrassAnimationProgress = this.eatingGrassAnimationProgress;
        if (this.isEatingGrass()) {
            this.eatingGrassAnimationProgress += (1.0f - this.eatingGrassAnimationProgress) * 0.4f + 0.05f;
            if (this.eatingGrassAnimationProgress > 1.0f) {
                this.eatingGrassAnimationProgress = 1.0f;
            }
        } else {
            this.eatingGrassAnimationProgress += (0.0f - this.eatingGrassAnimationProgress) * 0.4f - 0.05f;
            if (this.eatingGrassAnimationProgress < 0.0f) {
                this.eatingGrassAnimationProgress = 0.0f;
            }
        }
        this.lastAngryAnimationProgress = this.angryAnimationProgress;
        if (this.isAngry()) {
            this.eatingGrassAnimationProgress = 0.0f;
            this.lastEatingGrassAnimationProgress = 0.0f;
            this.angryAnimationProgress += (1.0f - this.angryAnimationProgress) * 0.4f + 0.05f;
            if (this.angryAnimationProgress > 1.0f) {
                this.angryAnimationProgress = 1.0f;
            }
        } else {
            this.field_6282 = false;
            this.angryAnimationProgress += (0.8f * this.angryAnimationProgress * this.angryAnimationProgress * this.angryAnimationProgress - this.angryAnimationProgress) * 0.6f - 0.05f;
            if (this.angryAnimationProgress < 0.0f) {
                this.angryAnimationProgress = 0.0f;
            }
        }
    }

    public void setEatingGrass(boolean eatingGrass) {
        this.method_5729(16, eatingGrass);
    }

    public float getEatingGrassAnimationProgress(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastEatingGrassAnimationProgress, (float)this.eatingGrassAnimationProgress);
    }

    public void setAngry(boolean angry) {
        if (angry) {
            this.setEatingGrass(false);
        }
        this.method_5729(32, angry);
    }

    public void updateAnger() {
        if (this.method_6034()) {
            this.angryTicks = 1;
            this.setAngry(true);
        }
    }

    private void wagTail() {
        this.tailWagTicks = 1;
    }

    public int getTailWagTicks() {
        return this.tailWagTicks;
    }

    public float getEatingAnimationProgress(float tickDelta) {
        return class_3532.method_48781((float)tickDelta, (int)0, (int)0);
    }

    public float getAngryAnimationProgress(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastAngryAnimationProgress, (float)this.angryAnimationProgress);
    }

    protected float method_18394(class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 * 0.95f;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        int i;
        if (fallDistance > 1.0f) {
            this.method_5783(class_3417.field_14783, 0.4f, 1.0f);
        }
        if ((i = this.method_23329(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.method_5643(damageSource, i);
        if (this.method_5782()) {
            for (class_1297 entity : this.method_5736()) {
                entity.method_5643(damageSource, (float)i);
            }
        }
        this.method_23328();
        return true;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getHorseVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHorseVariant(nbt.method_10550("Variant"));
    }

    private void setHorseVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    private int getHorseVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public class_5149 getVariant() {
        return class_5149.method_27083((int)(this.getHorseVariant() & 0xFF));
    }

    private void setHorseVariant(@NotNull class_5149 color, @NotNull class_5148 marking) {
        this.setHorseVariant(color.method_27082() & 0xFF | marking.method_27079() << 8 & 0xFF00);
    }

    public class_5148 getMarking() {
        return class_5148.method_27080((int)((this.getHorseVariant() & 0xFF00) >> 8));
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_5149 horseColor;
        class_5819 random = world.method_8409();
        if (entityData instanceof class_1498.class_1499) {
            horseColor = ((class_1498.class_1499)entityData).field_6994;
        } else {
            horseColor = (class_5149)class_156.method_27173((Object[])class_5149.values(), (class_5819)random);
            entityData = new class_1498.class_1499(horseColor);
        }
        this.setHorseVariant(horseColor, (class_5148)class_156.method_27173((Object[])class_5148.values(), (class_5819)random));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public int method_5970() {
        return 400;
    }

    public int getMinAmbientStandDelay() {
        return this.method_5970();
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return class_3532.method_15386((float)((fallDistance * 0.5f - 3.0f) * damageMultiplier));
    }

    protected class_3414 method_5994() {
        return class_3417.field_14947;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15166;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14923;
    }

    @Nullable
    public class_3414 getAmbientStandSound() {
        return class_3417.field_14947;
    }

    protected void method_5712(class_2338 pos, @NotNull class_2680 state) {
        if (state.method_51176()) {
            return;
        }
        class_2498 blockSoundGroup = state.method_26231();
        if (blockSoundGroup == class_2498.field_11547) {
            this.method_5783(class_3417.field_15061, blockSoundGroup.method_10597() * 0.15f, blockSoundGroup.method_10599());
        } else {
            this.method_5783(class_3417.field_14613, blockSoundGroup.method_10597() * 0.15f, blockSoundGroup.method_10599());
        }
    }
}

