/*
 * Decompiled with CFR 0.152.
 */
package com.herobrinemod.herobrine.entities;

import com.herobrinemod.herobrine.entities.EntityTypeList;
import com.herobrinemod.herobrine.entities.HerobrineSpawnHelper;
import com.herobrinemod.herobrine.entities.InfectedCowEntity;
import com.herobrinemod.herobrine.entities.InfectedEntity;
import com.herobrinemod.herobrine.items.ItemList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1438;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1830;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5147;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7917;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedMooshroomEntity
extends InfectedCowEntity
implements class_5147 {
    private static final class_2940<String> TYPE = class_2945.method_12791(InfectedMooshroomEntity.class, (class_2941)class_2943.field_13326);
    @Nullable
    private class_1291 stewEffect;
    private int stewEffectDuration;
    @Nullable
    private UUID lightningId;

    public InfectedMooshroomEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.setConversionEntity(class_1299.field_6143);
    }

    public static boolean canMooshroomSpawn(class_1299<? extends InfectedEntity> type, @NotNull class_5425 world, class_3730 spawnReason, class_2338 pos, @NotNull class_5819 random) {
        return random.method_43048(20) == 1 && world.method_8407() != class_1267.field_5801 && world.method_8320(pos.method_10074()).method_26164(class_3481.field_35570) && InfectedMooshroomEntity.method_20679((class_5425)world, (class_2338)pos, (class_5819)random) && InfectedMooshroomEntity.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && HerobrineSpawnHelper.canHerobrineSpawn() && HerobrineSpawnHelper.getStage() > 1;
    }

    @Override
    public void convert() {
        this.method_37908().method_8421((class_1297)this, (byte)16);
        this.method_5706((class_1935)ItemList.CURSED_DUST);
        class_1308 entity = this.method_29243(this.getConversionEntity(), false);
        assert (entity != null);
        entity.method_6092(new class_1293(class_1294.field_5924, 300, 1));
        entity.method_6092(new class_1293(class_1294.field_5914, 300, 1));
        ((class_1438)entity).method_47846(class_1438.class_4053.valueOf((String)this.getVariant().toString()));
        entity.method_5943((class_5425)this.method_37908(), this.method_37908().method_8404(this.method_24515()), class_3730.field_16468, null, null);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TYPE, (Object)Type.RED.name);
    }

    public boolean method_27072() {
        return this.method_5805();
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Type", this.getVariant().method_15434());
        if (this.stewEffect != null) {
            nbt.method_10569("EffectId", class_1291.method_5554((class_1291)this.stewEffect));
            nbt.method_10569("EffectDuration", this.stewEffectDuration);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Type.fromName(nbt.method_10558("Type")));
        if (nbt.method_10573("EffectId", 1)) {
            this.stewEffect = class_1291.method_5569((int)nbt.method_10550("EffectId"));
        }
        if (nbt.method_10573("EffectDuration", 3)) {
            this.stewEffectDuration = nbt.method_10550("EffectDuration");
        }
    }

    public void setVariant(@NotNull Type type) {
        this.field_6011.method_12778(TYPE, (Object)type.name);
    }

    public Type getVariant() {
        return Type.fromName((String)this.field_6011.method_12789(TYPE));
    }

    private Optional<Pair<class_1291, Integer>> getStewEffectFrom(@NotNull class_1799 flower) {
        class_7917 suspiciousStewIngredient = class_7917.method_47380((class_1935)flower.method_7909());
        if (suspiciousStewIngredient != null) {
            return Optional.of(Pair.of((Object)suspiciousStewIngredient.method_10188(), (Object)suspiciousStewIngredient.method_10187()));
        }
        return Optional.empty();
    }

    public void method_5800(class_3218 world, @NotNull class_1538 lightning) {
        UUID uUID = lightning.method_5667();
        if (!uUID.equals(this.lightningId)) {
            this.setVariant(this.getVariant() == Type.RED ? Type.BROWN : Type.RED);
            this.lightningId = uUID;
            this.method_5783(class_3417.field_18266, 2.0f, 1.0f);
        }
    }

    @Override
    public class_1269 method_5992(@NotNull class_1657 player2, class_1268 hand) {
        class_1799 itemStack = player2.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8428) && !this.method_6109()) {
            class_1799 itemStack2;
            boolean bl = false;
            if (this.stewEffect != null) {
                bl = true;
                itemStack2 = new class_1799((class_1935)class_1802.field_8766);
                class_1830.method_8021((class_1799)itemStack2, (class_1291)this.stewEffect, (int)this.stewEffectDuration);
                this.stewEffect = null;
                this.stewEffectDuration = 0;
            } else {
                itemStack2 = new class_1799((class_1935)class_1802.field_8208);
            }
            class_1799 itemStack3 = class_5328.method_30270((class_1799)itemStack, (class_1657)player2, (class_1799)itemStack2, (boolean)false);
            player2.method_6122(hand, itemStack3);
            class_3414 soundEvent = bl ? class_3417.field_18269 : class_3417.field_18268;
            this.method_5783(soundEvent, 1.0f, 1.0f);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (itemStack.method_31574(class_1802.field_8868) && this.method_27072()) {
            this.method_6636(class_3419.field_15248);
            this.method_32875(class_5712.field_28730, (class_1297)player2);
            if (!this.method_37908().field_9236) {
                itemStack.method_7956(1, (class_1309)player2, player -> player.method_20236(hand));
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.getVariant() == Type.BROWN && itemStack.method_31573(class_3489.field_15543)) {
            if (this.stewEffect != null) {
                for (int i = 0; i < 2; ++i) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + this.field_5974.method_43058() / 2.0, this.method_23323(0.5), this.method_23321() + this.field_5974.method_43058() / 2.0, 0.0, this.field_5974.method_43058() / 5.0, 0.0);
                }
            } else {
                Optional<Pair<class_1291, Integer>> optional = this.getStewEffectFrom(itemStack);
                if (optional.isEmpty()) {
                    return class_1269.field_5811;
                }
                Pair<class_1291, Integer> pair = optional.get();
                if (!player2.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                for (int j = 0; j < 4; ++j) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11245, this.method_23317() + this.field_5974.method_43058() / 2.0, this.method_23323(0.5), this.method_23321() + this.field_5974.method_43058() / 2.0, 0.0, this.field_5974.method_43058() / 5.0, 0.0);
                }
                this.stewEffect = (class_1291)pair.getLeft();
                this.stewEffectDuration = (Integer)pair.getRight();
                this.method_5783(class_3417.field_18267, 2.0f, 1.0f);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player2, hand);
    }

    public float method_6144(@NotNull class_2338 pos, @NotNull class_4538 world) {
        if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10402)) {
            return 10.0f;
        }
        return world.method_42309(pos);
    }

    public void method_6636(class_3419 shearedSoundCategory) {
        InfectedCowEntity entity;
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14705, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.method_37908().method_8608() && (entity = (InfectedCowEntity)EntityTypeList.INFECTED_COW.method_5883(this.method_37908())) != null) {
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23323(0.5), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
            this.method_31472();
            entity.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            entity.method_6033(this.method_6032());
            entity.field_6283 = this.field_6283;
            if (this.method_16914()) {
                entity.method_5665(this.method_5797());
                entity.method_5880(this.method_5807());
            }
            if (this.method_5947()) {
                entity.method_5971();
            }
            entity.method_5684(this.method_5655());
            this.method_37908().method_8649((class_1297)entity);
            for (int i = 0; i < 5; ++i) {
                this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23323(1.0), this.method_23321(), new class_1799((class_1935)this.getVariant().mushroom.method_26204())));
            }
        }
    }

    public static enum Type implements class_3542
    {
        RED("red", class_2246.field_10559.method_9564()),
        BROWN("brown", class_2246.field_10251.method_9564());

        public static final class_3542.class_7292<Type> CODEC;
        final String name;
        final class_2680 mushroom;

        private Type(String name, class_2680 mushroom) {
            this.name = name;
            this.mushroom = mushroom;
        }

        public class_2680 getMushroomState() {
            return this.mushroom;
        }

        public String method_15434() {
            return this.name;
        }

        static Type fromName(String name) {
            return (Type)CODEC.method_47920(name, (Enum)RED);
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }
}

