/*
 * Decompiled with CFR 0.152.
 */
package com.herobrinemod.herobrine.entities;

import com.google.common.collect.Maps;
import com.herobrinemod.herobrine.entities.InfectedEntity;
import com.herobrinemod.herobrine.entities.SurvivorEntity;
import com.herobrinemod.herobrine.items.ItemList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1345;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1472;
import net.minecraft.class_1542;
import net.minecraft.class_1543;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedSheepEntity
extends InfectedEntity
implements class_5147 {
    private static final class_2940<Byte> COLOR = class_2945.method_12791(InfectedSheepEntity.class, (class_2941)class_2943.field_13319);
    private static final Map<class_1767, class_1935> DROPS = (Map)class_156.method_654((Object)Maps.newEnumMap(class_1767.class), map -> {
        map.put(class_1767.field_7952, class_2246.field_10446);
        map.put(class_1767.field_7946, class_2246.field_10095);
        map.put(class_1767.field_7958, class_2246.field_10215);
        map.put(class_1767.field_7951, class_2246.field_10294);
        map.put(class_1767.field_7947, class_2246.field_10490);
        map.put(class_1767.field_7961, class_2246.field_10028);
        map.put(class_1767.field_7954, class_2246.field_10459);
        map.put(class_1767.field_7944, class_2246.field_10423);
        map.put(class_1767.field_7967, class_2246.field_10222);
        map.put(class_1767.field_7955, class_2246.field_10619);
        map.put(class_1767.field_7945, class_2246.field_10259);
        map.put(class_1767.field_7966, class_2246.field_10514);
        map.put(class_1767.field_7957, class_2246.field_10113);
        map.put(class_1767.field_7942, class_2246.field_10170);
        map.put(class_1767.field_7964, class_2246.field_10314);
        map.put(class_1767.field_7963, class_2246.field_10146);
    });
    private static final EnumMap<class_1767, float[]> COLORS = Maps.newEnumMap(Arrays.stream(class_1767.values()).collect(Collectors.toMap(color -> color, InfectedSheepEntity::getDyedColor)));
    private int eatGrassTimer;
    private class_1345 eatGrassGoal;

    @Contract(value="_ -> new", pure=true)
    private static float @NotNull [] getDyedColor(class_1767 color) {
        if (color == class_1767.field_7952) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] fs = color.method_7787();
        return new float[]{fs[0] * 0.75f, fs[1] * 0.75f, fs[2] * 0.75f};
    }

    public static float[] getRgbColor(class_1767 dyeColor) {
        return COLORS.get(dyeColor);
    }

    public InfectedSheepEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.setConversionEntity(class_1299.field_6115);
    }

    @Override
    public void convert() {
        this.method_37908().method_8421((class_1297)this, (byte)16);
        this.method_5706((class_1935)ItemList.CURSED_DUST);
        class_1472 entity = (class_1472)this.method_29243(this.getConversionEntity(), false);
        assert (entity != null);
        entity.method_6635(this.isSheared());
        entity.method_6092(new class_1293(class_1294.field_5924, 300, 1));
        entity.method_6092(new class_1293(class_1294.field_5914, 300, 1));
        entity.method_5943((class_5425)this.method_37908(), this.method_37908().method_8404(this.method_24515()), class_3730.field_16468, null, null);
        entity.method_6631(this.getColor());
    }

    protected void method_5959() {
        this.eatGrassGoal = new class_1345((class_1308)this);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)this.eatGrassGoal);
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1543.class, false));
        this.field_6201.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
        this.field_6201.method_6277(5, (class_1352)new class_1400((class_1308)this, SurvivorEntity.class, false));
        this.field_6201.method_6277(6, (class_1352)new class_1400((class_1308)this, class_1427.class, false));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1543.class, 8.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, SurvivorEntity.class, 8.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1427.class, 8.0f));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 registerAttributes() {
        return InfectedSheepEntity.method_26918().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23719, 0.23);
    }

    protected void method_5958() {
        this.eatGrassTimer = this.eatGrassGoal.method_6258();
        super.method_5958();
    }

    public void method_6007() {
        if (this.method_37908().field_9236) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        super.method_6007();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)0);
    }

    @Override
    public class_2960 method_5991() {
        if (this.isSheared()) {
            return super.method_5991();
        }
        return switch (this.getColor()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1767.field_7952 -> class_39.field_869;
            case class_1767.field_7946 -> class_39.field_814;
            case class_1767.field_7958 -> class_39.field_224;
            case class_1767.field_7951 -> class_39.field_461;
            case class_1767.field_7947 -> class_39.field_385;
            case class_1767.field_7961 -> class_39.field_702;
            case class_1767.field_7954 -> class_39.field_629;
            case class_1767.field_7944 -> class_39.field_878;
            case class_1767.field_7967 -> class_39.field_806;
            case class_1767.field_7955 -> class_39.field_365;
            case class_1767.field_7945 -> class_39.field_285;
            case class_1767.field_7966 -> class_39.field_394;
            case class_1767.field_7957 -> class_39.field_489;
            case class_1767.field_7942 -> class_39.field_607;
            case class_1767.field_7964 -> class_39.field_716;
            case class_1767.field_7963 -> class_39.field_778;
        };
    }

    @Override
    public void method_5711(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        } else {
            super.method_5711(status);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.eatGrassTimer >= 4 && this.eatGrassTimer <= 36) {
            return 1.0f;
        }
        if (this.eatGrassTimer < 4) {
            return ((float)this.eatGrassTimer - delta) / 4.0f;
        }
        return -((float)(this.eatGrassTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatGrassTimer > 4 && this.eatGrassTimer <= 36) {
            float f = ((float)(this.eatGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(f * 28.7f));
        }
        if (this.eatGrassTimer > 0) {
            return 0.62831855f;
        }
        return this.method_36455() * ((float)Math.PI / 180);
    }

    public class_1269 method_5992(class_1657 player2, class_1268 hand) {
        class_1799 itemStack = player2.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8868)) {
            if (!this.method_37908().field_9236 && this.method_27072()) {
                this.method_6636(class_3419.field_15248);
                this.method_32875(class_5712.field_28730, (class_1297)player2);
                itemStack.method_7956(1, (class_1309)player2, player -> player.method_20236(hand));
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player2, hand);
    }

    public boolean method_27072() {
        return this.method_5805() && !this.isSheared();
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Sheared", this.isSheared());
        nbt.method_10567("Color", (byte)this.getColor().method_7789());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setSheared(nbt.method_10577("Sheared"));
        this.setColor(class_1767.method_7791((int)nbt.method_10571("Color")));
    }

    public class_1767 getColor() {
        return class_1767.method_7791((int)((Byte)this.field_6011.method_12789(COLOR) & 0xF));
    }

    public void setColor(class_1767 color) {
        byte b = (Byte)this.field_6011.method_12789(COLOR);
        this.field_6011.method_12778(COLOR, (Object)((byte)(b & 0xF0 | color.method_7789() & 0xF)));
    }

    public boolean isSheared() {
        return ((Byte)this.field_6011.method_12789(COLOR) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b = (Byte)this.field_6011.method_12789(COLOR);
        if (sheared) {
            this.field_6011.method_12778(COLOR, (Object)((byte)(b | 0x10)));
        } else {
            this.field_6011.method_12778(COLOR, (Object)((byte)(b & 0xFFFFFFEF)));
        }
    }

    public void method_5983() {
        super.method_5983();
        this.setSheared(false);
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setColor(InfectedSheepEntity.generateDefaultColor(world.method_8409()));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static class_1767 generateDefaultColor(@NotNull class_5819 random) {
        int i = random.method_43048(100);
        if (i < 5) {
            return class_1767.field_7963;
        }
        if (i < 10) {
            return class_1767.field_7944;
        }
        if (i < 15) {
            return class_1767.field_7967;
        }
        if (i < 18) {
            return class_1767.field_7957;
        }
        if (random.method_43048(500) == 0) {
            return class_1767.field_7954;
        }
        return class_1767.field_7952;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.95f * dimensions.field_18068;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14603;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14730;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14814;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14870, 0.15f, 1.0f);
    }

    public void method_6636(class_3419 shearedSoundCategory) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14975, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.field_5974.method_43048(3);
        for (int j = 0; j < i; ++j) {
            class_1542 itemEntity = this.method_5870(DROPS.get(this.getColor()), 1);
            if (itemEntity == null) continue;
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
        }
    }
}

