/*
 * Decompiled with CFR 0.152.
 */
package com.herobrinemod.herobrine.savedata;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_310;

public class Config {
    private JsonObject json;
    private final String directory = FabricLoaderImpl.INSTANCE.getConfigDir().toString() + "/";
    private final String path;

    public Config(String fileName) {
        this.path = this.directory + fileName;
        try {
            this.json = (JsonObject)JsonParser.parseReader((Reader)new FileReader(this.path));
        }
        catch (Exception e) {
            this.json = null;
        }
    }

    public int readInt(String dataName) {
        if (this.json.get(dataName) == null || this.json == null) {
            System.out.println("[The Legend of Herobrine/Config/ERROR]: Integer \"" + dataName + "\" Could not be found!");
            return 0;
        }
        return this.json.get(dataName).getAsInt();
    }

    public double readDouble(String dataName) {
        if (this.json.get(dataName) == null || this.json == null) {
            System.out.println("[The Legend of Herobrine/Config/ERROR]: Double \"" + dataName + "\" Could not be found!");
            return 0.0;
        }
        return this.json.get(dataName).getAsDouble();
    }

    public float readFloat(String dataName) {
        if (this.json.get(dataName) == null || this.json == null) {
            System.out.println("[The Legend of Herobrine/Config/ERROR]: Float \"" + dataName + "\" Could not be found!");
            return 0.0f;
        }
        return this.json.get(dataName).getAsFloat();
    }

    public boolean readBoolean(String dataName) {
        if (this.json.get(dataName) == null || this.json == null) {
            System.out.println("[The Legend of Herobrine/Config/ERROR]: Boolean \"" + dataName + "\" Could not be found!");
            return false;
        }
        return this.json.get(dataName).getAsBoolean();
    }

    public JsonObject getJson() {
        return this.json;
    }

    public String getPath() {
        return this.path;
    }

    public void setFile(byte[] newJson) {
        try {
            this.json = JsonParser.parseString((String)new String(newJson)).getAsJsonObject();
            if (!new File(this.directory).exists()) {
                Files.createDirectory(Path.of(class_310.method_1551().field_1697.getAbsolutePath() + "/config/", new String[0]), new FileAttribute[0]);
            }
            Files.write(Paths.get(this.path, new String[0]), newJson, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

