/*
 * Decompiled with CFR 0.152.
 */
package com.herobrinemod.herobrine.savedata;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class WorldSaveData {
    private JsonObject json;
    private final String fileName;
    private final String jsonPath;

    public WorldSaveData(@NotNull MinecraftServer server, String fileName) {
        this.fileName = fileName;
        String path = Objects.requireNonNull(server).method_27050(class_5218.field_24188).toString();
        this.jsonPath = path.substring(0, path.length() - 1) + fileName;
        try {
            this.json = (JsonObject)JsonParser.parseReader((Reader)new FileReader(this.jsonPath));
        }
        catch (FileNotFoundException e) {
            this.json = null;
        }
    }

    public int readInt(String dataName) {
        if (this.json == null || this.json.get(dataName) == null) {
            return 0;
        }
        return this.json.get(dataName).getAsInt();
    }

    public double readDouble(String dataName) {
        if (this.json == null || this.json.get(dataName) == null) {
            return 0.0;
        }
        return this.json.get(dataName).getAsDouble();
    }

    public boolean readBoolean(String dataName) {
        if (this.json == null || this.json.get(dataName) == null) {
            return false;
        }
        return this.json.get(dataName).getAsBoolean();
    }

    public void writeInt(String dataName, int dataValue) {
        if (this.json == null) {
            this.json = new JsonObject();
        }
        this.json.addProperty(dataName, (Number)dataValue);
        try {
            Files.write(Paths.get(this.jsonPath, new String[0]), this.json.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.out.println("[The Legend of Herobrine/Save Data/ERROR]: Integer \"" + dataName + "\" Could not be written!");
            e.printStackTrace();
        }
    }

    public void writeDouble(String dataName, double dataValue) {
        if (this.json == null) {
            this.json = new JsonObject();
        }
        this.json.addProperty(dataName, (Number)dataValue);
        try {
            Files.write(Paths.get(this.jsonPath, new String[0]), this.json.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.out.println("[The Legend of Herobrine/Save Data/ERROR]: Double \"" + dataName + "\" Could not be written!");
            e.printStackTrace();
        }
    }

    public void writeBoolean(String dataName, boolean dataValue) {
        if (this.json == null) {
            this.json = new JsonObject();
        }
        this.json.addProperty(dataName, Boolean.valueOf(dataValue));
        try {
            Files.write(Paths.get(this.jsonPath, new String[0]), this.json.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.out.println("[The Legend of Herobrine/Save Data/ERROR]: Boolean \"" + dataName + "\" Could not be written!");
            e.printStackTrace();
        }
    }

    public JsonObject getJson() {
        return this.json;
    }

    public String getFileName() {
        return this.fileName;
    }
}

