/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.internal;

import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.internal.LinkReferenceDefinitionParser;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.node.Block;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.node.LinkReferenceDefinition;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.node.Paragraph;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.node.SourceSpan;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.parser.InlineParser;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.parser.SourceLine;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.parser.SourceLines;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.parser.block.BlockContinue;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.parser.block.ParserState;
import java.util.List;

public class ParagraphParser
extends AbstractBlockParser {
    private final Paragraph block = new Paragraph();
    private final LinkReferenceDefinitionParser linkReferenceDefinitionParser = new LinkReferenceDefinitionParser();

    @Override
    public boolean canHaveLazyContinuationLines() {
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (!state.isBlank()) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.linkReferenceDefinitionParser.parse(line);
    }

    @Override
    public void addSourceSpan(SourceSpan sourceSpan) {
        this.linkReferenceDefinitionParser.addSourceSpan(sourceSpan);
    }

    @Override
    public void closeBlock() {
        if (this.linkReferenceDefinitionParser.getParagraphLines().isEmpty()) {
            this.block.unlink();
        } else {
            this.block.setSourceSpans(this.linkReferenceDefinitionParser.getParagraphSourceSpans());
        }
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        SourceLines lines = this.linkReferenceDefinitionParser.getParagraphLines();
        if (!lines.isEmpty()) {
            inlineParser.parse(lines, this.block);
        }
    }

    public SourceLines getParagraphLines() {
        return this.linkReferenceDefinitionParser.getParagraphLines();
    }

    public List<LinkReferenceDefinition> getDefinitions() {
        return this.linkReferenceDefinitionParser.getDefinitions();
    }
}

