/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.internal.inline;

import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.internal.inline.InlineContentParser;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.internal.inline.InlineParserState;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.internal.inline.ParsedInline;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.internal.inline.Position;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.internal.inline.Scanner;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.node.Link;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.node.Text;
import dev.dediamondpro.resourcify.libs.elementa.impl.commonmark.parser.SourceLines;
import java.util.regex.Pattern;

public class AutolinkInlineParser
implements InlineContentParser {
    private static final Pattern URI = Pattern.compile("^[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*$");
    private static final Pattern EMAIL = Pattern.compile("^([a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)$");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        Position textStart = scanner.position();
        if (scanner.find('>') > 0) {
            SourceLines textSource = scanner.getSource(textStart, scanner.position());
            String content = textSource.getContent();
            scanner.next();
            String destination = null;
            if (URI.matcher(content).matches()) {
                destination = content;
            } else if (EMAIL.matcher(content).matches()) {
                destination = "mailto:" + content;
            }
            if (destination != null) {
                Link link = new Link(destination, null);
                Text text = new Text(content);
                text.setSourceSpans(textSource.getSourceSpans());
                link.appendChild(text);
                return ParsedInline.of(link, scanner.position());
            }
        }
        return ParsedInline.none();
    }
}

