/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.markdown.drawables;

import dev.dediamondpro.resourcify.libs.elementa.components.UIBlock;
import dev.dediamondpro.resourcify.libs.elementa.markdown.BlockquoteConfig;
import dev.dediamondpro.resourcify.libs.elementa.markdown.DrawState;
import dev.dediamondpro.resourcify.libs.elementa.markdown.MarkdownComponent;
import dev.dediamondpro.resourcify.libs.elementa.markdown.drawables.BlockquoteDrawable;
import dev.dediamondpro.resourcify.libs.elementa.markdown.drawables.Drawable;
import dev.dediamondpro.resourcify.libs.elementa.markdown.drawables.DrawableList;
import dev.dediamondpro.resourcify.libs.elementa.markdown.drawables.ParagraphDrawable;
import dev.dediamondpro.resourcify.libs.elementa.markdown.selection.Cursor;
import gg.essential.universal.UMatrixStack;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u00100\u001a\u00020/\u0012\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b1\u00102J3\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0017\u0010'\u001a\u00020&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R$\u0010,\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b,\u0010%\u001a\u0004\b-\u0010.\u00a8\u00063"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/BlockquoteDrawable;", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/Drawable;", "", "mouseX", "mouseY", "", "dragged", "", "mouseButton", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/selection/Cursor;", "cursorAt", "(FFZI)Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtEnd", "()Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtStart", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/DrawState;", "state", "", "draw", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/DrawState;)V", "x", "y", "width", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "asMarkdown", "", "selectedText", "(Z)Ljava/lang/String;", "", "getChildren", "()Ljava/util/List;", "children", "dividerHeight", "F", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/DrawableList;", "drawables", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/DrawableList;", "getDrawables", "()Lgg/essential/elementa/markdown/drawables/DrawableList;", "<set-?>", "maxTextLineWidth", "getMaxTextLineWidth", "()F", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/MarkdownComponent;", "md", "<init>", "(Lgg/essential/elementa/markdown/MarkdownComponent;Lgg/essential/elementa/markdown/drawables/DrawableList;)V", "Elementa"})
public final class BlockquoteDrawable
extends Drawable {
    @NotNull
    private final DrawableList drawables;
    private float dividerHeight;
    private float maxTextLineWidth;

    public BlockquoteDrawable(@NotNull MarkdownComponent md, @NotNull DrawableList drawables) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)drawables, (String)"drawables");
        super(md);
        this.drawables = drawables;
        this.dividerHeight = -1.0f;
        this.drawables.setParent(this);
    }

    @NotNull
    public final DrawableList getDrawables() {
        return this.drawables;
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return this.drawables;
    }

    public final float getMaxTextLineWidth() {
        return this.maxTextLineWidth;
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        Float f;
        BlockquoteConfig config = this.getConfig().getBlockquoteConfig();
        float padding = config.getSpaceBeforeDivider() + config.getDividerWidth() + config.getSpaceAfterDivider();
        float currY = 0.0f;
        currY = y;
        float dividerStart = currY += this.getInsertSpaceBefore() ? config.getSpaceBeforeBlockquote() : 0.0f;
        currY += config.getDividerPaddingTop();
        Drawable.Companion.trim(this.drawables);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            currY += it.layout(x + padding, currY, width - padding).getHeight();
        }
        this.dividerHeight = (currY += config.getDividerPaddingBottom()) - dividerStart;
        if (this.getInsertSpaceAfter()) {
            currY += config.getSpaceAfterBlockquote();
        }
        float height = currY - y;
        Iterable iterable = this.drawables;
        BlockquoteDrawable blockquoteDrawable = this;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            f = null;
        } else {
            float f2;
            float f3;
            float f4;
            Drawable drawable = (Drawable)iterator.next();
            boolean bl = false;
            ParagraphDrawable paragraphDrawable = drawable instanceof ParagraphDrawable ? (ParagraphDrawable)drawable : null;
            if (paragraphDrawable == null) {
                f4 = 0.0f;
            } else {
                float f5 = paragraphDrawable.getMaxTextLineWidth();
                f4 = f3 = (f2 = f5 + padding);
            }
            while (iterator.hasNext()) {
                float f6;
                Drawable drawable2 = (Drawable)iterator.next();
                $i$a$-maxOfOrNull-BlockquoteDrawable$layoutImpl$2 = false;
                ParagraphDrawable paragraphDrawable2 = drawable2 instanceof ParagraphDrawable ? (ParagraphDrawable)drawable2 : null;
                if (paragraphDrawable2 == null) {
                    f6 = 0.0f;
                } else {
                    float f7;
                    f2 = paragraphDrawable2.getMaxTextLineWidth();
                    f6 = f7 = f2 + padding;
                }
                float f8 = f6;
                f3 = Math.max(f3, f8);
            }
            f = Float.valueOf(f3);
        }
        Float f9 = f;
        blockquoteDrawable.maxTextLineWidth = f9 == null ? 0.0f : f9.floatValue();
        return new Drawable.Layout(x, y, width, height, new Drawable.Margin(0.0f, config.getSpaceBeforeBlockquote(), 0.0f, config.getSpaceAfterBlockquote()));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        UIBlock.Companion.drawBlockSized(matrixStack, this.getConfig().getBlockquoteConfig().getDividerColor(), (double)(this.getX() + state.getXShift()) + (double)this.getConfig().getBlockquoteConfig().getSpaceBeforeDivider(), (double)(this.getY() + state.getYShift()) + (double)this.getConfig().getBlockquoteConfig().getSpaceBeforeBlockquote(), this.getConfig().getBlockquoteConfig().getDividerWidth(), this.dividerHeight);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            it.drawCompat(matrixStack, state);
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        return this.drawables.cursorAt(mouseX, mouseY, dragged, mouseButton);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        return this.drawables.cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        return this.drawables.cursorAtEnd();
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (!this.hasSelectedText()) {
            return "";
        }
        String text = this.drawables.selectedText(asMarkdown);
        return asMarkdown ? CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)text), (CharSequence)"\n", null, null, (int)0, null, (Function1)selectedText.1.INSTANCE, (int)30, null) : text;
    }
}

