/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.markdown.drawables;

import dev.dediamondpro.resourcify.libs.elementa.UIComponent;
import dev.dediamondpro.resourcify.libs.elementa.components.UIImage;
import dev.dediamondpro.resourcify.libs.elementa.constraints.ConstraintType;
import dev.dediamondpro.resourcify.libs.elementa.constraints.XConstraint;
import dev.dediamondpro.resourcify.libs.elementa.constraints.YConstraint;
import dev.dediamondpro.resourcify.libs.elementa.constraints.resolution.ConstraintVisitor;
import dev.dediamondpro.resourcify.libs.elementa.dsl.ComponentsKt;
import dev.dediamondpro.resourcify.libs.elementa.dsl.UtilitiesKt;
import dev.dediamondpro.resourcify.libs.elementa.markdown.DrawState;
import dev.dediamondpro.resourcify.libs.elementa.markdown.MarkdownComponent;
import dev.dediamondpro.resourcify.libs.elementa.markdown.drawables.Drawable;
import dev.dediamondpro.resourcify.libs.elementa.markdown.selection.ImageCursor;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001@B\u001f\u0012\u0006\u0010=\u001a\u00020<\u0012\u0006\u00108\u001a\u000207\u0012\u0006\u0010'\u001a\u00020\u0001\u00a2\u0006\u0004\b>\u0010?J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001f\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001a\u0010/\u001a\u00060.R\u00020\u00008\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001a\u00101\u001a\u00060.R\u00020\u00008\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b1\u00100R*\u00103\u001a\u00020\n2\u0006\u00102\u001a\u00020\n8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010*\u001a\u0004\b4\u0010\u001c\"\u0004\b5\u00106R\u0017\u00108\u001a\u0002078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\u00a8\u0006A"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/ImageDrawable;", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/Drawable;", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/DrawState;", "state", "", "beforeDraw", "(Lgg/essential/elementa/markdown/DrawState;)V", "", "mouseX", "mouseY", "", "dragged", "", "mouseButton", "", "cursorAt", "(FFZI)Ljava/lang/Void;", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/selection/ImageCursor;", "cursorAtEnd", "()Lgg/essential/elementa/markdown/selection/ImageCursor;", "cursorAtStart", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "draw", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/DrawState;)V", "getImageWidth", "()F", "hasSelectedText", "()Z", "x", "y", "width", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "asMarkdown", "", "selectedText", "(Z)Ljava/lang/String;", "fallback", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/Drawable;", "hasLoaded", "Z", "Ldev/dediamondpro/resourcify/libs/elementa/components/UIImage;", "image", "Ldev/dediamondpro/resourcify/libs/elementa/components/UIImage;", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/ImageDrawable$ShiftableMDPixelConstraint;", "imageX", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/ImageDrawable$ShiftableMDPixelConstraint;", "imageY", "value", "selected", "getSelected", "setSelected", "(Z)V", "Ljava/net/URL;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "Ldev/dediamondpro/resourcify/libs/elementa/markdown/MarkdownComponent;", "md", "<init>", "(Lgg/essential/elementa/markdown/MarkdownComponent;Ljava/net/URL;Lgg/essential/elementa/markdown/drawables/Drawable;)V", "ShiftableMDPixelConstraint", "Elementa"})
public final class ImageDrawable
extends Drawable {
    @NotNull
    private final URL url;
    @NotNull
    private final Drawable fallback;
    private boolean selected;
    private ShiftableMDPixelConstraint imageX;
    private ShiftableMDPixelConstraint imageY;
    @NotNull
    private final UIImage image;
    private boolean hasLoaded;

    public ImageDrawable(@NotNull MarkdownComponent md, @NotNull URL url, @NotNull Drawable fallback) {
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        super(md);
        this.url = url;
        this.fallback = fallback;
        this.image = (UIImage)ComponentsKt.childOf((UIComponent)(md.getImageCache() == null ? UIImage.Companion.ofURL(this.url) : UIImage.Companion.ofURL(this.url, md.getImageCache())), md);
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean value) {
        this.selected = value;
        if (value) {
            this.image.setColor(UtilitiesKt.toConstraint(new Color(200, 200, 255, 255)));
        } else {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
            this.image.setColor(UtilitiesKt.toConstraint(color));
        }
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        Drawable.Layout layout;
        if (this.image.isLoaded()) {
            this.imageX = new ShiftableMDPixelConstraint(x, 0.0f);
            this.imageY = new ShiftableMDPixelConstraint(y, 0.0f);
            ShiftableMDPixelConstraint shiftableMDPixelConstraint = this.imageX;
            if (shiftableMDPixelConstraint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageX");
                shiftableMDPixelConstraint = null;
            }
            this.image.setX(shiftableMDPixelConstraint);
            ShiftableMDPixelConstraint shiftableMDPixelConstraint2 = this.imageY;
            if (shiftableMDPixelConstraint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageY");
                shiftableMDPixelConstraint2 = null;
            }
            this.image.setY(shiftableMDPixelConstraint2);
            float aspectRatio = this.image.getImageWidth() / this.image.getImageHeight();
            float imageWidth = RangesKt.coerceAtMost((float)this.image.getImageWidth(), (float)width);
            float imageHeight = imageWidth / aspectRatio;
            this.image.setWidth(UtilitiesKt.pixels$default(Float.valueOf(imageWidth), false, false, 3, null));
            this.image.setHeight(UtilitiesKt.pixels$default(Float.valueOf(imageHeight), false, false, 3, null));
            layout = new Drawable.Layout(x, y, imageWidth, imageHeight, null, 16, null);
        } else {
            layout = this.fallback.layout(x, y, width);
        }
        return layout;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.hasLoaded) {
            this.fallback.drawCompat(matrixStack, state);
        } else {
            this.image.drawCompat(matrixStack);
        }
    }

    @Override
    public void beforeDraw(@NotNull DrawState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.image.isLoaded() && !this.hasLoaded) {
            this.hasLoaded = true;
            this.getMd().layout();
        }
        if (this.hasLoaded) {
            ShiftableMDPixelConstraint shiftableMDPixelConstraint = this.imageX;
            if (shiftableMDPixelConstraint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageX");
                shiftableMDPixelConstraint = null;
            }
            shiftableMDPixelConstraint.setShift(state.getXShift());
            ShiftableMDPixelConstraint shiftableMDPixelConstraint2 = this.imageY;
            if (shiftableMDPixelConstraint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageY");
                shiftableMDPixelConstraint2 = null;
            }
            shiftableMDPixelConstraint2.setShift(state.getYShift());
        }
    }

    public final float getImageWidth() {
        return this.image.getImageWidth();
    }

    @NotNull
    public Void cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        throw new IllegalStateException("never called");
    }

    @NotNull
    public ImageCursor cursorAtStart() {
        return new ImageCursor(this);
    }

    @NotNull
    public ImageCursor cursorAtEnd() {
        return new ImageCursor(this);
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (asMarkdown) {
            return " ![" + this.fallback.selectedText(true) + "](" + this.url + ") ";
        }
        return "" + ' ' + this.url + ' ';
    }

    @Override
    public boolean hasSelectedText() {
        return this.selected;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\r\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010'\u001a\u00020\u0005\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007J\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u00020\u00058\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u0004\u0018\u00010\u00038\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u00020\u001f8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R*\u0010'\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00058\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010\u0011\u001a\u0004\b(\u0010\u0013\"\u0004\b)\u0010\u0018\u00a8\u0006,"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/markdown/drawables/ImageDrawable$ShiftableMDPixelConstraint;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/XConstraint;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/YConstraint;", "Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;", "component", "", "getXPositionImpl", "(Lgg/essential/elementa/UIComponent;)F", "getYPositionImpl", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/resolution/ConstraintVisitor;", "visitor", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/ConstraintType;", "type", "", "visitImpl", "(Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;Lgg/essential/elementa/constraints/ConstraintType;)V", "base", "F", "getBase", "()F", "cachedValue", "getCachedValue", "()Ljava/lang/Float;", "setCachedValue", "(F)V", "constrainTo", "Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "", "recalculate", "Z", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "value", "shift", "getShift", "setShift", "<init>", "(Lgg/essential/elementa/markdown/drawables/ImageDrawable;FF)V", "Elementa"})
    private final class ShiftableMDPixelConstraint
    implements XConstraint,
    YConstraint {
        private final float base;
        private float shift;
        private float cachedValue;
        private boolean recalculate;
        @Nullable
        private UIComponent constrainTo;

        public ShiftableMDPixelConstraint(float base, float shift) {
            Intrinsics.checkNotNullParameter((Object)ImageDrawable.this, (String)"this$0");
            this.base = base;
            this.shift = shift;
            this.recalculate = true;
        }

        public final float getBase() {
            return this.base;
        }

        public final float getShift() {
            return this.shift;
        }

        public final void setShift(float value) {
            this.setRecalculate(true);
            this.shift = value;
        }

        @Override
        @NotNull
        public Float getCachedValue() {
            return Float.valueOf(this.cachedValue);
        }

        @Override
        public void setCachedValue(float f) {
            this.cachedValue = f;
        }

        @Override
        public boolean getRecalculate() {
            return this.recalculate;
        }

        @Override
        public void setRecalculate(boolean bl) {
            this.recalculate = bl;
        }

        @Override
        @Nullable
        public UIComponent getConstrainTo() {
            return this.constrainTo;
        }

        @Override
        public void setConstrainTo(@Nullable UIComponent uIComponent) {
            this.constrainTo = uIComponent;
        }

        @Override
        public float getXPositionImpl(@NotNull UIComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            return this.base + this.shift;
        }

        @Override
        public float getYPositionImpl(@NotNull UIComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            return this.base + this.shift;
        }

        @Override
        public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        }
    }
}

