/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.util.DownloadData;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import dev.dediamondpro.resourcify.util.QueuedDownload;
import dev.dediamondpro.resourcify.util.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0010J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J;\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00150\u00148BX\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00180\u00148BX\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001b"}, d2={"Ldev/dediamondpro/resourcify/util/DownloadManager;", "", "Ljava/net/URL;", "url", "", "cancelDownload", "(Ljava/net/URL;)V", "Ljava/io/File;", "file", "", "sha512", "Lkotlin/Function0;", "callback", "download", "(Ljava/io/File;Ljava/lang/String;Ljava/net/URL;Lkotlin/jvm/functions/Function0;)V", "downloadNext", "()V", "", "getProgress", "(Ljava/net/URL;)Ljava/lang/Float;", "", "Ldev/dediamondpro/resourcify/util/DownloadData;", "downloadsInProgress", "Ljava/util/Map;", "Ldev/dediamondpro/resourcify/util/QueuedDownload;", "queuedDownloads", "<init>", "resourcify"})
@SourceDebugExtension(value={"SMAP\nDownloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadManager.kt\ndev/dediamondpro/resourcify/util/DownloadManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class DownloadManager {
    @NotNull
    public static final DownloadManager INSTANCE = new DownloadManager();
    @NotNull
    private static final Map<URL, QueuedDownload> queuedDownloads = new LinkedHashMap();
    @NotNull
    private static final Map<URL, DownloadData> downloadsInProgress = new LinkedHashMap();

    private DownloadManager() {
    }

    public final void download(@NotNull File file, @Nullable String sha512, @NotNull URL url, @Nullable Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        queuedDownloads.put(url, new QueuedDownload(file, sha512, callback));
        this.downloadNext();
    }

    public static /* synthetic */ void download$default(DownloadManager downloadManager, File file, String string, URL uRL, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        downloadManager.download(file, string, uRL, (Function0<Unit>)function0);
    }

    @Nullable
    public final Float getProgress(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (queuedDownloads.containsKey(url)) {
            return Float.valueOf(0.0f);
        }
        if (!downloadsInProgress.containsKey(url)) {
            return null;
        }
        Object object = downloadsInProgress.get(url);
        if (object == null || (object = ((DownloadData)object).getLength()) == null) {
            return Float.valueOf(0.0f);
        }
        int length = (Integer)object;
        Object object2 = downloadsInProgress.get(url);
        return Float.valueOf((object2 != null && (object2 = ((DownloadData)object2).getFile()) != null ? (float)((File)object2).length() : 0.0f) / (float)length);
    }

    public final void cancelDownload(@NotNull URL url) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (queuedDownloads.containsKey(url)) {
            queuedDownloads.remove(url);
            return;
        }
        if (!downloadsInProgress.containsKey(url)) {
            return;
        }
        Object object2 = downloadsInProgress.get(url);
        if (object2 != null && (object2 = ((DownloadData)object2).getFuture()) != null) {
            ((CompletableFuture)object2).cancel(true);
        }
        if ((object = downloadsInProgress.get(url)) != null && (object = ((DownloadData)object).getFile()) != null) {
            ((File)object).delete();
        }
        downloadsInProgress.remove(url);
    }

    private final void downloadNext() {
        if (downloadsInProgress.size() >= 2) {
            return;
        }
        URL uRL = (URL)CollectionsKt.firstOrNull((Iterable)queuedDownloads.keySet());
        if (uRL == null) {
            return;
        }
        URL url = uRL;
        QueuedDownload queuedDownload = queuedDownloads.remove(url);
        if (queuedDownload == null) {
            return;
        }
        QueuedDownload queuedDownload2 = queuedDownload;
        Map<URL, DownloadData> map2 = downloadsInProgress;
        CompletionStage completionStage = CompletableFuture.runAsync(() -> DownloadManager.downloadNext$lambda$3(url, queuedDownload2)).whenComplete((arg_0, arg_1) -> DownloadManager.downloadNext$lambda$4((Function2)new Function2<Void, Throwable, Unit>(url){
            final /* synthetic */ URL $url;
            {
                this.$url = $url;
                super(2);
            }

            public final void invoke(Void void_, Throwable throwable) {
                if (throwable != null) {
                    System.out.println((Object)("Download of " + this.$url + " failed:"));
                    throwable.printStackTrace();
                    return;
                }
                DownloadManager.access$getDownloadsInProgress$p().remove(this.$url);
                DownloadManager.access$downloadNext(DownloadManager.INSTANCE);
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"url = queuedDownloads.ke\u2026 downloadNext()\n        }");
        DownloadData downloadData = new DownloadData((CompletableFuture)completionStage, queuedDownload2.getFile(), null, 4, null);
        map2.put(url, downloadData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void downloadNext$lambda$3(URL $url, QueuedDownload $queuedDownload) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            Intrinsics.checkNotNullParameter((Object)$queuedDownload, (String)"$queuedDownload");
            HttpsURLConnection con = NetworkUtilKt.setupConnection($url);
            DownloadData downloadData = downloadsInProgress.get($url);
            if (downloadData != null) {
                downloadData.setLength(con.getContentLength());
            }
            Closeable closeable = NetworkUtilKt.getEncodedInputStream(con);
            Throwable throwable = null;
            try {
                InputStream it22 = (InputStream)closeable;
                boolean bl = false;
                InputStream inputStream = it22;
                Intrinsics.checkNotNull((Object)inputStream);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long it22 = Files.copy(inputStream, $queuedDownload.getFile().toPath(), copyOptionArray);
            }
            catch (Throwable it22) {
                throwable = it22;
                throw it22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = $queuedDownload.getSha512();
            if (string != null) {
                String it = string;
                boolean bl = false;
                String hash = Utils.INSTANCE.getSha512($queuedDownload.getFile());
                if (!Intrinsics.areEqual((Object)hash, (Object)it)) {
                    $queuedDownload.getFile().delete();
                    throw new IllegalStateException(("Hash " + hash + " does not match expected hash " + it + "!").toString());
                }
            }
            Function0<Unit> function0 = $queuedDownload.getCallback();
            if (function0 == null) break block9;
            Function0<Unit> it = function0;
            boolean bl = false;
            it.invoke();
        }
    }

    private static final void downloadNext$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Map access$getDownloadsInProgress$p() {
        return downloadsInProgress;
    }

    public static final /* synthetic */ void access$downloadNext(DownloadManager $this) {
        $this.downloadNext();
    }
}

