/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import gg.essential.universal.UMinecraft;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\u0004R\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Ldev/dediamondpro/resourcify/util/NetworkUtil;", "", "", "clearCache", "()V", "Ljava/net/URL;", "url", "", "getOrFetch", "(Ljava/net/URL;)[B", "pruneCache", "", "MAX_CACHE_SIZE", "I", "Ljava/util/concurrent/ConcurrentHashMap;", "Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "<init>", "CacheObject", "resourcify"})
@SourceDebugExtension(value={"SMAP\nNetworkUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n1045#3:135\n*S KotlinDebug\n*F\n+ 1 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtil\n*L\n64#1:135\n*E\n"})
public final class NetworkUtil {
    @NotNull
    public static final NetworkUtil INSTANCE = new NetworkUtil();
    private static final int MAX_CACHE_SIZE = 100000000;
    @NotNull
    private static final ConcurrentHashMap<URL, CacheObject> cache = new ConcurrentHashMap();

    private NetworkUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final byte[] getOrFetch(@NotNull URL url) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CacheObject value = cache.get(url);
        if (value == null) {
            void var3_9;
            byte[] bytes;
            InputStream inputStream = NetworkUtilKt.getEncodedInputStream(url);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    byte[] byArray2 = ByteStreamsKt.readBytes((InputStream)it);
                    v1 = byArray2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                v1 = bytes = null;
            }
            if (bytes != null) {
                ((Map)cache).put(url, new CacheObject(url, bytes, 0L, 4, null));
                this.pruneCache();
            }
            byArray = var3_9;
        } else {
            byArray = value.getBytes();
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void pruneCache() {
        Collection<CacheObject> collection = cache.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"cache.values");
        Iterable iterable = collection;
        int n = 0;
        for (Object t : iterable) {
            void it;
            CacheObject cacheObject = (CacheObject)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getSize();
            n = n2 + n3;
        }
        int cacheSize = n;
        if (cacheSize <= 100000000) {
            return;
        }
        Collection<CacheObject> collection2 = cache.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"cache.values");
        Iterable $this$sortedBy$iv = collection2;
        boolean $i$f$sortedBy = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CacheObject it = (CacheObject)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLastAccess());
                it = (CacheObject)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastAccess()));
            }
        });
        int i = 0;
        while (cacheSize > 100000000) {
            Object e = sorted.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"sorted[i]");
            CacheObject element = (CacheObject)e;
            cache.remove(element.getUrl());
            cacheSize -= element.getSize();
            ++i;
        }
    }

    public final void clearCache() {
        cache.clear();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c2\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\f\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001bR\"\u0010\r\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u001c\u001a\u0004\b\u001d\u0010\n\"\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010\u0017R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010#\u001a\u0004\b$\u0010\u0004\u00a8\u0006'"}, d2={"Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "", "Ljava/net/URL;", "component1", "()Ljava/net/URL;", "", "component2", "()[B", "", "component3", "()J", "url", "bytes", "lastAccess", "copy", "(Ljava/net/URL;[BJ)Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "other", "", "equals", "(Ljava/lang/Object;)Z", "getBytes", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "[B", "J", "getLastAccess", "setLastAccess", "(J)V", "size", "I", "getSize", "Ljava/net/URL;", "getUrl", "<init>", "(Ljava/net/URL;[BJ)V", "resourcify"})
    private static final class CacheObject {
        @NotNull
        private final URL url;
        @NotNull
        private final byte[] bytes;
        private long lastAccess;
        private final int size;

        public CacheObject(@NotNull URL url, @NotNull byte[] bytes, long lastAccess) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.url = url;
            this.bytes = bytes;
            this.lastAccess = lastAccess;
            this.size = this.bytes.length;
        }

        public /* synthetic */ CacheObject(URL uRL, byte[] byArray, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = UMinecraft.getTime();
            }
            this(uRL, byArray, l);
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        public final long getLastAccess() {
            return this.lastAccess;
        }

        public final void setLastAccess(long l) {
            this.lastAccess = l;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final byte[] getBytes() {
            this.lastAccess = UMinecraft.getTime();
            return this.bytes;
        }

        @NotNull
        public final URL component1() {
            return this.url;
        }

        private final byte[] component2() {
            return this.bytes;
        }

        public final long component3() {
            return this.lastAccess;
        }

        @NotNull
        public final CacheObject copy(@NotNull URL url, @NotNull byte[] bytes, long lastAccess) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return new CacheObject(url, bytes, lastAccess);
        }

        public static /* synthetic */ CacheObject copy$default(CacheObject cacheObject, URL uRL, byte[] byArray, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uRL = cacheObject.url;
            }
            if ((n & 2) != 0) {
                byArray = cacheObject.bytes;
            }
            if ((n & 4) != 0) {
                l = cacheObject.lastAccess;
            }
            return cacheObject.copy(uRL, byArray, l);
        }

        @NotNull
        public String toString() {
            return "CacheObject(url=" + this.url + ", bytes=" + Arrays.toString(this.bytes) + ", lastAccess=" + this.lastAccess + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + Arrays.hashCode(this.bytes);
            result = result * 31 + Long.hashCode(this.lastAccess);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheObject)) {
                return false;
            }
            CacheObject cacheObject = (CacheObject)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)cacheObject.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bytes, (Object)cacheObject.bytes)) {
                return false;
            }
            return this.lastAccess == cacheObject.lastAccess;
        }
    }
}

