/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.utils;

import com.google.gson.JsonElement;
import io.github.lucaargolo.seasons.utils.Season;

public class SeasonColor {
    private final int springColor;
    private final int summerColor;
    private final int fallColor;
    private final int winterColor;

    public SeasonColor(int springColor, int summerColor, int fallColor, int winterColor) {
        this.springColor = springColor;
        this.summerColor = summerColor;
        this.fallColor = fallColor;
        this.winterColor = winterColor;
    }

    public SeasonColor(JsonElement json) {
        this.springColor = this.getStringColor(json.getAsJsonObject().get("spring").getAsString());
        this.summerColor = this.getStringColor(json.getAsJsonObject().get("summer").getAsString());
        this.fallColor = this.getStringColor(json.getAsJsonObject().get("fall").getAsString());
        this.winterColor = this.getStringColor(json.getAsJsonObject().get("winter").getAsString());
    }

    private int getStringColor(String color) {
        if (color.startsWith("0x")) {
            return Integer.parseInt(color.replace("0x", ""), 16);
        }
        if (color.startsWith("#")) {
            return Integer.parseInt(color.replace("#", ""), 16);
        }
        return Integer.parseInt(color);
    }

    public int getColor(Season season) {
        return switch (season) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING -> this.springColor;
            case Season.SUMMER -> this.summerColor;
            case Season.FALL -> this.fallColor;
            case Season.WINTER -> this.winterColor;
        };
    }
}

