/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block;

import me.mgin.graves.block.GraveBlocks;
import me.mgin.graves.block.decay.DecayingGrave;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.block.utility.Permission;
import me.mgin.graves.block.utility.RetrieveGrave;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5819;

public class GraveBlockBase
extends class_2383
implements class_2343,
DecayingGrave,
class_3737 {
    private final DecayingGrave.BlockDecay blockDecay;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    public GraveBlockBase(DecayingGrave.BlockDecay blockDecay, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
        this.blockDecay = blockDecay;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{class_2741.field_12481}).method_11667(new class_2769[]{class_2741.field_12508});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        GraveBlockEntity graveEntity = (GraveBlockEntity)world.method_8321(pos);
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (hand != class_1268.field_5810 && player.method_5998(hand).method_7960() && Permission.playerCanUseGrave(player, graveEntity)) {
            RetrieveGrave.retrieveWithInteract(player, world, pos);
        }
        return class_1269.field_5811;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        boolean retrieved;
        GraveBlockEntity graveEntity = (GraveBlockEntity)world.method_8321(pos);
        if (world.field_9236) {
            return;
        }
        if (Permission.playerCanBreakGrave(player, graveEntity) && !(retrieved = RetrieveGrave.retrieveWithInteract(player, world, pos)) && graveEntity.hasCustomName() && !player.method_7337()) {
            this.onBreakRetainName(world, pos, player, graveEntity);
        }
        super.method_9576(world, pos, state, player);
        world.method_8413(pos, state, state, 2);
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        GraveBlockEntity graveEntity = (GraveBlockEntity)world.method_8321(pos);
        class_1799 itemStack = this.getItemStack();
        if (graveEntity.hasCustomName()) {
            class_5250 itemText = class_2561.class_2562.method_10877((String)graveEntity.getCustomName());
            itemStack.method_7977((class_2561)itemText);
        }
        return itemStack;
    }

    public void onBreakRetainName(class_1937 world, class_2338 pos, class_1657 player, GraveBlockEntity graveEntity) {
        class_5250 itemText = class_2561.class_2562.method_10877((String)graveEntity.getCustomName());
        class_1799 itemStack = this.getItemStack();
        itemStack.method_7977((class_2561)itemText);
        class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
        itemEntity.method_6988();
        this.method_33614(world, player, pos, this.method_9564());
        world.method_8650(pos, false);
        world.method_8649((class_1297)itemEntity);
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ct) {
        return class_259.method_1081((double)0.062f, (double)0.0, (double)0.0, (double)0.938f, (double)0.1875, (double)0.938f);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1081((double)0.062f, (double)0.0, (double)0.062f, (double)0.938f, (double)0.02f, (double)0.938f);
    }

    public class_3619 getPistonBehavior(class_2680 state) {
        return class_3619.field_15975;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GraveBlockEntity(pos, state);
    }

    public class_1799 getItemStack() {
        GraveBlockBase decayedBlock = GraveBlockBase.getDecayedBlock(this.blockDecay);
        return new class_1799((class_1935)decayedBlock);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        GraveBlockEntity graveEntity;
        block3: {
            block2: {
                class_2586 blockEntity = world.method_8321(pos);
                if (!(blockEntity instanceof GraveBlockEntity)) break block2;
                graveEntity = (GraveBlockEntity)blockEntity;
                if (itemStack.method_7938()) break block3;
            }
            super.method_9567(world, pos, state, placer, itemStack);
            return;
        }
        graveEntity.setCustomName(itemStack.method_7911("display").method_10558("Name"));
    }

    public class_2680 method_9605(class_1750 context) {
        class_2338 blockPos = context.method_8037();
        class_3610 fluidState = context.method_8045().method_8316(blockPos);
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)context.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.tickDecay(state, world, pos, random);
    }

    public boolean method_9542(class_2680 state) {
        return DecayingGrave.getIncreasedDecayBlock(state.method_26204()).isPresent();
    }

    @Override
    public DecayingGrave.BlockDecay getDecayStage() {
        return this.blockDecay;
    }

    public static GraveBlockBase getDecayedBlock(DecayingGrave.BlockDecay blockDecay) {
        return switch (blockDecay) {
            default -> GraveBlocks.GRAVE;
            case DecayingGrave.BlockDecay.OLD -> GraveBlocks.GRAVE_OLD;
            case DecayingGrave.BlockDecay.WEATHERED -> GraveBlocks.GRAVE_WEATHERED;
            case DecayingGrave.BlockDecay.FORGOTTEN -> GraveBlocks.GRAVE_FORGOTTEN;
        };
    }

    @Override
    public void tickDecay(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        GraveBlockEntity graveEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GraveBlockEntity && (graveEntity = (GraveBlockEntity)blockEntity).getNoDecay() == 1) {
            return;
        }
        DecayingGrave.super.tickDecay(state, world, pos, random);
    }
}

