/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.utility;

import com.mojang.authlib.GameProfile;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.config.enums.ExperienceType;
import me.mgin.graves.config.enums.GraveExpStoreType;
import net.minecraft.class_1657;

public class Experience {
    public static int calculatePlayerExperience(class_1657 player) {
        GameProfile profile = player.method_7334();
        float progress = player.field_7510;
        int level = player.field_7520;
        GraveExpStoreType storageType = (GraveExpStoreType)((Object)GravesConfig.resolve("expStorageType", profile));
        ExperienceType percentageType = (ExperienceType)((Object)GravesConfig.resolve("percentageType", profile));
        ExperienceType capType = (ExperienceType)((Object)GravesConfig.resolve("capType", profile));
        int cap = (Integer)GravesConfig.resolve("cap", profile);
        int percentage = (Integer)GravesConfig.resolve("percentage", profile);
        float percentageModifier = (float)percentage / 100.0f;
        if (percentageType == ExperienceType.LEVELS) {
            float levelAndProgress = ((float)level + progress) * percentageModifier;
            level = (int)levelAndProgress;
            progress = levelAndProgress % 1.0f;
        }
        int experience = switch (storageType) {
            case GraveExpStoreType.VANILLA -> Experience.calculateVanillaExperience(level);
            case GraveExpStoreType.ALL -> Experience.calculateTotalExperience(level, progress);
            default -> 0;
        };
        if (percentageType == ExperienceType.POINTS) {
            experience = Math.round((float)experience * percentageModifier);
        }
        int capValue = capType == ExperienceType.LEVELS ? Experience.calculateLevelExperience(cap) : cap;
        return cap > -1 ? Math.min(capValue, experience) : experience;
    }

    public static int calculateVanillaExperience(int level) {
        return 7 * level;
    }

    public static int calculateTotalExperience(int level, float progress) {
        int levelExperience = Experience.calculateLevelExperience(level);
        int progressExperience = Experience.calculateProgressExperience(level, progress);
        return levelExperience + progressExperience;
    }

    private static int calculateLevelExperience(int level) {
        int levelSquared = level * level;
        int levelExperience = 0;
        if (level <= 16) {
            levelExperience = levelSquared + 6 * level;
        }
        if (level >= 17 && level <= 31) {
            levelExperience = (int)(2.5 * (double)levelSquared - 40.5 * (double)level + 360.0);
        }
        if (level > 31) {
            levelExperience = (int)(4.5 * (double)levelSquared - 162.5 * (double)level + 2220.0);
        }
        return levelExperience;
    }

    private static int calculateProgressExperience(int level, float progress) {
        int result;
        float progressExperience = 0.0f;
        if (level <= 15) {
            progressExperience = (float)(2 * level + 7) * progress;
        }
        if (level >= 16 && level <= 30) {
            progressExperience = (float)(5 * level - 38) * progress;
        }
        if (level > 30) {
            progressExperience = (float)(9 * level - 158) * progress;
        }
        if ((result = Math.round(progressExperience)) == 0) {
            ++result;
        }
        return level > 0 ? result : 0;
    }
}

