/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.command.utility;

import com.google.gson.Gson;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.mgin.graves.config.ConfigOptions;
import me.mgin.graves.util.ArrayUtil;
import net.minecraft.class_1928;
import net.minecraft.class_2168;

public class CommandContextData {
    public Object VAL;
    public String TYPE;
    public String OPTION;
    public String ACTION = null;
    public boolean IS_SERVER;
    public boolean SEND_COMMAND_FEEDBACK;

    public CommandContextData(CommandContext<class_2168> context) {
        this.TYPE = this.determineArgumentType(context);
        this.OPTION = this.determineOptionName(context, this.TYPE.equals("literal"));
        this.VAL = this.getArgumentValue(context, this.TYPE, this.OPTION);
        this.SEND_COMMAND_FEEDBACK = ((class_2168)context.getSource()).method_9225().method_8450().method_8355(class_1928.field_19400);
        String[] input = context.getInput().split(" ");
        this.IS_SERVER = input[ArrayUtil.indexOf(input, "graves") + 1].equals("server");
        if (this.OPTION.contains(":")) {
            String[] options = this.OPTION.split(":");
            this.OPTION = options[0];
            this.ACTION = options[1];
        }
    }

    public String serialize() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public static CommandContextData deserialize(String instance) {
        Gson gson = new Gson();
        CommandContextData result = (CommandContextData)gson.fromJson(instance, CommandContextData.class);
        if (result.VAL == null) {
            return result;
        }
        if (ConfigOptions.enums.containsKey(result.OPTION)) {
            result.VAL = ConfigOptions.convertStringToEnum(result.OPTION, (String)result.VAL);
            return result;
        }
        if (result.VAL.getClass().equals(Double.class)) {
            result.VAL = Double.valueOf((Double)result.VAL).intValue();
        }
        return result;
    }

    private String determineArgumentType(CommandContext<class_2168> context) {
        String node = ((ParsedCommandNode)context.getNodes().get(context.getNodes().size() - 1)).toString();
        Pattern pattern = Pattern.compile("(integer|BoolArgumentType|string|literal)");
        Matcher matcher = pattern.matcher(node);
        if (!matcher.find()) {
            throw new IllegalStateException("Unknown Argument Type: " + node);
        }
        return matcher.group();
    }

    private String determineOptionName(CommandContext<class_2168> context, boolean literal) {
        if (literal) {
            String[] input = context.getInput().split(" ");
            return input[ArrayUtil.indexOf(input, "set") + 1];
        }
        List nodes = context.getNodes();
        return ((ParsedCommandNode)nodes.get(nodes.size() - 1)).getNode().getName();
    }

    private Object getArgumentValue(CommandContext<class_2168> context, String type, String option) {
        String[] input = context.getInput().split(" ");
        return switch (type) {
            case "BoolArgumentType" -> (Boolean)context.getArgument(option, Boolean.class);
            case "integer" -> (Integer)context.getArgument(option, Integer.class);
            case "literal" -> input[input.length - 1];
            case "string" -> {
                String value = (String)context.getArgument(option, String.class);
                if (ConfigOptions.enums.containsKey(option)) {
                    yield ConfigOptions.convertStringToEnum(option, value);
                }
                yield value;
            }
            default -> throw new IllegalStateException("Unexpected value: " + type);
        };
    }
}

