/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animatable;

import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.network.AzureLibNetwork;
import mod.azure.azurelib.network.SerializableDataTicket;
import mod.azure.azurelib.network.packet.BlockEntityAnimDataSyncPacket;
import mod.azure.azurelib.network.packet.BlockEntityAnimTriggerPacket;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public interface GeoBlockEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        class_2586 blockEntity = (class_2586)this;
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            AzureLib.LOGGER.error("Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setData(dataTicket, data);
        } else {
            class_2338 pos = blockEntity.method_11016();
            BlockEntityAnimDataSyncPacket<D> blockEntityAnimDataSyncPacket = new BlockEntityAnimDataSyncPacket<D>(pos, dataTicket, data);
            AzureLibNetwork.sendToEntitiesTrackingChunk(blockEntityAnimDataSyncPacket, (class_3218)level, pos);
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        class_2586 blockEntity = (class_2586)this;
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            AzureLib.LOGGER.error("Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(controllerName, animName);
        } else {
            class_2338 pos = blockEntity.method_11016();
            BlockEntityAnimTriggerPacket blockEntityAnimTriggerPacket = new BlockEntityAnimTriggerPacket(pos, controllerName, animName);
            AzureLibNetwork.sendToEntitiesTrackingChunk(blockEntityAnimTriggerPacket, (class_3218)level, pos);
        }
    }

    @Override
    default public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

