/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.format;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import mod.azure.azurelib.config.ConfigUtils;
import mod.azure.azurelib.config.exception.ConfigReadException;
import mod.azure.azurelib.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.config.format.IConfigFormat;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.IDescriptionProvider;

public class YamlFormat
implements IConfigFormat {
    private final StringBuilder buffer;
    private final int currentNesting;
    private final Map<String, Object> processedData;
    private int readerIndex;

    public YamlFormat() {
        this.buffer = new StringBuilder();
        this.currentNesting = 0;
        this.processedData = new HashMap<String, Object>();
    }

    public YamlFormat(StringBuilder buffer, int nesting) {
        this.buffer = buffer;
        this.currentNesting = nesting;
        this.processedData = new HashMap<String, Object>();
    }

    public YamlFormat(Map<String, Object> processed) {
        this.buffer = null;
        this.currentNesting = 0;
        this.processedData = processed;
    }

    @Override
    public void writeBoolean(String field, boolean value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public boolean readBoolean(String field) throws ConfigValueMissingException {
        return this.getValue(field, Boolean::parseBoolean);
    }

    @Override
    public void writeChar(String field, char value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public char readChar(String field) throws ConfigValueMissingException {
        return this.getValue(field, str -> Character.valueOf(str.charAt(0))).charValue();
    }

    @Override
    public void writeInt(String field, int value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public int readInt(String field) throws ConfigValueMissingException {
        return this.getValue(field, Integer::parseInt);
    }

    @Override
    public void writeLong(String field, long value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public long readLong(String field) throws ConfigValueMissingException {
        return this.getValue(field, Long::parseLong);
    }

    @Override
    public void writeFloat(String field, float value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public float readFloat(String field) throws ConfigValueMissingException {
        return this.getValue(field, Float::parseFloat).floatValue();
    }

    @Override
    public void writeDouble(String field, double value) {
        this.writeValuePair(field, String.valueOf(value));
    }

    @Override
    public double readDouble(String field) throws ConfigValueMissingException {
        return this.getValue(field, Double::parseDouble);
    }

    @Override
    public void writeString(String field, String value) {
        this.writeValuePair(field, value);
    }

    @Override
    public String readString(String field) throws ConfigValueMissingException {
        return (String)this.getValue(field, Function.identity());
    }

    @Override
    public void writeBoolArray(String field, boolean[] values) {
        this.writeKey(field);
        for (boolean value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
        this.newLine();
    }

    @Override
    public boolean[] readBoolArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        boolean[] res = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = Boolean.parseBoolean(arr[i]);
        }
        return res;
    }

    @Override
    public void writeIntArray(String field, int[] values) {
        this.writeKey(field);
        for (int value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
        this.newLine();
    }

    @Override
    public int[] readIntArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        int[] res = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                res[i] = Integer.parseInt(arr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigValueMissingException("Invalid value: " + field);
            }
        }
        return res;
    }

    @Override
    public void writeLongArray(String field, long[] values) {
        this.writeKey(field);
        for (long value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
        this.newLine();
    }

    @Override
    public long[] readLongArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        long[] res = new long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                res[i] = Long.parseLong(arr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigValueMissingException("Invalid value: " + field);
            }
        }
        return res;
    }

    @Override
    public void writeFloatArray(String field, float[] values) {
        this.writeKey(field);
        for (float value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
        this.newLine();
    }

    @Override
    public float[] readFloatArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        float[] res = new float[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                res[i] = Float.parseFloat(arr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigValueMissingException("Invalid value: " + field);
            }
        }
        return res;
    }

    @Override
    public void writeDoubleArray(String field, double[] values) {
        this.writeKey(field);
        for (double value : values) {
            this.writeArrayEntry(String.valueOf(value));
        }
        this.newLine();
    }

    @Override
    public double[] readDoubleArray(String field) throws ConfigValueMissingException {
        String[] arr = this.getValueArray(field);
        double[] res = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            try {
                res[i] = Double.parseDouble(arr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigValueMissingException("Invalid value: " + field);
            }
        }
        return res;
    }

    @Override
    public void writeStringArray(String field, String[] values) {
        this.writeKey(field);
        for (String value : values) {
            this.writeArrayEntry(value);
        }
        this.newLine();
    }

    @Override
    public String[] readStringArray(String field) throws ConfigValueMissingException {
        return this.getValueArray(field);
    }

    @Override
    public <E extends Enum<E>> void writeEnum(String field, E value) {
        this.writeValuePair(field, value.name());
    }

    @Override
    public <E extends Enum<E>> E readEnum(String field, Class<E> enumClass) throws ConfigValueMissingException {
        String name = this.readString(field);
        return ConfigUtils.getEnumConstant(name, enumClass);
    }

    @Override
    public <E extends Enum<E>> void writeEnumArray(String field, E[] value) {
        String[] strings = (String[])Arrays.stream(value).map(Enum::name).toArray(String[]::new);
        this.writeStringArray(field, strings);
    }

    @Override
    public <E extends Enum<E>> E[] readEnumArray(String field, Class<E> enumClass) throws ConfigValueMissingException {
        String[] strings = this.readStringArray(field);
        Enum[] arr = (Enum[])Array.newInstance(enumClass, strings.length);
        for (int i = 0; i < strings.length; ++i) {
            arr[i] = ConfigUtils.getEnumConstant(strings[i], enumClass);
        }
        return arr;
    }

    @Override
    public void writeMap(String field, Map<String, ConfigValue<?>> value) {
        this.writeKey(field);
        YamlFormat format = new YamlFormat(this.buffer, this.currentNesting + 1);
        value.values().forEach(val -> val.serializeValue(format));
    }

    @Override
    public void readMap(String field, Collection<ConfigValue<?>> values) throws ConfigValueMissingException {
        Map<String, Object> map = this.getValueMap(field);
        YamlFormat format = new YamlFormat(map);
        values.forEach(val -> val.deserializeValue(format));
    }

    @Override
    public void readFile(File file) throws IOException, ConfigReadException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String editedText = line.replaceAll("^[\\s|\\t]*#.+$", "");
                if (editedText.isEmpty()) continue;
                lines.add(editedText);
            }
        }
        try {
            while (this.readerIndex < lines.size()) {
                this.process(lines);
            }
        }
        catch (Exception e) {
            throw new ConfigReadException("Config process failed", e);
        }
    }

    private void process(List<String> list) throws ConfigReadException {
        String value = list.get(this.readerIndex);
        String[] components = value.split(":\\s*", 2);
        Pattern pattern = Pattern.compile("^.+:\\s?\n?$");
        if (components.length == 1 || pattern.matcher(value).matches()) {
            if (this.readerIndex == list.size() - 1) {
                this.processedData.put(components[0].trim(), new String[0]);
                ++this.readerIndex;
                return;
            }
            String next = list.get(this.readerIndex + 1);
            if (next.trim().startsWith("-")) {
                this.processArray(list, components[0].trim());
            } else {
                this.processMap(list, components[0].trim());
            }
            return;
        }
        if (components.length == 2) {
            this.processedData.put(components[0].trim(), components[1].trim());
            ++this.readerIndex;
            return;
        }
        throw new ConfigReadException("Invalid config format");
    }

    private void processMap(List<String> list, String key) throws ConfigReadException {
        String value;
        int next;
        String prefix = "^ {2}";
        ArrayList<String> newValues = new ArrayList<String>();
        while (this.readerIndex < list.size() && (next = this.readerIndex + 1) < list.size() && (value = list.get(next)).startsWith("  ")) {
            newValues.add(value.replaceFirst(prefix, ""));
            ++this.readerIndex;
        }
        YamlFormat format = new YamlFormat(new HashMap<String, Object>());
        while (format.readerIndex < newValues.size()) {
            format.process(newValues);
        }
        this.processedData.put(key, format.processedData);
        ++this.readerIndex;
    }

    private void processArray(List<String> list, String key) {
        String entry;
        ++this.readerIndex;
        ArrayList<String> entries = new ArrayList<String>();
        while (this.readerIndex < list.size() && (entry = list.get(this.readerIndex).trim()).startsWith("-")) {
            entries.add(entry.replaceAll("^-\\s", ""));
            ++this.readerIndex;
        }
        this.processedData.put(key, entries.toArray(new String[0]));
    }

    @Override
    public void writeFile(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(this.buffer.toString());
        }
    }

    @Override
    public void addComments(IDescriptionProvider provider) {
        String[] comments = provider.getDescription();
        if (comments.length > 0) {
            for (String comment : comments) {
                this.spaces();
                this.buffer.append("# ").append(comment).append("\n");
            }
        }
    }

    private void spaces() {
        this.spaces(this.currentNesting);
    }

    private void spaces(int nestIndex) {
        if (nestIndex > 0) {
            for (int i = 0; i < nestIndex * 2; ++i) {
                this.buffer.append(" ");
            }
        }
    }

    private void writeKey(String key) {
        this.spaces();
        this.buffer.append(key).append(":\n");
    }

    private void newLine() {
        this.buffer.append("\n");
    }

    private void writeArrayEntry(String value) {
        this.spaces(this.currentNesting + 1);
        this.buffer.append("- ").append(value).append("\n");
    }

    private void writeValuePair(String key, String value) {
        this.spaces();
        this.buffer.append(key).append(": ").append(value).append("\n\n");
    }

    private <V> V getValue(String key, Function<String, V> parser) throws ConfigValueMissingException {
        Object value = this.processedData.get(key);
        if (value == null) {
            throw new ConfigValueMissingException("Missing value: " + key);
        }
        try {
            return parser.apply(value.toString());
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new ConfigValueMissingException("Value parse failed: " + key + ", value: " + value);
        }
    }

    private String[] getValueArray(String key) throws ConfigValueMissingException {
        Object value = this.processedData.get(key);
        if (value == null) {
            throw new ConfigValueMissingException("Missing value: " + key);
        }
        try {
            if (value instanceof Map) {
                return new String[0];
            }
            return (String[])value;
        }
        catch (ClassCastException e) {
            throw new ConfigValueMissingException("Value parse failed: " + key + ", value: " + value);
        }
    }

    private Map<String, Object> getValueMap(String key) throws ConfigValueMissingException {
        Object value = this.processedData.get(key);
        if (value == null) {
            throw new ConfigValueMissingException("Missing value: " + key);
        }
        try {
            if (value instanceof String[]) {
                return new HashMap<String, Object>();
            }
            return (Map)value;
        }
        catch (ClassCastException e) {
            throw new ConfigValueMissingException("Value parse failed: " + key + ", value: " + value);
        }
    }
}

