/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.network.packet.AnimDataSyncPacket;
import mod.azure.azurelib.network.packet.AnimTriggerPacket;
import mod.azure.azurelib.network.packet.BlockEntityAnimDataSyncPacket;
import mod.azure.azurelib.network.packet.BlockEntityAnimTriggerPacket;
import mod.azure.azurelib.network.packet.EntityAnimDataSyncPacket;
import mod.azure.azurelib.network.packet.EntityAnimTriggerPacket;
import mod.azure.azurelib.network.packet.EntityPacketOnClient;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class AzureLibNetwork {
    public static final class_2960 ANIM_DATA_SYNC_PACKET_ID = new class_2960("azurelib", "anim_data_sync");
    public static final class_2960 ANIM_TRIGGER_SYNC_PACKET_ID = new class_2960("azurelib", "anim_trigger_sync");
    public static final class_2960 ENTITY_ANIM_DATA_SYNC_PACKET_ID = new class_2960("azurelib", "entity_anim_data_sync");
    public static final class_2960 ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = new class_2960("azurelib", "entity_anim_trigger_sync");
    public static final class_2960 BLOCK_ENTITY_ANIM_DATA_SYNC_PACKET_ID = new class_2960("azurelib", "block_entity_anim_data_sync");
    public static final class_2960 BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = new class_2960("azurelib", "block_entity_anim_trigger_sync");
    public static final class_2960 CUSTOM_ENTITY_ID = new class_2960("azurelib", "spawn_entity");
    public static final Map<String, GeoAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap();

    public static void registerClientReceiverPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ANIM_DATA_SYNC_PACKET_ID, AnimDataSyncPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ANIM_TRIGGER_SYNC_PACKET_ID, AnimTriggerPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ENTITY_ANIM_DATA_SYNC_PACKET_ID, EntityAnimDataSyncPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID, EntityAnimTriggerPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BLOCK_ENTITY_ANIM_DATA_SYNC_PACKET_ID, BlockEntityAnimDataSyncPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID, BlockEntityAnimTriggerPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CUSTOM_ENTITY_ID, (client, handler, buf, responseSender) -> EntityPacketOnClient.onPacket(client, buf));
    }

    public static synchronized void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeoAnimatable existing = SYNCED_ANIMATABLES.put(animatable.getClass().toString(), animatable);
        if (existing == null) {
            AzureLib.LOGGER.debug("Registered SyncedAnimatable for " + animatable.getClass());
        }
    }

    @Nullable
    public static GeoAnimatable getSyncedAnimatable(String className) {
        GeoAnimatable animatable = SYNCED_ANIMATABLES.get(className);
        if (animatable == null) {
            AzureLib.LOGGER.error("Attempting to retrieve unregistered synced animatable! (" + className + ")");
        }
        return animatable;
    }

    public static void sendWithCallback(AbstractPacket packet, IPacketCallback callback) {
        callback.onReadyToSend(packet);
    }

    public static void sendToTrackingEntityAndSelf(AbstractPacket packet, class_1297 entityToTrack) {
        for (class_3222 trackingPlayer : PlayerLookup.tracking((class_1297)entityToTrack)) {
            ServerPlayNetworking.send((class_3222)trackingPlayer, (class_2960)packet.getPacketID(), (class_2540)packet.encode());
        }
        if (entityToTrack instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entityToTrack;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)packet.getPacketID(), (class_2540)packet.encode());
        }
    }

    public static void sendToEntitiesTrackingChunk(AbstractPacket packet, class_3218 level, class_2338 blockPos) {
        for (class_3222 trackingPlayer : PlayerLookup.tracking((class_3218)level, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)trackingPlayer, (class_2960)packet.getPacketID(), (class_2540)packet.encode());
        }
    }

    public static interface IPacketCallback {
        public void onReadyToSend(AbstractPacket var1);
    }
}

