/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network;

import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiConsumer;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.network.S2C_SendConfigData;
import mod.azure.azurelib.network.api.IClientPacket;
import mod.azure.azurelib.network.api.IPacket;
import mod.azure.azurelib.network.api.IPacketDecoder;
import mod.azure.azurelib.network.api.IPacketEncoder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class Networking {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Network");

    public static void sendClientPacket(class_3222 target, IClientPacket<?> packet) {
        Networking.dispatch(packet, (packetId, buffer) -> ServerPlayNetworking.send((class_3222)target, (class_2960)packetId, (class_2540)buffer));
    }

    private static <T> void dispatch(IPacket<T> packet, BiConsumer<class_2960, class_2540> dispatcher) {
        class_2960 packetId = packet.getPacketId();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        IPacketEncoder<T> encoder = packet.getEncoder();
        T data = packet.getPacketData();
        encoder.encode(data, buffer);
        dispatcher.accept(packetId, buffer);
    }

    public static final class PacketRegistry {
        public static void registerClient() {
            PacketRegistry.registerServer2ClientReceiver(S2C_SendConfigData.class);
        }

        @Environment(value=EnvType.CLIENT)
        private static <T> void registerServer2ClientReceiver(Class<? extends IClientPacket<T>> clientPacketClass) {
            try {
                IClientPacket packet = clientPacketClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                class_2960 packetId = packet.getPacketId();
                ClientPlayNetworking.registerGlobalReceiver((class_2960)packetId, (client, handler, buffer, responseDispatcher) -> {
                    IPacketDecoder decoder = packet.getDecoder();
                    Object packetData = decoder.decode(buffer);
                    client.execute(() -> packet.handleClientsidePacket(client, handler, packetData, responseDispatcher));
                });
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exc) {
                AzureLib.LOGGER.fatal(MARKER, "Couldn't instantiate new client packet from class {}, make sure it declares public default constructor", (Object)clientPacketClass.getSimpleName());
                throw new RuntimeException(exc);
            }
        }
    }
}

