/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.network.AzureLibNetwork;
import mod.azure.azurelib.network.SerializableDataTicket;
import mod.azure.azurelib.util.ClientUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class AnimDataSyncPacket<D>
extends AbstractPacket {
    private final String syncableId;
    private final long instanceId;
    private final SerializableDataTicket<D> dataTicket;
    private final D data;

    public AnimDataSyncPacket(String syncableId, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(this.syncableId);
        buf.method_10791(this.instanceId);
        buf.method_10814(this.dataTicket.id());
        this.dataTicket.encode(this.data, buf);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return AzureLibNetwork.ANIM_DATA_SYNC_PACKET_ID;
    }

    public static <D> void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        String syncableId = buf.method_19772();
        long instanceID = buf.method_10792();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buf.method_19772());
        Object data = dataTicket.decode(buf);
        client.execute(() -> AnimDataSyncPacket.runOnThread(syncableId, instanceID, dataTicket, data));
    }

    private static <D> void runOnThread(String syncableId, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        GeoAnimatable animatable = AzureLibNetwork.getSyncedAnimatable(syncableId);
        if (animatable instanceof SingletonGeoAnimatable) {
            SingletonGeoAnimatable singleton = (SingletonGeoAnimatable)animatable;
            singleton.setAnimData((class_1297)ClientUtils.getClientPlayer(), instanceId, dataTicket, data);
        }
    }
}

