/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.animatable.GeoBlockEntity;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.network.AzureLibNetwork;
import mod.azure.azurelib.util.ClientUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

public class BlockEntityAnimTriggerPacket
extends AbstractPacket {
    private final class_2338 BLOCK_POS;
    private final String CONTROLLER_NAME;
    private final String ANIM_NAME;

    public BlockEntityAnimTriggerPacket(class_2338 blockPos, @Nullable String controllerName, String animName) {
        this.BLOCK_POS = blockPos;
        this.CONTROLLER_NAME = controllerName == null ? "" : controllerName;
        this.ANIM_NAME = animName;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(this.BLOCK_POS);
        buf.method_10814(this.CONTROLLER_NAME);
        buf.method_10814(this.ANIM_NAME);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return AzureLibNetwork.BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID;
    }

    public static void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_2338 BLOCK_POS = buf.method_10811();
        String CONTROLLER_NAME = buf.method_19772();
        String ANIM_NAME = buf.method_19772();
        client.execute(() -> BlockEntityAnimTriggerPacket.runOnThread(BLOCK_POS, CONTROLLER_NAME, ANIM_NAME));
    }

    private static void runOnThread(class_2338 blockPos, String controllerName, String animName) {
        class_2586 blockEntity = ClientUtils.getLevel().method_8321(blockPos);
        if (blockEntity instanceof GeoBlockEntity) {
            GeoBlockEntity getBlockEntity = (GeoBlockEntity)blockEntity;
            getBlockEntity.triggerAnim(controllerName.isEmpty() ? null : controllerName, animName);
        }
    }
}

