/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.object.DataTicket;
import mod.azure.azurelib.event.GeoRenderEvent;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.model.data.EntityModelData;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class GeoReplacedEntityRenderer<E extends class_1297, T extends GeoAnimatable>
extends class_897<E>
implements GeoRenderer<T> {
    protected final GeoModel<T> model;
    protected final List<GeoRenderLayer<T>> renderLayers = new ObjectArrayList();
    protected final T animatable;
    protected E currentEntity;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoReplacedEntityRenderer(class_5617.class_5618 renderManager, GeoModel<T> model, T animatable) {
        super(renderManager);
        this.model = model;
        this.animatable = animatable;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public E getCurrentEntity() {
        return this.currentEntity;
    }

    @Override
    public long getInstanceId(T animatable) {
        return this.currentEntity.method_5628();
    }

    public class_2960 method_3931(E entity) {
        return GeoRenderer.super.getTextureLocation(this.animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers;
    }

    public GeoReplacedEntityRenderer<E, T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.add(renderLayer);
        return this;
    }

    public GeoReplacedEntityRenderer<E, T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoReplacedEntityRenderer<E, T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void method_3936(E entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        this.currentEntity = entity;
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    @Override
    public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean isMoving;
        class_2350 bedDirection;
        class_1297 class_12972;
        class_1309 entity;
        poseStack.method_22903();
        E e = this.currentEntity;
        class_1309 livingEntity = e instanceof class_1309 ? (entity = (class_1309)e) : null;
        boolean shouldSit = this.currentEntity.method_5765() && this.currentEntity.method_5854() != null;
        float lerpBodyRot = livingEntity == null ? 0.0f : class_3532.method_17821((float)partialTick, (float)livingEntity.field_6220, (float)livingEntity.field_6283);
        float lerpHeadRot = livingEntity == null ? 0.0f : class_3532.method_17821((float)partialTick, (float)livingEntity.field_6259, (float)livingEntity.field_6241);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (class_12972 = this.currentEntity.method_5854()) instanceof class_1309) {
            class_1309 livingentity = (class_1309)class_12972;
            lerpBodyRot = class_3532.method_17821((float)partialTick, (float)livingentity.field_6220, (float)livingentity.field_6283);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = class_3532.method_15363((float)class_3532.method_15393((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (this.currentEntity.method_18376() == class_4050.field_18078 && livingEntity != null && (bedDirection = livingEntity.method_18401()) != null) {
            float eyePosOffset = livingEntity.method_18381(class_4050.field_18076) - 0.1f;
            poseStack.method_46416((float)(-bedDirection.method_10148()) * eyePosOffset, 0.0f, (float)(-bedDirection.method_10165()) * eyePosOffset);
        }
        float ageInTicks = (float)((class_1297)this.currentEntity).field_6012 + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!shouldSit && this.currentEntity.method_5805() && livingEntity != null) {
            limbSwingAmount = class_3532.method_16439((float)partialTick, (float)livingEntity.field_42108.field_42109, (float)livingEntity.field_42108.method_48566());
            limbSwing = livingEntity.field_42108.method_48569() - livingEntity.field_42108.method_48566() * (1.0f - partialTick);
            if (livingEntity.method_6109()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        float headPitch = class_3532.method_16439((float)partialTick, (float)((class_1297)this.currentEntity).field_6004, (float)this.currentEntity.method_36455());
        float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
        if (livingEntity != null) {
            class_243 velocity = livingEntity.method_18798();
            float avgVelocity = (float)(Math.abs(velocity.field_1352) + Math.abs(velocity.field_1350)) / 2.0f;
            isMoving = avgVelocity >= motionThreshold && limbSwingAmount != 0.0f;
        } else {
            boolean bl = isMoving = limbSwingAmount <= -motionThreshold || limbSwingAmount >= motionThreshold;
        }
        if (!isReRender) {
            AnimationState<T> animationState = new AnimationState<T>(animatable, limbSwing, limbSwingAmount, partialTick, isMoving);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, animatable.getTick(this.currentEntity));
            animationState.setData(DataTickets.ENTITY, this.currentEntity);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.method_6109(), -netHeadYaw, -headPitch));
            this.model.addAdditionalStateData((GeoAnimatable)animatable, instanceId, (BiConsumer<DataTicket<GeoAnimatable>, GeoAnimatable>)((BiConsumer<DataTicket, GeoAnimatable>)animationState::setData));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        poseStack.method_46416(0.0f, 0.01f, 0.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getTextureLocation((GeoAnimatable)animatable));
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        if (!this.currentEntity.method_5756((class_1657)class_310.method_1551().field_1724)) {
            GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.method_22909();
    }

    @Override
    public void applyRenderLayers(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!this.currentEntity.method_7325()) {
            GeoRenderer.super.applyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    @Override
    public void renderFinal(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        class_1308 mob;
        class_1297 leashHolder;
        super.method_3936(this.currentEntity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        E e = this.currentEntity;
        if (e instanceof class_1308 && (leashHolder = (mob = (class_1308)e).method_5933()) != null) {
            this.renderLeash(mob, partialTick, poseStack, bufferSource, leashHolder);
        }
    }

    @Override
    public void renderRecursively(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.method_22903();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.method_23169((class_1297)this.currentEntity, 1.0f).method_46409()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.currentEntity.method_19538().method_46409()));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.method_22909();
    }

    protected void applyRotations(T animatable, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        class_1309 entity;
        class_1309 livingEntity;
        class_4050 pose = this.currentEntity.method_18376();
        E e = this.currentEntity;
        class_1309 class_13092 = livingEntity = e instanceof class_1309 ? (entity = (class_1309)e) : null;
        if (pose != class_4050.field_18078) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - rotationYaw));
        }
        if (livingEntity != null && livingEntity.field_6213 > 0) {
            float deathRotation = ((float)livingEntity.field_6213 + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(Math.min(class_3532.method_15355((float)deathRotation), 1.0f) * this.getDeathMaxRotation(animatable)));
        } else if (livingEntity != null && livingEntity.method_6123()) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f - livingEntity.method_36455()));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(((float)livingEntity.field_6012 + partialTick) * -75.0f));
        } else if (livingEntity != null && pose == class_4050.field_18078) {
            class_2350 bedOrientation = livingEntity.method_18401();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation) : rotationYaw));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(this.getDeathMaxRotation(animatable)));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
        } else if (this.currentEntity.method_16914() || this.currentEntity instanceof class_1657) {
            String name = this.currentEntity.method_5477().getString();
            E e2 = this.currentEntity;
            if (e2 instanceof class_1657) {
                class_1657 player = (class_1657)e2;
                if (!player.method_7348(class_1664.field_7559)) {
                    return;
                }
            } else {
                name = class_124.method_539((String)name);
            }
            if (name != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
                poseStack.method_46416(0.0f, this.currentEntity.method_17682() + 0.1f, 0.0f);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(T animatable) {
        return 90.0f;
    }

    public boolean method_3921(E entity) {
        double nameRenderDistance;
        double d = nameRenderDistance = this.currentEntity.method_21751() ? 32.0 : 64.0;
        if (this.field_4676.method_23168(this.currentEntity) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return this.currentEntity == this.field_4676.field_4678 && this.currentEntity.method_16914() && class_310.method_1498();
    }

    @Override
    public int getPackedOverlay(T animatable, float u) {
        E e = this.currentEntity;
        if (!(e instanceof class_1309)) {
            return class_4608.field_21444;
        }
        class_1309 entity = (class_1309)e;
        return class_4608.method_23625((int)class_4608.method_23210((float)u), (int)class_4608.method_23212((entity.field_6235 > 0 || entity.field_6213 > 0 ? 1 : 0) != 0));
    }

    public <H extends class_1297, M extends class_1308> void renderLeash(M mob, float partialTick, class_4587 poseStack, class_4597 bufferSource, H leashHolder) {
        int segment;
        double lerpBodyAngle = class_3532.method_16439((float)partialTick, (float)mob.field_6220, (float)mob.field_6283) * ((float)Math.PI / 180) + 1.5707964f;
        class_243 leashOffset = mob.method_29919();
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.field_1350 + Math.sin(lerpBodyAngle) * leashOffset.field_1352;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.field_1350 - Math.cos(lerpBodyAngle) * leashOffset.field_1352;
        double lerpOriginX = class_3532.method_16436((double)partialTick, (double)mob.field_6014, (double)mob.method_23317()) + xAngleOffset;
        double lerpOriginY = class_3532.method_16436((double)partialTick, (double)mob.field_6036, (double)mob.method_23318()) + leashOffset.field_1351;
        double lerpOriginZ = class_3532.method_16436((double)partialTick, (double)mob.field_5969, (double)mob.method_23321()) + zAngleOffset;
        class_243 ropeGripPosition = leashHolder.method_30951(partialTick);
        float xDif = (float)(ropeGripPosition.field_1352 - lerpOriginX);
        float yDif = (float)(ropeGripPosition.field_1351 - lerpOriginY);
        float zDif = (float)(ropeGripPosition.field_1350 - lerpOriginZ);
        float offsetMod = (float)(class_3532.method_15345((double)(xDif * xDif + zDif * zDif)) * (double)0.025f / 2.0);
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23587());
        class_2338 entityEyePos = class_2338.method_49638((class_2374)mob.method_5836(partialTick));
        class_2338 holderEyePos = class_2338.method_49638((class_2374)leashHolder.method_5836(partialTick));
        int entityBlockLight = this.method_24087((class_1297)mob, entityEyePos);
        int holderBlockLight = leashHolder.method_5809() ? 15 : leashHolder.method_37908().method_8314(class_1944.field_9282, holderEyePos);
        int entitySkyLight = mob.method_37908().method_8314(class_1944.field_9284, entityEyePos);
        int holderSkyLight = mob.method_37908().method_8314(class_1944.field_9284, holderEyePos);
        poseStack.method_22903();
        poseStack.method_22904(xAngleOffset, leashOffset.field_1351, zAngleOffset);
        Matrix4f posMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        for (segment = 0; segment <= 24; ++segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.method_22909();
    }

    private static void renderLeashPiece(class_4588 buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)class_3532.method_16439((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)class_3532.method_16439((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = class_765.method_23687((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.method_22918(positionMatrix, x - xOffset, y + yOffset, z + zOffset).method_22915(red, green, blue, 1.0f).method_22916(packedLight).method_1344();
        buffer.method_22918(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).method_22915(red, green, blue, 1.0f).method_22916(packedLight).method_1344();
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((GeoAnimatable)animatable), this.currentEntity.method_5628() + (int)animatable.getTick(this.currentEntity));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        ((GeoRenderEvent.ReplacedEntity.CompileRenderLayers.Listener)GeoRenderEvent.ReplacedEntity.CompileRenderLayers.EVENT.invoker()).handle(new GeoRenderEvent.ReplacedEntity.CompileRenderLayers(this));
    }

    @Override
    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        return ((GeoRenderEvent.ReplacedEntity.Pre.Listener)GeoRenderEvent.ReplacedEntity.Pre.EVENT.invoker()).handle(new GeoRenderEvent.ReplacedEntity.Pre(this, poseStack, model, bufferSource, partialTick, packedLight));
    }

    @Override
    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        ((GeoRenderEvent.ReplacedEntity.Post.Listener)GeoRenderEvent.ReplacedEntity.Post.EVENT.invoker()).handle(new GeoRenderEvent.ReplacedEntity.Post(this, poseStack, model, bufferSource, partialTick, packedLight));
    }
}

