/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.peek.events;

import de.maxhenkel.peek.Peek;
import de.maxhenkel.peek.data.DataStore;
import de.maxhenkel.peek.tooltips.ContainerTooltip;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2336;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_3708;
import net.minecraft.class_5632;

public class TooltipImageEvents {
    private static final String ITEMS = "Items";

    @Nullable
    public static Optional<class_5632> getTooltipImage(class_1799 stack, class_2248 block) {
        if (block instanceof class_2480) {
            return TooltipImageEvents.getShulkerBoxTooltipImage(stack);
        }
        if (block instanceof class_2281) {
            return TooltipImageEvents.getChestTooltipImage(stack);
        }
        if (block instanceof class_3708) {
            return TooltipImageEvents.getBarrelTooltipImage(stack);
        }
        if (block instanceof class_2315) {
            return TooltipImageEvents.getDispenserTooltipImage(stack);
        }
        if (block instanceof class_2377) {
            return TooltipImageEvents.getHopperTooltipImage(stack);
        }
        if (block instanceof class_2336) {
            return TooltipImageEvents.getEnderChestTooltipImage();
        }
        return null;
    }

    private static Optional<class_5632> getEnderChestTooltipImage() {
        if (!Peek.CONFIG.peekEnderChests.get().booleanValue()) {
            return null;
        }
        if (DataStore.enderChestInventory == null) {
            return null;
        }
        return Optional.of(new ContainerTooltip(9, 3, DataStore.enderChestInventory));
    }

    private static Optional<class_5632> getShulkerBoxTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekShulkerBoxes.get().booleanValue()) {
            return null;
        }
        class_2487 blockEntityData = class_1747.method_38072((class_1799)stack);
        if (blockEntityData == null) {
            return null;
        }
        if (!blockEntityData.method_10573(ITEMS, 9)) {
            return null;
        }
        class_2371 items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)blockEntityData, (class_2371)items);
        if (!Peek.CONFIG.showEmptyContainers.get().booleanValue() && items.stream().allMatch(class_1799::method_7960)) {
            return null;
        }
        return Optional.of(new ContainerTooltip(9, 3, (class_2371<class_1799>)items));
    }

    private static Optional<class_5632> getChestTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekChests.get().booleanValue()) {
            return null;
        }
        return TooltipImageEvents.getDefaultChestSizeTooltipImage(stack);
    }

    private static Optional<class_5632> getBarrelTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekBarrels.get().booleanValue()) {
            return null;
        }
        return TooltipImageEvents.getDefaultChestSizeTooltipImage(stack);
    }

    private static Optional<class_5632> getDispenserTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekDispensers.get().booleanValue()) {
            return null;
        }
        class_2487 blockEntityData = class_1747.method_38072((class_1799)stack);
        if (blockEntityData == null) {
            return null;
        }
        if (!blockEntityData.method_10573(ITEMS, 9)) {
            return null;
        }
        class_2371 items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)blockEntityData, (class_2371)items);
        if (!Peek.CONFIG.showEmptyContainers.get().booleanValue() && items.stream().allMatch(class_1799::method_7960)) {
            return null;
        }
        return Optional.of(new ContainerTooltip(3, 3, (class_2371<class_1799>)items));
    }

    private static Optional<class_5632> getHopperTooltipImage(class_1799 stack) {
        if (!Peek.CONFIG.peekHoppers.get().booleanValue()) {
            return null;
        }
        class_2487 blockEntityData = class_1747.method_38072((class_1799)stack);
        if (blockEntityData == null) {
            return null;
        }
        if (!blockEntityData.method_10573(ITEMS, 9)) {
            return null;
        }
        class_2371 items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)blockEntityData, (class_2371)items);
        if (!Peek.CONFIG.showEmptyContainers.get().booleanValue() && items.stream().allMatch(class_1799::method_7960)) {
            return null;
        }
        return Optional.of(new ContainerTooltip(5, 1, (class_2371<class_1799>)items));
    }

    private static Optional<class_5632> getDefaultChestSizeTooltipImage(class_1799 stack) {
        class_2487 blockEntityData = class_1747.method_38072((class_1799)stack);
        if (blockEntityData == null) {
            return null;
        }
        if (!blockEntityData.method_10573(ITEMS, 9)) {
            return null;
        }
        class_2371 items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)blockEntityData, (class_2371)items);
        if (!Peek.CONFIG.showEmptyContainers.get().booleanValue() && items.stream().allMatch(class_1799::method_7960)) {
            return null;
        }
        return Optional.of(new ContainerTooltip(9, 3, (class_2371<class_1799>)items));
    }
}

