/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.serialize.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.world.item.enchantment.data.BuiltInEnchantmentDataManager;
import fuzs.universalenchants.world.item.enchantment.serialize.EnchantmentHolder;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.DataEntry;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1886;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public abstract class TypeEntry
extends DataEntry<class_1792> {
    private static final TypeEntry EMPTY = new TypeEntry(){

        @Override
        String serialize() {
            throw new UnsupportedOperationException("serialize called on empty enchantment category entry");
        }

        @Override
        public void dissolve(Set<class_1792> items) throws JsonSyntaxException {
            throw new UnsupportedOperationException("dissolve called on empty enchantment category entry");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private boolean exclude;

    public static void deserializeCategoryEntry(class_2960 enchantment, EnchantmentHolder holder, JsonElement jsonElement) throws JsonSyntaxException {
        String item;
        boolean exclude = false;
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject1 = jsonElement.getAsJsonObject();
            item = class_3518.method_15265((JsonObject)jsonObject1, (String)"id");
            exclude = class_3518.method_15270((JsonObject)jsonObject1, (String)"exclude");
        } else {
            item = class_3518.method_15287((JsonElement)jsonElement, (String)"item");
        }
        try {
            TypeEntry entry = item.startsWith("$") ? CategoryEntry.deserialize(enchantment, item) : (item.startsWith("#") ? TagEntry.deserialize(enchantment, item) : ItemEntry.deserialize(enchantment, item));
            entry.setExclude(exclude);
            holder.submit(entry);
        }
        catch (Exception e) {
            UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)item, (Object)e);
        }
    }

    @Override
    public final void serialize(JsonArray jsonArray) {
        if (!this.exclude) {
            jsonArray.add(this.serialize());
        } else {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", this.serialize());
            jsonObject.addProperty("exclude", Boolean.valueOf(true));
            jsonArray.add((JsonElement)jsonObject);
        }
    }

    abstract String serialize();

    public boolean isEmpty() {
        return false;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public static class CategoryEntry
    extends TypeEntry {
        private final class_1886 category;

        CategoryEntry(class_1886 category) {
            this.category = category;
        }

        @Override
        public void dissolve(Set<class_1792> items) throws JsonSyntaxException {
            for (class_1792 item : class_7923.field_41178) {
                if (!this.category.method_8177(item)) continue;
                items.add(item);
            }
        }

        @Override
        String serialize() {
            Objects.requireNonNull(this.category, "category is null");
            class_2960 identifier = (class_2960)BuiltInEnchantmentDataManager.INSTANCE.getEnchantmentCategoriesIdMap().get((Object)this.category);
            Objects.requireNonNull(identifier, "identifier for category %s is null".formatted(this.category));
            return "$" + identifier;
        }

        public static TypeEntry deserialize(class_2960 enchantment, String s) throws JsonSyntaxException {
            if (s.startsWith("$")) {
                s = s.substring(1);
            }
            class_2960 id = new class_2960(s);
            class_1886 category = (class_1886)BuiltInEnchantmentDataManager.INSTANCE.getEnchantmentCategoriesIdMap().inverse().get((Object)id);
            if (category == null) {
                JsonSyntaxException e = new JsonSyntaxException("No category with name %s found".formatted(id));
                UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)id, (Object)e);
                return EMPTY;
            }
            return new CategoryEntry(category);
        }
    }

    public static class TagEntry
    extends TypeEntry {
        private final class_6862<class_1792> tag;

        TagEntry(class_6862<class_1792> tag) {
            this.tag = tag;
        }

        @Override
        public void dissolve(Set<class_1792> items) throws JsonSyntaxException {
            for (class_6880 holder : class_7923.field_41178.method_40286(this.tag)) {
                items.add((class_1792)holder.comp_349());
            }
        }

        @Override
        String serialize() {
            return "#" + this.tag.comp_327();
        }

        public static TypeEntry deserialize(class_2960 enchantment, String s) throws JsonSyntaxException {
            class_2960 id;
            class_6862 tag;
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (class_7923.field_41178.method_40266(tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)(id = new class_2960(s)))).isEmpty()) {
                JsonSyntaxException e = new JsonSyntaxException("No tag with name %s found".formatted(id));
                UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)id, (Object)e);
                return EMPTY;
            }
            return new TagEntry((class_6862<class_1792>)tag);
        }
    }

    public static class ItemEntry
    extends TypeEntry {
        private final class_1792 item;

        ItemEntry(class_1792 item) {
            this.item = item;
        }

        @Override
        public void dissolve(Set<class_1792> items) throws JsonSyntaxException {
            items.add(this.item);
        }

        @Override
        String serialize() {
            return class_7923.field_41178.method_10221((Object)this.item).toString();
        }

        public static TypeEntry deserialize(class_2960 enchantment, String s) throws JsonSyntaxException {
            class_2960 id = new class_2960(s);
            if (!class_7923.field_41178.method_10250(id)) {
                JsonSyntaxException e = new JsonSyntaxException("No item with name %s found".formatted(id));
                UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)id, (Object)e);
                return EMPTY;
            }
            return new ItemEntry((class_1792)class_7923.field_41178.method_10223(id));
        }
    }
}

