/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import java.util.ArrayList;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.lib.entrypoint.api.FrozenModInitializer;
import net.frozenblock.lib.mobcategory.api.entrypoint.FrozenMobCategoryEntrypoint;
import net.frozenblock.lib.mobcategory.impl.FrozenMobCategory;
import net.frozenblock.wilderwild.block.entity.PalmCrownBlockEntity;
import net.frozenblock.wilderwild.config.EntityConfig;
import net.frozenblock.wilderwild.entity.Jellyfish;
import net.frozenblock.wilderwild.entity.ai.TermiteManager;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.misc.command.SpreadSculkCommand;
import net.frozenblock.wilderwild.misc.datafixer.DrySandStateFix;
import net.frozenblock.wilderwild.misc.datafixer.NematocystStateFix;
import net.frozenblock.wilderwild.misc.datafixer.OsseousSculkStateFix;
import net.frozenblock.wilderwild.misc.datafixer.ScorchedSandStateFix2;
import net.frozenblock.wilderwild.misc.mod_compat.WilderModIntegrations;
import net.frozenblock.wilderwild.registry.RegisterBlockEntities;
import net.frozenblock.wilderwild.registry.RegisterBlockSoundTypes;
import net.frozenblock.wilderwild.registry.RegisterBlocks;
import net.frozenblock.wilderwild.registry.RegisterCriteria;
import net.frozenblock.wilderwild.registry.RegisterEntities;
import net.frozenblock.wilderwild.registry.RegisterFeatures;
import net.frozenblock.wilderwild.registry.RegisterGameEvents;
import net.frozenblock.wilderwild.registry.RegisterItems;
import net.frozenblock.wilderwild.registry.RegisterLootTables;
import net.frozenblock.wilderwild.registry.RegisterParticles;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.frozenblock.wilderwild.registry.RegisterResources;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.frozenblock.wilderwild.registry.RegisterWorldgen;
import net.frozenblock.wilderwild.registry.WilderRegistry;
import net.frozenblock.wilderwild.world.additions.gen.WilderWorldGen;
import net.frozenblock.wilderwild.world.generation.conditionsource.BetaBeachConditionSource;
import net.minecraft.class_1220;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixerBuilder;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixes;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.SimpleFixes;

public final class WilderWild
extends FrozenModInitializer
implements FrozenMobCategoryEntrypoint {
    public static final class_2960 SEED_PACKET = WilderSharedConstants.id("seed_particle_packet");
    public static final class_2960 CONTROLLED_SEED_PACKET = WilderSharedConstants.id("controlled_seed_particle_packet");
    public static final class_2960 FLOATING_SCULK_BUBBLE_PACKET = WilderSharedConstants.id("floating_sculk_bubble_easy_packet");
    public static final class_2960 TERMITE_PARTICLE_PACKET = WilderSharedConstants.id("termite_particle_packet");
    public static final class_2960 SENSOR_HICCUP_PACKET = WilderSharedConstants.id("sensor_hiccup_packet");
    public static final class_2960 JELLY_STING_PACKET = WilderSharedConstants.id("jelly_sting_packet");
    @Nullable
    public static WilderWild INSTANCE;

    public WilderWild() {
        super("wilderwild");
        INSTANCE = this;
    }

    private static void applyDataFixes(@NotNull ModContainer mod) {
        WilderSharedConstants.log("Applying DataFixes for Wilder Wild with Data Version 15", true);
        QuiltDataFixerBuilder builder = new QuiltDataFixerBuilder(15);
        builder.addSchema(0, QuiltDataFixes.BASE_SCHEMA);
        Schema schemaV1 = builder.addSchema(1, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename white_dandelion to blooming_dandelion", (class_2960)WilderSharedConstants.id("white_dandelion"), (class_2960)WilderSharedConstants.id("blooming_dandelion"), (Schema)schemaV1);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_white_dandelion to potted_blooming_dandelion", (class_2960)WilderSharedConstants.id("potted_white_dandelion"), (class_2960)WilderSharedConstants.id("potted_blooming_dandelion"), (Schema)schemaV1);
        Schema schemaV2 = builder.addSchema(2, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename blooming_dandelion to seeding_dandelion", (class_2960)WilderSharedConstants.id("blooming_dandelion"), (class_2960)WilderSharedConstants.id("seeding_dandelion"), (Schema)schemaV2);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_blooming_dandelion to potted_seeding_dandelion", (class_2960)WilderSharedConstants.id("potted_blooming_dandelion"), (class_2960)WilderSharedConstants.id("potted_seeding_dandelion"), (Schema)schemaV2);
        Schema schemaV3 = builder.addSchema(3, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename floating_moss to algae", (class_2960)WilderSharedConstants.id("floating_moss"), (class_2960)WilderSharedConstants.id("algae"), (Schema)schemaV3);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename floating_moss to algae", (class_2960)WilderSharedConstants.id("floating_moss"), (class_2960)WilderSharedConstants.id("algae"), (Schema)schemaV3);
        Schema schemaV4 = builder.addSchema(4, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename test_1 to null_block", (class_2960)WilderSharedConstants.id("test_1"), (class_2960)WilderSharedConstants.id("null_block"), (Schema)schemaV4);
        Schema schemaV5 = builder.addSchema(5, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename sculk_echoer to null_block", (class_2960)WilderSharedConstants.id("sculk_echoer"), (class_2960)WilderSharedConstants.id("null_block"), (Schema)schemaV5);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename sculk_jaw to null_block", (class_2960)WilderSharedConstants.id("sculk_jaw"), (class_2960)WilderSharedConstants.id("null_block"), (Schema)schemaV5);
        Schema schemaV6 = builder.addSchema(6, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename baobab_sapling to baobab_nut", (class_2960)WilderSharedConstants.id("baobab_sapling"), (class_2960)WilderSharedConstants.id("baobab_nut"), (Schema)schemaV6);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename baobab_nut_sapling to baobab_nut", (class_2960)WilderSharedConstants.id("baobab_nut_sapling"), (class_2960)WilderSharedConstants.id("baobab_nut"), (Schema)schemaV6);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_baobab_sapling to potted_baobab_nut", (class_2960)WilderSharedConstants.id("potted_baobab_sapling"), (class_2960)WilderSharedConstants.id("potted_baobab_nut"), (Schema)schemaV6);
        Schema schemaV7 = builder.addSchema(7, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename firefly_lantern to display_lantern", (class_2960)WilderSharedConstants.id("firefly_lantern"), (class_2960)WilderSharedConstants.id("display_lantern"), (Schema)schemaV7);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename mesoglea to blue_pearlescent_mesoglea", (class_2960)WilderSharedConstants.id("mesoglea"), (class_2960)WilderSharedConstants.id("blue_pearlescent_mesoglea"), (Schema)schemaV7);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename mesoglea to blue_pearlescent_mesoglea", (class_2960)WilderSharedConstants.id("mesoglea"), (class_2960)WilderSharedConstants.id("blue_pearlescent_mesoglea"), (Schema)schemaV7);
        Schema schemaV8 = builder.addSchema(8, class_1220::new);
        SimpleFixes.addBlockStateRenameFix((DataFixerBuilder)builder, (String)"display_lantern_rename_fix", (class_2960)WilderSharedConstants.id("display_lantern"), (String)"light", (String)"0", (String)"display_light", (Schema)schemaV8);
        Schema schemaV9 = builder.addSchema(9, class_1220::new);
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "blue_nematocyst_fix", WilderSharedConstants.id("blue_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "blue_pearlescent_nematocyst_fix", WilderSharedConstants.id("blue_pearlescent_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "lime_nematocyst_fix", WilderSharedConstants.id("lime_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "pink_nematocyst_fix", WilderSharedConstants.id("pink_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "purple_pearlescent_nematocyst_fix", WilderSharedConstants.id("purple_pearlescent_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "red_nematocyst_fix", WilderSharedConstants.id("red_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "yellow_nematocyst_fix", WilderSharedConstants.id("yellow_nematocyst")));
        Schema schemaV10 = builder.addSchema(10, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename palm_sapling to coconut", (class_2960)WilderSharedConstants.id("palm_sapling"), (class_2960)WilderSharedConstants.id("coconut"), (Schema)schemaV10);
        Schema schemaV11 = builder.addSchema(11, class_1220::new);
        builder.addFixer((DataFix)new DrySandStateFix(schemaV11, "dry_sand_crackness_to_crackedness", WilderSharedConstants.id("dry_sand")));
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename dry_sand to scorched_sand", (class_2960)WilderSharedConstants.id("dry_sand"), (class_2960)WilderSharedConstants.id("scorched_sand"), (Schema)schemaV11);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename dry_sand to scorched_sand", (class_2960)WilderSharedConstants.id("dry_sand"), (class_2960)WilderSharedConstants.id("scorched_sand"), (Schema)schemaV11);
        builder.addFixer((DataFix)new DrySandStateFix(schemaV11, "scorched_sand_crackness_to_crackedness", WilderSharedConstants.id("scorched_sand")));
        Schema schemaV13 = builder.addSchema(13, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename palm_leaves to palm_fronds", (class_2960)WilderSharedConstants.id("palm_leaves"), (class_2960)WilderSharedConstants.id("palm_fronds"), (Schema)schemaV13);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename palm_leaves to palm_fronds", (class_2960)WilderSharedConstants.id("palm_leaves"), (class_2960)WilderSharedConstants.id("palm_fronds"), (Schema)schemaV13);
        Schema schemaV14 = builder.addSchema(14, class_1220::new);
        builder.addFixer((DataFix)new ScorchedSandStateFix2(schemaV14, "scorched_sand_integer_to_boolean", WilderSharedConstants.id("scorched_sand")));
        builder.addFixer((DataFix)new ScorchedSandStateFix2(schemaV14, "scorched_red_sand_integer_to_boolean", WilderSharedConstants.id("scorched_red_sand")));
        Schema schemaV15 = builder.addSchema(15, class_1220::new);
        builder.addFixer((DataFix)new OsseousSculkStateFix(schemaV15, "osseous_sculk_axis_to_direction", WilderSharedConstants.id("osseous_sculk")));
        QuiltDataFixes.buildAndRegisterFixer((ModContainer)mod, (QuiltDataFixerBuilder)builder);
        WilderSharedConstants.log("DataFixes for Wilder Wild have been applied", true);
    }

    public void onInitialize(String modId, ModContainer container) {
        WilderSharedConstants.startMeasuring((Object)this);
        WilderWild.applyDataFixes(container);
        WilderRegistry.initRegistry();
        RegisterBlocks.registerBlocks();
        RegisterItems.registerItems();
        RegisterItems.registerBlockItems();
        RegisterGameEvents.registerEvents();
        RegisterBlocks.registerDispenses();
        RegisterSounds.init();
        RegisterBlockSoundTypes.init();
        RegisterBlockEntities.register();
        RegisterEntities.init();
        RegisterLootTables.init();
        RegisterParticles.registerParticles();
        RegisterResources.register(container);
        RegisterProperties.init();
        RegisterCriteria.init();
        RegisterFeatures.init();
        RegisterWorldgen.init();
        WilderWorldGen.generateWildWorldGen();
        class_2378.method_10230((class_2378)class_7923.field_41158, (class_2960)WilderSharedConstants.id("beta_beach_condition_source"), (Object)BetaBeachConditionSource.CODEC.comp_640());
        TermiteManager.Termite.addDegradableBlocks();
        TermiteManager.Termite.addNaturalDegradableBlocks();
        RegisterBlocks.registerBlockProperties();
        ServerLifecycleEvents.SERVER_STOPPED.register(listener -> {
            PalmCrownBlockEntity.PalmCrownPositions.clearAll();
            Jellyfish.clearLevelToNonPearlescentCount();
        });
        ServerTickEvents.START_SERVER_TICK.register(listener -> {
            PalmCrownBlockEntity.PalmCrownPositions.clearAndSwitch();
            Jellyfish.clearLevelToNonPearlescentCount();
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> SpreadSculkCommand.register((CommandDispatcher<class_2168>)dispatcher));
        WilderModIntegrations.init();
        WilderSharedConstants.stopMeasuring((Object)this);
    }

    public void newCategories(@NotNull ArrayList<FrozenMobCategory> context) {
        context.add(FrozenMobCategoryEntrypoint.createCategory((class_2960)this.id("fireflies"), (int)EntityConfig.get().firefly.fireflySpawnCap, (boolean)true, (boolean)false, (int)80));
        context.add(FrozenMobCategoryEntrypoint.createCategory((class_2960)this.id("jellyfish"), (int)EntityConfig.get().jellyfish.jellyfishSpawnCap, (boolean)true, (boolean)false, (int)64));
        context.add(FrozenMobCategoryEntrypoint.createCategory((class_2960)this.id("tumbleweed"), (int)EntityConfig.get().tumbleweed.tumbleweedSpawnCap, (boolean)true, (boolean)false, (int)64));
    }
}

