/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.frozenblock.lib.item.api.ItemBlockStateTagUtils;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.menu.api.Panoramas;
import net.frozenblock.lib.menu.api.SplashTextAPI;
import net.frozenblock.lib.sound.api.FlyBySoundHub;
import net.frozenblock.wilderwild.WilderWild;
import net.frozenblock.wilderwild.entity.render.blockentity.DisplayLanternBlockEntityRenderer;
import net.frozenblock.wilderwild.entity.render.blockentity.HangingTendrilBlockEntityRenderer;
import net.frozenblock.wilderwild.entity.render.blockentity.SculkSensorBlockEntityRenderer;
import net.frozenblock.wilderwild.entity.render.blockentity.StoneChestBlockEntityRenderer;
import net.frozenblock.wilderwild.entity.render.easter.EasterEggs;
import net.frozenblock.wilderwild.entity.render.model.AncientHornProjectileModel;
import net.frozenblock.wilderwild.entity.render.model.JellyfishModel;
import net.frozenblock.wilderwild.entity.render.model.TumbleweedModel;
import net.frozenblock.wilderwild.entity.render.renderer.AncientHornProjectileRenderer;
import net.frozenblock.wilderwild.entity.render.renderer.FireflyRenderer;
import net.frozenblock.wilderwild.entity.render.renderer.JellyfishRenderer;
import net.frozenblock.wilderwild.entity.render.renderer.TumbleweedRenderer;
import net.frozenblock.wilderwild.item.FireflyBottle;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.particle.FallingParticle;
import net.frozenblock.wilderwild.particle.FloatingSculkBubbleParticle;
import net.frozenblock.wilderwild.particle.MesogleaDripParticle;
import net.frozenblock.wilderwild.particle.PollenParticle;
import net.frozenblock.wilderwild.particle.SeedParticle;
import net.frozenblock.wilderwild.particle.TermiteParticle;
import net.frozenblock.wilderwild.particle.options.FloatingSculkBubbleParticleOptions;
import net.frozenblock.wilderwild.particle.options.SeedParticleOptions;
import net.frozenblock.wilderwild.registry.RegisterBlockEntities;
import net.frozenblock.wilderwild.registry.RegisterBlocks;
import net.frozenblock.wilderwild.registry.RegisterEntities;
import net.frozenblock.wilderwild.registry.RegisterItems;
import net.frozenblock.wilderwild.registry.RegisterParticles;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.minecraft.class_1163;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3419;
import net.minecraft.class_5272;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_953;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class WilderWildClient
implements ClientModInitializer {
    public static final class_5601 ANCIENT_HORN_PROJECTILE_LAYER = new class_5601(WilderSharedConstants.id("ancient_horn_projectile"), "main");
    public static final class_5601 SCULK_SENSOR = new class_5601(WilderSharedConstants.id("sculk_sensor"), "main");
    public static final class_5601 HANGING_TENDRIL = new class_5601(WilderSharedConstants.id("hanging_tendril"), "main");
    public static final class_5601 DISPLAY_LANTERN = new class_5601(WilderSharedConstants.id("display_lantern"), "main");
    public static final class_5601 STONE_CHEST = new class_5601(WilderSharedConstants.id("stone_chest"), "main");
    public static final class_5601 DOUBLE_STONE_CHEST_LEFT = new class_5601(WilderSharedConstants.id("double_stone_chest_left"), "main");
    public static final class_5601 DOUBLE_STONE_CHEST_RIGHT = new class_5601(WilderSharedConstants.id("double_stone_chest_right"), "main");
    public static final class_5601 JELLYFISH = new class_5601(WilderSharedConstants.id("jellyfish"), "main");
    public static final class_5601 TUMBLEWEED = new class_5601(WilderSharedConstants.id("tumbleweed"), "main");

    private static void receiveEasyEchoerBubblePacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WilderWild.FLOATING_SCULK_BUBBLE_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            class_243 pos = new class_243(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
            double size = byteBuf.readDouble();
            int age = byteBuf.readInt();
            double yVel = byteBuf.readDouble();
            int count = byteBuf.method_10816();
            ctx.execute(() -> {
                if (ctx.field_1687 == null) {
                    throw new IllegalStateException("why is your world null");
                }
                class_5819 random = AdvancedMath.random();
                for (int i = 0; i < count; ++i) {
                    double xVel = (random.method_43058() - 0.5) / 9.5;
                    double zVel = (random.method_43058() - 0.5) / 9.5;
                    if (size >= 1.0) {
                        xVel = (random.method_43058() - 0.5) / 10.5;
                        zVel = (random.method_43058() - 0.5) / 10.5;
                    }
                    ctx.field_1687.method_8406((class_2394)new FloatingSculkBubbleParticleOptions(size, age, new class_243(xVel, yVel, zVel)), pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                }
            });
        });
    }

    private static void receiveSeedPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WilderWild.SEED_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            class_243 pos = new class_243(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
            int count = byteBuf.method_10816();
            boolean milkweed = byteBuf.readBoolean();
            ctx.execute(() -> {
                if (ctx.field_1687 == null) {
                    throw new IllegalStateException("why is your world null");
                }
                for (int i = 0; i < count; ++i) {
                    ctx.field_1687.method_8406((class_2394)new SeedParticleOptions(milkweed, false), pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                }
            });
        });
    }

    private static void receiveControlledSeedPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WilderWild.CONTROLLED_SEED_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            class_243 pos = new class_243(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
            double velx = byteBuf.readDouble();
            double vely = byteBuf.readDouble();
            double velz = byteBuf.readDouble();
            int count = byteBuf.method_10816();
            boolean milkweed = byteBuf.readBoolean();
            double posRandomizer = byteBuf.readDouble();
            ctx.execute(() -> {
                if (ctx.field_1687 == null) {
                    throw new IllegalStateException("why is your world null");
                }
                for (int i = 0; i < count; ++i) {
                    ctx.field_1687.method_8406((class_2394)new SeedParticleOptions(milkweed, true), pos.field_1352, pos.field_1351 + (double)(ctx.field_1687.field_9229.method_43056() ? -1 : 1) * (ctx.field_1687.field_9229.method_43058() * posRandomizer), pos.field_1350, velx, vely + ctx.field_1687.field_9229.method_43058() * 0.07, velz);
                }
            });
        });
    }

    private static void receiveTermitePacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WilderWild.TERMITE_PARTICLE_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            class_243 pos = new class_243(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
            AtomicInteger count = new AtomicInteger(byteBuf.method_10816());
            ctx.execute(() -> {
                if (ctx.field_1687 == null) {
                    throw new IllegalStateException("why is your world null");
                }
                count.addAndGet(-1);
                ctx.field_1687.method_8494((class_2394)RegisterParticles.TERMITE, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                for (int i = 0; i < count.get(); ++i) {
                    ctx.field_1687.method_8406((class_2394)RegisterParticles.TERMITE, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                }
            });
        });
    }

    private static void receiveSensorHiccupPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WilderWild.SENSOR_HICCUP_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            class_243 pos = new class_243(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
            ctx.execute(() -> {
                if (ctx.field_1687 == null) {
                    throw new IllegalStateException("why is your world null");
                }
                class_638 level = ctx.field_1687;
                int i = 5578058;
                boolean bl2 = level.field_9229.method_43056();
                if (bl2) {
                    double d = (double)(i >> 16 & 0xFF) / 255.0;
                    double e = (double)(i >> 8 & 0xFF) / 255.0;
                    double f = (double)(i & 0xFF) / 255.0;
                    level.method_8406((class_2394)class_2398.field_11226, pos.field_1352, pos.field_1351, pos.field_1350, d, e, f);
                }
            });
        });
    }

    private static void receiveJellyStingPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WilderWild.JELLY_STING_PACKET, (ctx, handler, byteBuf, responseSender) -> ctx.execute(() -> {
            class_746 player;
            boolean baby = byteBuf.readBoolean();
            if (ctx.field_1687 != null && (player = ctx.field_1724) != null) {
                ctx.field_1687.method_43128((class_1657)player, player.method_23317(), player.method_23318(), player.method_23321(), RegisterSounds.ENTITY_JELLYFISH_STING, class_3419.field_15254, 1.0f, ctx.field_1687.field_9229.method_43057() * 0.2f + (baby ? 1.2f : 0.9f));
            }
        }));
    }

    public void onInitializeClient() {
        SplashTextAPI.addSplashLocation((class_2960)WilderSharedConstants.id("texts/splashes.txt"));
        Panoramas.addPanorama((class_2960)WilderSharedConstants.id("textures/gui/title/first/panorama"));
        Panoramas.addPanorama((class_2960)WilderSharedConstants.id("textures/gui/title/second/panorama"));
        EasterEggs.registerEaster();
        BlockRenderLayerMap renderLayerRegistry = BlockRenderLayerMap.INSTANCE;
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.CARNATION, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.SEEDING_DANDELION, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_CARNATION, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_SEEDING_DANDELION, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_BAOBAB_NUT, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_CYPRESS_SAPLING, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_COCONUT, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_BIG_DRIPLEAF, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_SMALL_DRIPLEAF, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_GRASS, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_TUMBLEWEED_PLANT, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_TUMBLEWEED, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_BUSH, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POTTED_PRICKLY_PEAR, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.DATURA, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.CATTAIL, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.ALGAE, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.MILKWEED, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.POLLEN_BLOCK, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.ECHO_GLASS, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HANGING_TENDRIL, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.FLOWERING_LILY_PAD, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BROWN_SHELF_FUNGUS, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.RED_SHELF_FUNGUS, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BAOBAB_DOOR, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.CYPRESS_DOOR, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PALM_DOOR, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BAOBAB_TRAPDOOR, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.CYPRESS_TRAPDOOR, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PALM_TRAPDOOR, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BAOBAB_NUT, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.CYPRESS_SAPLING, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.COCONUT, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.GLORY_OF_THE_SNOW, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.WHITE_GLORY_OF_THE_SNOW, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BLUE_GLORY_OF_THE_SNOW, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PINK_GLORY_OF_THE_SNOW, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PURPLE_GLORY_OF_THE_SNOW, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BUSH, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PRICKLY_PEAR_CACTUS, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.TERMITE_MOUND, class_1921.method_23577());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.DISPLAY_LANTERN, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_ACACIA_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_BAOBAB_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_BIRCH_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_CHERRY_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_CYPRESS_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_DARK_OAK_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_JUNGLE_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_MANGROVE_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_OAK_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_SPRUCE_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_PALM_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_CRIMSON_STEM, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.HOLLOWED_WARPED_STEM, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_ACACIA_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_BAOBAB_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_BIRCH_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_CHERRY_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_CYPRESS_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_DARK_OAK_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_JUNGLE_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_MANGROVE_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_OAK_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_SPRUCE_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_PALM_LOG, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_CRIMSON_STEM, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.STRIPPED_HOLLOWED_WARPED_STEM, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BLUE_PEARLESCENT_MESOGLEA, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PURPLE_PEARLESCENT_MESOGLEA, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BLUE_MESOGLEA, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.LIME_MESOGLEA, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PINK_MESOGLEA, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.RED_MESOGLEA, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.YELLOW_MESOGLEA, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BLUE_PEARLESCENT_NEMATOCYST, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PURPLE_PEARLESCENT_NEMATOCYST, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.BLUE_NEMATOCYST, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.LIME_NEMATOCYST, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.PINK_NEMATOCYST, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.RED_NEMATOCYST, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.YELLOW_NEMATOCYST, class_1921.method_23583());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.TUMBLEWEED_PLANT, class_1921.method_23581());
        renderLayerRegistry.putBlock((class_2248)RegisterBlocks.TUMBLEWEED, class_1921.method_23581());
        ParticleFactoryRegistry particleRegistry = ParticleFactoryRegistry.getInstance();
        particleRegistry.register((class_2396)RegisterParticles.POLLEN, PollenParticle.PollenFactory::new);
        particleRegistry.register(RegisterParticles.SEED, SeedParticle.Factory::new);
        particleRegistry.register(RegisterParticles.FLOATING_SCULK_BUBBLE, FloatingSculkBubbleParticle.BubbleFactory::new);
        particleRegistry.register((class_2396)RegisterParticles.TERMITE, TermiteParticle.Factory::new);
        particleRegistry.register((class_2396)RegisterParticles.COCONUT_SPLASH, FallingParticle.Factory::new);
        particleRegistry.register((class_2396)RegisterParticles.BLUE_PEARLESCENT_HANGING_MESOGLEA, MesogleaDripParticle.BPMesogleaHangProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.BLUE_PEARLESCENT_FALLING_MESOGLEA, MesogleaDripParticle.BPMesogleaFallProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.BLUE_PEARLESCENT_LANDING_MESOGLEA, MesogleaDripParticle.BPMesogleaLandProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.PURPLE_PEARLESCENT_HANGING_MESOGLEA, MesogleaDripParticle.PPMesogleaHangProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.PURPLE_PEARLESCENT_FALLING_MESOGLEA, MesogleaDripParticle.PPMesogleaFallProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.PURPLE_PEARLESCENT_LANDING_MESOGLEA, MesogleaDripParticle.PPMesogleaLandProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.BLUE_HANGING_MESOGLEA, MesogleaDripParticle.BMesogleaHangProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.BLUE_FALLING_MESOGLEA, MesogleaDripParticle.BMesogleaFallProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.BLUE_LANDING_MESOGLEA, MesogleaDripParticle.BMesogleaLandProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.YELLOW_HANGING_MESOGLEA, MesogleaDripParticle.YMesogleaHangProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.YELLOW_FALLING_MESOGLEA, MesogleaDripParticle.YMesogleaFallProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.YELLOW_LANDING_MESOGLEA, MesogleaDripParticle.YMesogleaLandProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.LIME_HANGING_MESOGLEA, MesogleaDripParticle.LMesogleaHangProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.LIME_FALLING_MESOGLEA, MesogleaDripParticle.LMesogleaFallProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.LIME_LANDING_MESOGLEA, MesogleaDripParticle.LMesogleaLandProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.PINK_HANGING_MESOGLEA, MesogleaDripParticle.PMesogleaHangProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.PINK_FALLING_MESOGLEA, MesogleaDripParticle.PMesogleaFallProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.PINK_LANDING_MESOGLEA, MesogleaDripParticle.PMesogleaLandProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.RED_HANGING_MESOGLEA, MesogleaDripParticle.RMesogleaHangProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.RED_FALLING_MESOGLEA, MesogleaDripParticle.RMesogleaFallProvider::new);
        particleRegistry.register((class_2396)RegisterParticles.RED_LANDING_MESOGLEA, MesogleaDripParticle.RMesogleaLandProvider::new);
        EntityRendererRegistry.register(RegisterEntities.FIREFLY, FireflyRenderer::new);
        EntityRendererRegistry.register(RegisterEntities.ANCIENT_HORN_PROJECTILE_ENTITY, AncientHornProjectileRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)ANCIENT_HORN_PROJECTILE_LAYER, AncientHornProjectileModel::createBodyLayer);
        EntityRendererRegistry.register(RegisterEntities.JELLYFISH, JellyfishRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)JELLYFISH, JellyfishModel::createBodyLayer);
        EntityRendererRegistry.register(RegisterEntities.TUMBLEWEED, TumbleweedRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)TUMBLEWEED, TumbleweedModel::createBodyLayer);
        EntityRendererRegistry.register(RegisterEntities.COCONUT, class_953::new);
        class_5616.method_32144((class_2591)class_2591.field_28117, SculkSensorBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)class_2591.field_43258, SculkSensorBlockEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)SCULK_SENSOR, SculkSensorBlockEntityRenderer::getTexturedModelData);
        class_5616.method_32144(RegisterBlockEntities.HANGING_TENDRIL, HangingTendrilBlockEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)HANGING_TENDRIL, HangingTendrilBlockEntityRenderer::getTexturedModelData);
        class_5616.method_32144(RegisterBlockEntities.DISPLAY_LANTERN, DisplayLanternBlockEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)DISPLAY_LANTERN, DisplayLanternBlockEntityRenderer::getTexturedModelData);
        class_5616.method_32144(RegisterBlockEntities.STONE_CHEST, StoneChestBlockEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)STONE_CHEST, StoneChestBlockEntityRenderer::createSingleBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)DOUBLE_STONE_CHEST_LEFT, StoneChestBlockEntityRenderer::createDoubleBodyLeftLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)DOUBLE_STONE_CHEST_RIGHT, StoneChestBlockEntityRenderer::createDoubleBodyRightLayer);
        WilderWildClient.receiveEasyEchoerBubblePacket();
        WilderWildClient.receiveSeedPacket();
        WilderWildClient.receiveControlledSeedPacket();
        WilderWildClient.receiveTermitePacket();
        WilderWildClient.receiveSensorHiccupPacket();
        WilderWildClient.receiveJellyStingPacket();
        FlyBySoundHub.AUTO_ENTITIES_AND_SOUNDS.put(RegisterEntities.ANCIENT_HORN_PROJECTILE_ENTITY, new FlyBySoundHub.FlyBySound(1.0f, 0.5f, class_3419.field_15248, RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_FLYBY));
        class_5272.method_27879((class_1792)RegisterItems.ANCIENT_HORN, (class_2960)WilderSharedConstants.vanillaId("tooting"), (itemStack, clientLevel, livingEntity, seed) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.COPPER_HORN, (class_2960)WilderSharedConstants.vanillaId("tooting"), (itemStack, clientLevel, livingEntity, seed) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.SCORCHED_SAND, (class_2960)WilderSharedConstants.vanillaId("cracked"), (itemStack, clientLevel, livingEntity, seed) -> ItemBlockStateTagUtils.getBoolProperty((class_1799)itemStack, (class_2746)RegisterProperties.CRACKED, (boolean)false) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.SCORCHED_RED_SAND, (class_2960)WilderSharedConstants.vanillaId("cracked"), (itemStack, clientLevel, livingEntity, seed) -> ItemBlockStateTagUtils.getBoolProperty((class_1799)itemStack, (class_2746)RegisterProperties.CRACKED, (boolean)false) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.ECHO_GLASS, (class_2960)WilderSharedConstants.vanillaId("damage"), (itemStack, clientLevel, livingEntity, seed) -> (float)((Integer)ItemBlockStateTagUtils.getProperty((class_1799)itemStack, (class_2769)RegisterProperties.DAMAGE, (Comparable)Integer.valueOf(0))).intValue() / 4.0f);
        class_5272.method_27879((class_1792)class_1802.field_20415, (class_2960)WilderSharedConstants.vanillaId("honey"), (itemStack, clientLevel, livingEntity, seed) -> (float)((Integer)ItemBlockStateTagUtils.getProperty((class_1799)itemStack, (class_2769)class_2741.field_20432, (Comparable)Integer.valueOf(0))).intValue() / 5.0f);
        class_5272.method_27879((class_1792)class_1802.field_20416, (class_2960)WilderSharedConstants.vanillaId("honey"), (itemStack, clientLevel, livingEntity, seed) -> (float)((Integer)ItemBlockStateTagUtils.getProperty((class_1799)itemStack, (class_2769)class_2741.field_20432, (Comparable)Integer.valueOf(0))).intValue() / 5.0f);
        class_5272.method_27879((class_1792)class_1802.field_37538, (class_2960)WilderSharedConstants.vanillaId("souls_taken"), (itemStack, clientLevel, livingEntity, seed) -> (float)((Integer)ItemBlockStateTagUtils.getProperty((class_1799)itemStack, (class_2769)RegisterProperties.SOULS_TAKEN, (Comparable)Integer.valueOf(0))).intValue() / 2.0f);
        class_5272.method_27879((class_1792)RegisterItems.FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.CYAN_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.GRAY_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.GREEN_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.LIGHT_BLUE_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.LIME_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.MAGENTA_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.ORANGE_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.PINK_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.PURPLE_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.YELLOW_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.WHITE_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.BLACK_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.BLUE_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.RED_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.BROWN_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)RegisterItems.LIGHT_GRAY_FIREFLY_BOTTLE, (class_2960)WilderSharedConstants.vanillaId("nectar"), (itemStack, clientLevel, livingEntity, seed) -> FireflyBottle.isNectar(itemStack) ? 1.0f : 0.0f);
        ColorProviderRegistry.ITEM.register((state, tintIndex) -> 5877296, (Object[])new class_1935[]{RegisterBlocks.BAOBAB_LEAVES});
        ColorProviderRegistry.ITEM.register((state, tintIndex) -> 5877296, (Object[])new class_1935[]{RegisterBlocks.CYPRESS_LEAVES});
        ColorProviderRegistry.ITEM.register((state, tintIndex) -> 5877296, (Object[])new class_1935[]{RegisterBlocks.PALM_FRONDS});
        ColorProviderRegistry.BLOCK.register((state, level, pos, tintIndex) -> level == null || pos == null ? 7455580 : 2129968, (Object[])new class_2248[]{RegisterBlocks.FLOWERING_LILY_PAD});
        ColorProviderRegistry.BLOCK.register((state, level, pos, tintIndex) -> class_1163.method_4966((class_1920)Objects.requireNonNull(level), (class_2338)Objects.requireNonNull(pos)), (Object[])new class_2248[]{RegisterBlocks.BAOBAB_LEAVES});
        ColorProviderRegistry.BLOCK.register((state, level, pos, tintIndex) -> class_1163.method_4966((class_1920)Objects.requireNonNull(level), (class_2338)Objects.requireNonNull(pos)), (Object[])new class_2248[]{RegisterBlocks.CYPRESS_LEAVES});
        ColorProviderRegistry.BLOCK.register((state, level, pos, tintIndex) -> class_1163.method_4966((class_1920)Objects.requireNonNull(level), (class_2338)Objects.requireNonNull(pos)), (Object[])new class_2248[]{RegisterBlocks.PALM_FRONDS});
        ColorProviderRegistry.BLOCK.register((state, level, pos, tintIndex) -> class_1163.method_4966((class_1920)Objects.requireNonNull(level), (class_2338)Objects.requireNonNull(pos)), (Object[])new class_2248[]{RegisterBlocks.POTTED_GRASS});
        ColorProviderRegistry.BLOCK.register((state, level, pos, tintIndex) -> class_1163.method_4966((class_1920)Objects.requireNonNull(level), (class_2338)Objects.requireNonNull(pos)), (Object[])new class_2248[]{RegisterBlocks.BUSH});
        ColorProviderRegistry.BLOCK.register((state, level, pos, tintIndex) -> class_1163.method_4966((class_1920)Objects.requireNonNull(level), (class_2338)Objects.requireNonNull(pos)), (Object[])new class_2248[]{RegisterBlocks.POTTED_BUSH});
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return WilderSharedConstants.id("wilder_wild_client_resource_listener");
            }

            public void method_14491(@NotNull class_3300 resourceManager) {
                WilderSharedConstants.MC_LIVE_TENDRILS = resourceManager.method_14486(WilderSharedConstants.id("textures/entity/sculk_sensor/new_tendril_enabler.png")).isPresent();
            }
        });
    }
}

