/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.wilderwild.block.entity.DisplayLanternBlockEntity;
import net.frozenblock.wilderwild.entity.variant.FireflyColor;
import net.frozenblock.wilderwild.item.FireflyBottle;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.registry.RegisterBlockEntities;
import net.frozenblock.wilderwild.registry.RegisterItems;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_39;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5558;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayLanternBlock
extends class_2237
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 HANGING = class_2741.field_16561;
    public static final class_2758 DISPLAY_LIGHT = RegisterProperties.DISPLAY_LIGHT;
    protected static final class_265 STANDING_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (class_265)class_2248.method_9541((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0));
    protected static final class_265 HANGING_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), (class_265)class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public DisplayLanternBlock(@NotNull class_4970.class_2251 settings) {
        super(settings.method_50012(class_3619.field_15971));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(0)));
    }

    private static class_2350 attachedDirection(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)HANGING) != false ? class_2350.field_11033 : class_2350.field_11036;
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 entity = level.method_8321(pos);
        if (entity instanceof DisplayLanternBlockEntity) {
            Optional stack1;
            DisplayLanternBlockEntity lantern = (DisplayLanternBlockEntity)entity;
            class_1799 stack = player.method_5998(hand);
            if (lantern.invEmpty()) {
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof FireflyBottle) {
                    FireflyBottle bottle = (FireflyBottle)class_17922;
                    if (lantern.getFireflies().size() < 4) {
                        String name = "";
                        if (stack.method_7938()) {
                            name = stack.method_7964().getString();
                        }
                        lantern.addFirefly((class_1936)level, bottle, name);
                        if (!player.method_7337()) {
                            player.method_5998(hand).method_7934(1);
                        }
                        player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8469));
                        level.method_8501(pos, (class_2680)state.method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(class_3532.method_15340((int)(lantern.getFireflies().size() * 3), (int)0, (int)15))));
                        level.method_8396(null, pos, RegisterSounds.ITEM_BOTTLE_PUT_IN_LANTERN_FIREFLY, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f);
                        lantern.updateSync();
                        return class_1269.field_5812;
                    }
                }
                if (stack.method_31574(class_1802.field_8469) && !lantern.getFireflies().isEmpty()) {
                    DisplayLanternBlockEntity.FireflyInLantern fireflyInLantern = lantern.getFireflies().get(AdvancedMath.random().method_43048(lantern.getFireflies().size()));
                    Optional optionalItem = class_7923.field_41178.method_17966(new class_2960(fireflyInLantern.color.key().method_12836(), (String)(Objects.equals(fireflyInLantern.color, FireflyColor.ON) ? "firefly_bottle" : fireflyInLantern.color.key().method_12832() + "_firefly_bottle")));
                    FireflyBottle item = RegisterItems.FIREFLY_BOTTLE;
                    if (optionalItem.isPresent()) {
                        item = (class_1792)optionalItem.get();
                    }
                    level.method_8396(null, pos, RegisterSounds.ITEM_BOTTLE_CATCH_FIREFLY, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f);
                    if (!player.method_7337()) {
                        player.method_5998(hand).method_7934(1);
                    }
                    class_1799 bottleStack = new class_1799((class_1935)item);
                    if (!Objects.equals(fireflyInLantern.customName, "")) {
                        bottleStack.method_7977(class_2561.method_30163((String)fireflyInLantern.customName));
                    }
                    player.method_31548().method_7398(bottleStack);
                    ((DisplayLanternBlockEntity)entity).removeFirefly(fireflyInLantern);
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(class_3532.method_15340((int)(lantern.getFireflies().size() * 3), (int)0, (int)15))));
                    lantern.updateSync();
                    return class_1269.field_5812;
                }
                if (!stack.method_7960() && lantern.noFireflies()) {
                    int light = 0;
                    class_1792 class_17923 = stack.method_7909();
                    if (class_17923 instanceof class_1747) {
                        class_1747 blockItem = (class_1747)class_17923;
                        light = blockItem.method_7711().method_9564().method_26213();
                    } else if (stack.method_7942()) {
                        light = (int)Math.round((double)stack.method_7921().size() * 0.5);
                    }
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(class_3532.method_15340((int)light, (int)0, (int)15))));
                    lantern.inventory.set(0, (Object)stack.method_7971(1));
                    lantern.updateSync();
                    return class_1269.field_5812;
                }
            } else if (lantern.noFireflies() && (stack1 = lantern.inventory.stream().findFirst()).isPresent()) {
                DisplayLanternBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)((class_1799)stack1.get()));
                lantern.inventory.clear();
                lantern.updateSync();
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)DISPLAY_LIGHT, (Comparable)Integer.valueOf(0)));
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        for (class_2350 direction : ctx.method_7718()) {
            class_2680 blockState;
            if (direction.method_10166() != class_2350.class_2351.field_11052 || !(blockState = (class_2680)this.method_9564().method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(direction == class_2350.field_11036))).method_26184((class_4538)ctx.method_8045(), ctx.method_8037())) continue;
            return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return (Boolean)state.method_11654((class_2769)HANGING) != false ? HANGING_SHAPE : STANDING_SHAPE;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HANGING, WATERLOGGED, DISPLAY_LIGHT});
    }

    public boolean method_9558(@NotNull class_2680 state, @NotNull class_4538 level, @NotNull class_2338 pos) {
        class_2350 direction = DisplayLanternBlock.attachedDirection(state).method_10153();
        return class_2248.method_20044((class_4538)level, (class_2338)pos.method_10093(direction), (class_2350)direction.method_10153());
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 blockState) {
        return class_2464.field_11458;
    }

    @NotNull
    public class_2680 method_9559(@NotNull class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 level, @NotNull class_2338 currentPos, @NotNull class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (DisplayLanternBlock.attachedDirection(state).method_10153() == direction && !state.method_26184((class_4538)level, currentPos)) {
            class_2586 entity = level.method_8321(currentPos);
            if (entity instanceof DisplayLanternBlockEntity) {
                DisplayLanternBlockEntity lanternEntity = (DisplayLanternBlockEntity)entity;
                lanternEntity.spawnFireflies();
            }
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void method_9536(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
        Object object;
        if (!state.method_27852(newState.method_26204()) && (object = level.method_8321(pos)) instanceof DisplayLanternBlockEntity) {
            DisplayLanternBlockEntity lantern = (DisplayLanternBlockEntity)((Object)object);
            for (class_1799 item : lantern.inventory) {
                DisplayLanternBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)item);
            }
            lantern.inventory.clear();
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @NotNull
    public class_3610 method_9545(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9516(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_10 type) {
        return false;
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new DisplayLanternBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return !level.field_9236 ? DisplayLanternBlock.method_31618(type, RegisterBlockEntities.DISPLAY_LANTERN, (worldx, pos, statex, blockEntity) -> blockEntity.serverTick(level, pos)) : DisplayLanternBlock.method_31618(type, RegisterBlockEntities.DISPLAY_LANTERN, (worldx, pos, statex, blockEntity) -> blockEntity.clientTick(level, pos));
    }

    public void method_9556(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_2586 blockEntity, @NotNull class_1799 stack) {
        if (!level.field_9236 && blockEntity instanceof DisplayLanternBlockEntity) {
            boolean silk;
            DisplayLanternBlockEntity lanternEntity = (DisplayLanternBlockEntity)blockEntity;
            boolean bl = silk = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) == 0 || player.method_7337();
            if (silk && !lanternEntity.getFireflies().isEmpty()) {
                lanternEntity.spawnFireflies(level);
            }
        }
        super.method_9556(level, player, pos, state, blockEntity, stack);
    }

    @NotNull
    public List<class_1799> method_9560(@NotNull class_2680 blockState, @NotNull class_8567.class_8568 builder) {
        DisplayLanternBlockEntity lantern;
        class_2586 blockEntity;
        class_1799 stack;
        class_2960 resourceLocation = this.method_26162();
        if (builder.method_51876(class_181.field_1229) != null && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)(stack = (class_1799)builder.method_51873(class_181.field_1229))) != 0 && builder.method_51876(class_181.field_1228) != null && (blockEntity = (class_2586)builder.method_51873(class_181.field_1228)) instanceof DisplayLanternBlockEntity && !(lantern = (DisplayLanternBlockEntity)blockEntity).getFireflies().isEmpty()) {
            resourceLocation = WilderSharedConstants.id("blocks/display_lantern_fireflies");
        }
        if (resourceLocation == class_39.field_844) {
            return Collections.emptyList();
        }
        class_8567 lootParams = builder.method_51874(class_181.field_1224, (Object)blockState).method_51875(class_173.field_1172);
        class_3218 serverLevel = lootParams.method_51863();
        class_52 lootTable = serverLevel.method_8503().method_3857().getLootTable(resourceLocation);
        return lootTable.method_51878(lootParams);
    }
}

