/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import java.util.Optional;
import net.frozenblock.lib.block.api.shape.FrozenShapes;
import net.frozenblock.wilderwild.config.BlockConfig;
import net.frozenblock.wilderwild.misc.BubbleDirection;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.frozenblock.wilderwild.tag.WilderEntityTags;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1690;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2258;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MesogleaBlock
extends class_2373
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<BubbleDirection> BUBBLE_DIRECTION = RegisterProperties.BUBBLE_DIRECTION;
    public final class_2394 dripParticle;
    public final boolean pearlescent;

    public MesogleaBlock(@NotNull class_4970.class_2251 properties, @NotNull class_2394 dripParticle, boolean pearlescent) {
        super(properties.method_50012(class_3619.field_15971));
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.NONE)));
        this.dripParticle = dripParticle;
        this.pearlescent = pearlescent;
    }

    public void method_9548(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity) {
        Optional<class_2350> dragDirection = MesogleaBlock.getDragDirection(state);
        if (this.pearlescent && ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && (dragDirection.isEmpty() || !BlockConfig.get().mesoglea.mesogleaBubbleColumns)) {
            if (entity instanceof class_1542) {
                class_1542 item = (class_1542)entity;
                item.method_5844(state, new class_243(0.999, 0.999, 0.999));
                item.method_18799(item.method_18798().method_1031(0.0, 0.025, 0.0));
            }
            if (entity instanceof class_1690) {
                class_1690 boat = (class_1690)entity;
                class_243 deltaMovement = boat.method_18798();
                if (boat.method_5869() && deltaMovement.field_1351 < 0.175) {
                    boat.method_18800(deltaMovement.field_1352, Math.min(0.175, deltaMovement.field_1351 + 0.05), deltaMovement.field_1350);
                } else if (deltaMovement.field_1351 < 0.0) {
                    boat.method_18800(deltaMovement.field_1352, deltaMovement.field_1351 * 0.125, deltaMovement.field_1350);
                }
            }
        }
        if (dragDirection.isPresent() && BlockConfig.get().mesoglea.mesogleaBubbleColumns) {
            class_2680 blockState = level.method_8320(pos.method_10084());
            if (blockState.method_26215()) {
                entity.method_5700(dragDirection.get() == class_2350.field_11033);
                if (!level.field_9236) {
                    class_3218 serverLevel = (class_3218)level;
                    for (int i = 0; i < 2; ++i) {
                        serverLevel.method_14199((class_2394)class_2398.field_11202, (double)pos.method_10263() + level.field_9229.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + level.field_9229.method_43058(), 1, 0.0, 0.0, 0.0, 1.0);
                        serverLevel.method_14199((class_2394)class_2398.field_11247, (double)pos.method_10263() + level.field_9229.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + level.field_9229.method_43058(), 1, 0.0, 0.01, 0.0, 0.2);
                    }
                }
            } else {
                entity.method_5764(dragDirection.get() == class_2350.field_11033);
            }
        }
    }

    public static boolean isMesoglea(@NotNull class_2680 blockState) {
        return blockState.method_28498(BUBBLE_DIRECTION) && blockState.method_26204() instanceof MesogleaBlock;
    }

    public static boolean isColumnSupportingMesoglea(class_2680 blockState) {
        return MesogleaBlock.isMesoglea(blockState) && (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false && BlockConfig.get().mesoglea.mesogleaBubbleColumns;
    }

    public static boolean hasBubbleColumn(class_2680 blockState) {
        return MesogleaBlock.isColumnSupportingMesoglea(blockState) && blockState.method_11654(BUBBLE_DIRECTION) != BubbleDirection.NONE;
    }

    public static boolean isDraggingDown(class_2680 blockState) {
        return MesogleaBlock.isColumnSupportingMesoglea(blockState) && blockState.method_11654(BUBBLE_DIRECTION) == BubbleDirection.DOWN;
    }

    public static Optional<class_2350> getDragDirection(class_2680 blockState) {
        return MesogleaBlock.isColumnSupportingMesoglea(blockState) ? ((BubbleDirection)((Object)blockState.method_11654(MesogleaBlock.BUBBLE_DIRECTION))).direction : Optional.empty();
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_3726 collisionContext) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            class_3727 entityCollisionContext;
            class_265 shape = class_259.method_1073();
            if (collisionContext instanceof class_3727 && (entityCollisionContext = (class_3727)collisionContext).method_32480() != null) {
                class_1297 entity = entityCollisionContext.method_32480();
                if (entity != null && entity.method_5864().method_20210(WilderEntityTags.STAYS_IN_MESOGLEA) && !entity.method_5765() && !entity.method_21752()) {
                    class_1308 mob;
                    if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5934()) {
                        return shape;
                    }
                    class_2680 insideState = entity.method_36601();
                    if (entity.method_5799() || insideState.method_26204() instanceof MesogleaBlock && ((Boolean)insideState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                        for (class_2350 direction : class_2350.values()) {
                            if (direction == class_2350.field_11036 || blockGetter.method_8316(blockPos.method_10093(direction)).method_15767(class_3486.field_15517)) continue;
                            shape = class_259.method_1084((class_265)shape, (class_265)FrozenShapes.makePlaneFromDirection((class_2350)direction, (float)0.25f));
                        }
                    }
                }
                return shape;
            }
            for (class_2350 direction : class_2350.values()) {
                if (direction == class_2350.field_11036 || blockGetter.method_8316(blockPos.method_10093(direction)).method_15767(class_3486.field_15517)) continue;
                shape = class_259.method_1084((class_265)shape, (class_265)FrozenShapes.makePlaneFromDirection((class_2350)direction, (float)0.05f));
            }
            return shape;
        }
        return super.method_9549(blockState, blockGetter, blockPos, collisionContext);
    }

    public void method_9496(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_5819 randomSource) {
        Optional<class_2350> dragDirection;
        super.method_9496(blockState, level, blockPos, randomSource);
        double d = blockPos.method_10263();
        double e = blockPos.method_10264();
        double f = blockPos.method_10260();
        if (randomSource.method_43051(0, 50) == 0 && (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue() || level.method_8316(blockPos.method_10084()).method_15767(class_3486.field_15517)) && level.method_8316(blockPos.method_10074()).method_15769() && level.method_8320(blockPos.method_10074()).method_26215()) {
            level.method_8406(this.dripParticle, d + randomSource.method_43058(), e, f + randomSource.method_43058(), 0.0, 0.0, 0.0);
        }
        if ((dragDirection = MesogleaBlock.getDragDirection(blockState)).isPresent()) {
            if (dragDirection.get() == class_2350.field_11033) {
                level.method_8494((class_2394)class_2398.field_11243, d + 0.5, e + 0.8, f, 0.0, 0.0, 0.0);
                if (randomSource.method_43048(200) == 0) {
                    level.method_8486(d, e, f, class_3417.field_14650, class_3419.field_15245, 0.2f + randomSource.method_43057() * 0.2f, 0.9f + randomSource.method_43057() * 0.15f, false);
                }
            } else if (dragDirection.get() == class_2350.field_11036) {
                level.method_8494((class_2394)class_2398.field_11238, d + 0.5, e, f + 0.5, 0.0, 0.04, 0.0);
                level.method_8494((class_2394)class_2398.field_11238, d + (double)randomSource.method_43057(), e + (double)randomSource.method_43057(), f + (double)randomSource.method_43057(), 0.0, 0.04, 0.0);
                if (randomSource.method_43048(200) == 0) {
                    level.method_8486(d, e, f, class_3417.field_15161, class_3419.field_15245, 0.2f + randomSource.method_43057() * 0.2f, 0.9f + randomSource.method_43057() * 0.15f, false);
                }
            }
        }
    }

    public int method_9505(@NotNull class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? 2 : 5;
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 blockPlaceContext) {
        class_3610 fluidState = blockPlaceContext.method_8045().method_8316(blockPlaceContext.method_8037());
        class_2680 blockState = blockPlaceContext.method_8045().method_8320(blockPlaceContext.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910))).method_11657(BUBBLE_DIRECTION, (Comparable)((Object)(blockState.method_27852(class_2246.field_10422) && BlockConfig.get().mesoglea.mesogleaBubbleColumns ? (((Boolean)blockState.method_11654((class_2769)class_2741.field_12526)).booleanValue() ? BubbleDirection.DOWN : BubbleDirection.UP) : BubbleDirection.NONE)));
    }

    @NotNull
    public class_2680 method_9559(@NotNull class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
            if (BlockConfig.get().mesoglea.mesogleaBubbleColumns) {
                if (MesogleaBlock.hasBubbleColumn(state) && (!MesogleaBlock.canColumnSurvive((class_4538)level, pos) || direction == class_2350.field_11033 || direction == class_2350.field_11036 && !MesogleaBlock.hasBubbleColumn(neighborState) && MesogleaBlock.canExistIn(neighborState))) {
                    level.method_39279(pos, (class_2248)this, 5);
                }
                if (direction == class_2350.field_11033 && neighborState.method_27852(class_2246.field_10422)) {
                    level.method_39279(pos, (class_2248)this, 5);
                }
            }
        } else {
            state = (class_2680)state.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.NONE));
            level.method_8652(pos, state, 2);
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public void method_9612(class_2680 state, @NotNull class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        if (BlockConfig.get().mesoglea.mesogleaBubbleColumns) {
            level.method_39279(pos, (class_2248)this, 5);
        }
    }

    public static boolean canColumnSurvive(@NotNull class_4538 level, @NotNull class_2338 pos) {
        class_2680 blockState = level.method_8320(pos.method_10074());
        return BlockConfig.get().mesoglea.mesogleaBubbleColumns && (blockState.method_27852(class_2246.field_10422) || blockState.method_27852(class_2246.field_10092) || blockState.method_27852(class_2246.field_10114) || MesogleaBlock.hasBubbleColumn(blockState));
    }

    public void method_9588(class_2680 state, class_3218 level, @NotNull class_2338 pos, class_5819 random) {
        if (BlockConfig.get().mesoglea.mesogleaBubbleColumns) {
            MesogleaBlock.updateColumn((class_1936)level, pos, state, level.method_8320(pos.method_10074()));
            class_2258.method_34268((class_1936)level, (class_2338)pos.method_10084(), (class_2680)state);
        }
    }

    @NotNull
    public class_3610 method_9545(@NotNull class_2680 blockState) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(blockState);
    }

    public static void updateColumn(class_1936 level, class_2338 pos, class_2680 state) {
        MesogleaBlock.updateColumn(level, pos, level.method_8320(pos), state);
    }

    public static void updateColumn(class_1936 level, class_2338 pos, class_2680 mesoglea, class_2680 state) {
        if (MesogleaBlock.canExistIn(mesoglea)) {
            class_2680 mutableState;
            level.method_8652(pos, MesogleaBlock.getColumnState(mesoglea, state), 2);
            class_2338.class_2339 mutableBlockPos = pos.method_25503().method_10098(class_2350.field_11036);
            while (MesogleaBlock.canExistIn(mutableState = level.method_8320((class_2338)mutableBlockPos))) {
                if (!level.method_8652((class_2338)mutableBlockPos, MesogleaBlock.getColumnState(mutableState, state), 2)) {
                    return;
                }
                mutableBlockPos.method_10098(class_2350.field_11036);
            }
            class_2258.method_34268((class_1936)level, (class_2338)mutableBlockPos, (class_2680)state);
            return;
        }
    }

    @NotNull
    private static class_2680 getColumnState(@NotNull class_2680 mesogleaState, @NotNull class_2680 blockState) {
        if (BlockConfig.get().mesoglea.mesogleaBubbleColumns && ((Boolean)mesogleaState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            if (blockState.method_27852(class_2246.field_10422)) {
                return (class_2680)mesogleaState.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)((Boolean)blockState.method_11654((class_2769)class_2741.field_12526) != false ? BubbleDirection.DOWN : BubbleDirection.UP)));
            }
            if (blockState.method_27852(class_2246.field_10114)) {
                return (class_2680)mesogleaState.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.UP));
            }
            if (blockState.method_27852(class_2246.field_10092)) {
                return (class_2680)mesogleaState.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.DOWN));
            }
        }
        return (class_2680)mesogleaState.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.NONE));
    }

    private static boolean canExistIn(class_2680 blockState) {
        return MesogleaBlock.isColumnSupportingMesoglea(blockState) && blockState.method_26227().method_15761() >= 8 && blockState.method_26227().method_15771();
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, BUBBLE_DIRECTION});
    }

    public boolean method_9522(@NotNull class_2680 blockState, @NotNull class_2680 blockState2, @NotNull class_2350 direction) {
        boolean isThisWaterlogged = (Boolean)blockState.method_11654((class_2769)WATERLOGGED);
        return blockState2.method_27852((class_2248)this) && (isThisWaterlogged == (Boolean)blockState2.method_11654((class_2769)WATERLOGGED) || isThisWaterlogged);
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false && BlockConfig.get().mesoglea.mesogleaLiquid ? class_2464.field_11455 : class_2464.field_11458;
    }
}

