/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.frozenblock.wilderwild.block.entity.StoneChestBlockEntity;
import net.frozenblock.wilderwild.entity.Jellyfish;
import net.frozenblock.wilderwild.misc.interfaces.ChestBlockEntityInterface;
import net.frozenblock.wilderwild.registry.RegisterBlockEntities;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneChestBlock
extends class_2281 {
    public static final class_2746 ANCIENT = RegisterProperties.ANCIENT;
    public static final class_2746 SCULK = RegisterProperties.HAS_SCULK;
    public static final class_4732.class_3923<class_2595, Optional<class_3908>> STONE_NAME_RETRIEVER = new class_4732.class_3923<class_2595, Optional<class_3908>>(){

        @NotNull
        public Optional<class_3908> acceptDouble(final @NotNull class_2595 chestBlockEntity, final @NotNull class_2595 chestBlockEntity2) {
            final class_1258 inventory = new class_1258((class_1263)chestBlockEntity, (class_1263)chestBlockEntity2);
            return Optional.of(new class_3908(){

                @Nullable
                public class_1703 createMenu(int i, @NotNull class_1661 playerInventory, @NotNull class_1657 playerEntity) {
                    if (chestBlockEntity.method_17489(playerEntity) && chestBlockEntity2.method_17489(playerEntity)) {
                        chestBlockEntity.method_11289(playerInventory.field_7546);
                        chestBlockEntity2.method_11289(playerInventory.field_7546);
                        return class_1707.method_19247((int)i, (class_1661)playerInventory, (class_1263)inventory);
                    }
                    return null;
                }

                @NotNull
                public class_2561 method_5476() {
                    if (chestBlockEntity.method_16914()) {
                        return chestBlockEntity.method_5476();
                    }
                    if (chestBlockEntity2.method_16914()) {
                        return chestBlockEntity2.method_5476();
                    }
                    return class_2561.method_43471((String)"container.double_stone_chest");
                }
            });
        }

        @NotNull
        public Optional<class_3908> acceptSingle(@NotNull class_2595 chestBlockEntity) {
            return Optional.of(chestBlockEntity);
        }

        @NotNull
        public Optional<class_3908> acceptNone() {
            return Optional.empty();
        }
    };

    public StoneChestBlock(@NotNull class_4970.class_2251 settings, @NotNull Supplier<class_2591<? extends class_2595>> supplier) {
        super(settings, supplier);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ANCIENT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SCULK, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean hasLid(@NotNull class_1937 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)class_25862;
            return stoneChest.openProgress < 0.3f;
        }
        return false;
    }

    public static boolean canInteract(@NotNull class_1936 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)class_25862;
            return !stoneChest.closing && stoneChest.cooldownTicks <= 0;
        }
        return true;
    }

    public static boolean hasLid(@NotNull class_1936 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)class_25862;
            return stoneChest.openProgress < 0.3f;
        }
        return false;
    }

    public static boolean isStoneChestBlocked(@NotNull class_1936 level, @NotNull class_2338 pos) {
        if (StoneChestBlock.hasLid(level, pos)) {
            return true;
        }
        return class_2281.method_9756((class_1936)level, (class_2338)pos) || !StoneChestBlock.canInteract(level, pos);
    }

    public static boolean isStoneChestBlockedNoLid(@NotNull class_1936 level, @NotNull class_2338 pos) {
        return class_2281.method_9756((class_1936)level, (class_2338)pos) || !StoneChestBlock.canInteract(level, pos);
    }

    public static void spawnBreakParticles(@NotNull class_1937 level, @NotNull class_1799 stack, @NotNull class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            server.method_14199((class_2394)new class_2392(class_2398.field_11218, stack), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.3, (double)pos.method_10260() + 0.5, level.field_9229.method_39332(1, 3), 0.21875, 0.21875, 0.21875, 0.05);
        }
    }

    @Nullable
    public static StoneChestBlockEntity getOtherChest(@NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
        if (chestType == class_2745.field_12571) {
            mutableBlockPos.method_10098(class_2281.method_9758((class_2680)state));
        } else if (chestType == class_2745.field_12574) {
            mutableBlockPos.method_10098(class_2281.method_9758((class_2680)state));
        } else {
            return null;
        }
        class_2586 class_25862 = level.method_8321((class_2338)mutableBlockPos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity chest = (StoneChestBlockEntity)class_25862;
            return chest;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        StoneChestBlockEntity otherChest;
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof StoneChestBlockEntity)) return class_1269.field_21466;
        StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)class_25862;
        if (stoneChest.closing) {
            return class_1269.field_5814;
        }
        boolean ancient = (Boolean)state.method_11654((class_2769)ANCIENT);
        if (StoneChestBlock.canInteract((class_1936)level, pos)) {
            class_3908 namedScreenHandlerFactory = this.method_17454(state, level, pos);
            if (!(StoneChestBlock.hasLid(level, pos) || player.method_5715() && !(stoneChest.openProgress >= 0.5f) || namedScreenHandlerFactory == null)) {
                player.method_17355(namedScreenHandlerFactory);
                player.method_7259(this.method_9755());
                class_4838.method_24733((class_1657)player, (boolean)true);
            } else if (stoneChest.openProgress < 0.5f) {
                boolean first;
                class_3908 lidCheck = ((Optional)this.getBlockEntitySourceIgnoreLid(state, level, pos, false).apply(STONE_NAME_RETRIEVER)).orElse(null);
                boolean bl = first = stoneChest.openProgress == 0.0f;
                if (lidCheck == null) {
                    if (!(stoneChest.openProgress < 0.05f)) return class_1269.field_5811;
                    stoneChest.setLid(!ancient ? stoneChest.openProgress + 0.025f : 0.05f);
                } else {
                    stoneChest.liftLid(0.025f, ancient);
                }
                if (first) {
                    ((ChestBlockEntityInterface)((Object)stoneChest)).wilderWild$bubble(level, pos, state);
                    class_2960 lootTable = stoneChest.field_12037;
                    if (lootTable != null && state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && lootTable.method_12832().toLowerCase().contains("shipwreck")) {
                        Jellyfish.spawnFromChest(level, state, pos);
                    }
                }
                StoneChestBlockEntity.playSound(level, pos, state, first ? RegisterSounds.BLOCK_STONE_CHEST_OPEN : RegisterSounds.BLOCK_STONE_CHEST_LIFT, first ? RegisterSounds.BLOCK_STONE_CHEST_OPEN_UNDERWATER : RegisterSounds.BLOCK_STONE_CHEST_LIFT_UNDERWATER, 0.35f);
                level.method_33596((class_1297)player, class_5712.field_28176, pos);
                stoneChest.updateSync();
            }
        }
        if ((otherChest = StoneChestBlock.getOtherChest((class_1936)level, pos, state)) == null) return class_1269.field_21466;
        ((ChestBlockEntityInterface)((Object)stoneChest)).wilderWild$syncBubble(stoneChest, otherChest);
        stoneChest.syncLidValuesWith(otherChest);
        return class_1269.field_21466;
    }

    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new StoneChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return level.field_9236 ? class_2237.method_31618(type, RegisterBlockEntities.STONE_CHEST, StoneChestBlockEntity::clientStoneTick) : class_2237.method_31618(type, RegisterBlockEntities.STONE_CHEST, StoneChestBlockEntity::serverStoneTick);
    }

    @Nullable
    public class_3908 method_17454(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos) {
        return ((Optional)this.method_24167(state, level, pos, false).apply(STONE_NAME_RETRIEVER)).orElse(null);
    }

    @NotNull
    public class_4732.class_4734<? extends class_2595> method_24167(@NotNull class_2680 state, @NotNull class_1937 level2, @NotNull class_2338 pos2, boolean ignoreBlocked) {
        BiPredicate<class_1936, class_2338> biPredicate = ignoreBlocked ? (level, pos) -> false : StoneChestBlock::isStoneChestBlocked;
        return class_4732.method_24173((class_2591)((class_2591)this.field_21796.get()), class_2281::method_24169, class_2281::method_9758, (class_2753)field_10768, (class_2680)state, (class_1936)level2, (class_2338)pos2, biPredicate);
    }

    @NotNull
    public class_4732.class_4734<? extends class_2595> getBlockEntitySourceIgnoreLid(class_2680 state, class_1937 level2, class_2338 pos2, boolean ignoreBlocked) {
        BiPredicate<class_1936, class_2338> biPredicate = ignoreBlocked ? (level, pos) -> false : StoneChestBlock::isStoneChestBlockedNoLid;
        return class_4732.method_24173((class_2591)((class_2591)this.field_21796.get()), class_2281::method_24169, class_2281::method_9758, (class_2753)field_10768, (class_2680)state, (class_1936)level2, (class_2338)pos2, biPredicate);
    }

    @NotNull
    public class_2680 method_9559(@NotNull class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 level, @NotNull class_2338 currentPos, @NotNull class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)field_10772)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (neighborState.method_27852((class_2248)this) && direction.method_10166().method_10179()) {
            class_2745 chestType = (class_2745)neighborState.method_11654((class_2769)field_10770);
            if (state.method_11654((class_2769)field_10770) == class_2745.field_12569 && chestType != class_2745.field_12569 && state.method_11654((class_2769)field_10768) == neighborState.method_11654((class_2769)field_10768) && state.method_11654((class_2769)ANCIENT) == neighborState.method_11654((class_2769)ANCIENT) && class_2281.method_9758((class_2680)neighborState) == direction.method_10153()) {
                class_2680 retState = (class_2680)state.method_11657((class_2769)field_10770, (Comparable)chestType.method_11824());
                this.updateBubbles(state, retState, level, currentPos);
                return retState;
            }
        } else if (class_2281.method_9758((class_2680)state) == direction) {
            class_2680 retState = (class_2680)state.method_11657((class_2769)field_10770, (Comparable)class_2745.field_12569);
            this.updateBubbles(state, retState, level, currentPos);
            return retState;
        }
        class_2680 retState = super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
        this.updateBubbles(state, retState, level, currentPos);
        return retState;
    }

    public void updateBubbles(@NotNull class_2680 oldState, @NotNull class_2680 state, @NotNull class_1936 level, @NotNull class_2338 currentPos) {
        class_2586 class_25862 = level.method_8321(currentPos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity chest = (StoneChestBlockEntity)class_25862;
            StoneChestBlockEntity otherChest = StoneChestBlock.getOtherChest(level, currentPos, state);
            if (otherChest != null) {
                class_2680 otherState = level.method_8320(otherChest.method_11016());
                boolean wasLogged = (Boolean)oldState.method_11654((class_2769)class_2741.field_12508);
                if (wasLogged != (Boolean)state.method_11654((class_2769)class_2741.field_12508) && wasLogged) {
                    if (!((Boolean)otherState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                        ((ChestBlockEntityInterface)((Object)chest)).wilderWild$setCanBubble(true);
                        ((ChestBlockEntityInterface)((Object)otherChest)).wilderWild$setCanBubble(true);
                    } else if (!((ChestBlockEntityInterface)((Object)otherChest)).wilderWild$getCanBubble()) {
                        ((ChestBlockEntityInterface)((Object)chest)).wilderWild$setCanBubble(false);
                        ((ChestBlockEntityInterface)((Object)otherChest)).wilderWild$setCanBubble(false);
                    }
                }
            } else {
                boolean wasLogged = (Boolean)oldState.method_11654((class_2769)class_2741.field_12508);
                if (wasLogged != (Boolean)state.method_11654((class_2769)class_2741.field_12508) && wasLogged) {
                    ((ChestBlockEntityInterface)((Object)chest)).wilderWild$setCanBubble(true);
                }
            }
            if (otherChest != null) {
                ((ChestBlockEntityInterface)((Object)chest)).wilderWild$syncBubble(chest, otherChest);
            }
        }
    }

    public class_2680 method_9605(@NotNull class_1750 ctx) {
        class_2586 class_25862;
        class_2680 retState;
        StoneChestBlockEntity otherChest;
        class_2350 direction3;
        class_2745 chestType = class_2745.field_12569;
        class_1937 level = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2350 direction = ctx.method_8042().method_10153();
        class_3610 fluidState = ctx.method_8045().method_8316(pos);
        boolean bl = ctx.method_8046();
        class_2350 direction2 = ctx.method_8038();
        if (direction2.method_10166().method_10179() && bl && (direction3 = this.candidatePartnerFacing(ctx, direction2.method_10153())) != null && direction3.method_10166() != direction2.method_10166()) {
            direction = direction3;
            class_2745 class_27452 = chestType = direction.method_10160() == direction2.method_10153() ? class_2745.field_12571 : class_2745.field_12574;
        }
        if (chestType == class_2745.field_12569 && !bl) {
            if (direction == this.candidatePartnerFacing(ctx, direction.method_10170())) {
                chestType = class_2745.field_12574;
            } else if (direction == this.candidatePartnerFacing(ctx, direction.method_10160())) {
                chestType = class_2745.field_12571;
            }
        }
        if ((otherChest = StoneChestBlock.getOtherChest((class_1936)level, pos, retState = (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_10768, (Comparable)direction)).method_11657((class_2769)field_10770, (Comparable)chestType)).method_11657((class_2769)field_10772, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910)))) != null && (class_25862 = level.method_8321(pos)) instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity chest = (StoneChestBlockEntity)class_25862;
            ((ChestBlockEntityInterface)((Object)chest)).wilderWild$setCanBubble(((ChestBlockEntityInterface)((Object)otherChest)).wilderWild$getCanBubble());
            ((ChestBlockEntityInterface)((Object)chest)).wilderWild$syncBubble(chest, otherChest);
        }
        return retState;
    }

    @Nullable
    private class_2350 candidatePartnerFacing(@NotNull class_1750 ctx, @NotNull class_2350 dir) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(dir));
        return blockState.method_27852((class_2248)this) && (Boolean)blockState.method_11654((class_2769)ANCIENT) == false && blockState.method_11654((class_2769)field_10770) == class_2745.field_12569 ? (class_2350)blockState.method_11654((class_2769)field_10768) : null;
    }

    public void method_9536(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean moved) {
        class_2586 blockEntity;
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        if (!level.field_9236 && (blockEntity = level.method_8321(pos)) instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChestBlock = (StoneChestBlockEntity)blockEntity;
            ((ChestBlockEntityInterface)((Object)stoneChestBlock)).wilderWild$bubbleBurst(state);
            stoneChestBlock.method_11289(null);
            ArrayList<class_1799> ancientItems = stoneChestBlock.ancientItems();
            if (!ancientItems.isEmpty()) {
                level.method_8396(null, pos, RegisterSounds.BLOCK_STONE_CHEST_ITEM_CRUMBLE, class_3419.field_15245, 0.4f, 0.9f + level.field_9229.method_43057() / 10.0f);
                for (class_1799 taunt : ancientItems) {
                    for (int taunts = 0; taunts < taunt.method_7947(); ++taunts) {
                        StoneChestBlock.spawnBreakParticles(level, taunt, pos);
                    }
                }
            }
            for (class_1799 item : stoneChestBlock.nonAncientItems()) {
                double d = class_1299.field_6052.method_17685();
                double e = 1.0 - d;
                double f = d / 2.0;
                double g = (double)pos.method_10263() + level.field_9229.method_43058() * e + f;
                double h = (double)pos.method_10264() + level.field_9229.method_43058() * e;
                double i = (double)pos.method_10260() + level.field_9229.method_43058() * e + f;
                while (!item.method_7960()) {
                    class_1542 itemEntity = new class_1542(level, g, h, i, item.method_7971(level.field_9229.method_43048(21) + 10));
                    itemEntity.method_18800(level.field_9229.method_43385(0.0, 0.11485000171139836), level.field_9229.method_43385(0.2, 0.11485000171139836), level.field_9229.method_43385(0.0, 0.11485000171139836));
                    level.method_8649((class_1297)itemEntity);
                }
            }
            level.method_8455(pos, (class_2248)this);
        }
        if (state.method_31709() && !state.method_27852(newState.method_26204())) {
            level.method_8544(pos);
        }
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_10768, field_10770, field_10772, ANCIENT, SCULK});
    }
}

