/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import net.frozenblock.wilderwild.block.entity.TermiteMoundBlockEntity;
import net.frozenblock.wilderwild.entity.ai.TermiteManager;
import net.frozenblock.wilderwild.registry.RegisterBlockEntities;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TermiteMound
extends class_2237 {
    public TermiteMound(@NotNull class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)RegisterProperties.NATURAL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RegisterProperties.TERMITES_AWAKE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RegisterProperties.CAN_SPAWN_TERMITE, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canTermitesWaken(@NotNull class_1937 level, @NotNull class_2338 pos) {
        return !TermiteMound.shouldTermitesSleep(level, TermiteMound.getLightLevel(level, pos));
    }

    public static boolean shouldTermitesSleep(@NotNull class_1937 level, int light) {
        return level.method_23886() && light < 7;
    }

    public static int getLightLevel(@NotNull class_1937 level, @NotNull class_2338 blockPos) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        int finalLight = 0;
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_10098(direction);
            int newLight = !level.method_8419() ? level.method_22339((class_2338)mutableBlockPos) : level.method_8314(class_1944.field_9282, (class_2338)mutableBlockPos);
            finalLight = Math.max(finalLight, newLight);
            mutableBlockPos.method_10104(direction, -1);
        }
        return finalLight;
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new TermiteMoundBlockEntity(pos, state);
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{RegisterProperties.NATURAL, RegisterProperties.TERMITES_AWAKE, RegisterProperties.CAN_SPAWN_TERMITE});
    }

    @NotNull
    public class_2680 method_9559(@NotNull class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 level, @NotNull class_2338 currentPos, @NotNull class_2338 neighborPos) {
        boolean isSafe = TermiteManager.isPosSafeForTermites(level, neighborPos, neighborState);
        if (isSafe != (Boolean)state.method_11654((class_2769)RegisterProperties.TERMITES_AWAKE)) {
            state.method_11657((class_2769)RegisterProperties.TERMITES_AWAKE, (Comparable)Boolean.valueOf(isSafe));
        }
        if (isSafe != (Boolean)state.method_11654((class_2769)RegisterProperties.CAN_SPAWN_TERMITE)) {
            state.method_11657((class_2769)RegisterProperties.CAN_SPAWN_TERMITE, (Comparable)Boolean.valueOf(isSafe));
        }
        return state;
    }

    public void method_9615(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 oldState, boolean isMoving) {
        level.method_39279(pos, (class_2248)this, level.field_9229.method_43051(40, 200));
    }

    public void method_9536(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
        class_2586 class_25862;
        if (!state.method_27852(newState.method_26204()) && (class_25862 = level.method_8321(pos)) instanceof TermiteMoundBlockEntity) {
            TermiteMoundBlockEntity termiteMoundBlockEntity = (TermiteMoundBlockEntity)class_25862;
            termiteMoundBlockEntity.termiteManager.clearTermites(level);
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        boolean canAwaken;
        boolean areTermitesSafe = TermiteManager.areTermitesSafe((class_1937)level, pos);
        boolean bl = canAwaken = TermiteMound.canTermitesWaken((class_1937)level, pos) && areTermitesSafe;
        if (canAwaken != (Boolean)state.method_11654((class_2769)RegisterProperties.TERMITES_AWAKE)) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)RegisterProperties.TERMITES_AWAKE, (Comparable)Boolean.valueOf(canAwaken)), 3);
        }
        if (areTermitesSafe != (Boolean)state.method_11654((class_2769)RegisterProperties.CAN_SPAWN_TERMITE)) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)RegisterProperties.CAN_SPAWN_TERMITE, (Comparable)Boolean.valueOf(areTermitesSafe)), 3);
        }
        level.method_39279(pos, (class_2248)this, random.method_43051(90, 150));
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 blockState) {
        return class_2464.field_11458;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return !level.field_9236 ? TermiteMound.method_31618(type, RegisterBlockEntities.TERMITE_MOUND, (worldx, pos, statex, blockEntity) -> blockEntity.tickServer(worldx, pos, (Boolean)statex.method_11654((class_2769)RegisterProperties.NATURAL), (Boolean)statex.method_11654((class_2769)RegisterProperties.TERMITES_AWAKE), (Boolean)statex.method_11654((class_2769)RegisterProperties.CAN_SPAWN_TERMITE))) : TermiteMound.method_31618(type, RegisterBlockEntities.TERMITE_MOUND, (worldx, pos, statex, blockEntity) -> blockEntity.tickClient());
    }
}

