/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.frozenblock.wilderwild.entity.Firefly;
import net.frozenblock.wilderwild.entity.ai.firefly.FireflyAi;
import net.frozenblock.wilderwild.entity.variant.FireflyColor;
import net.frozenblock.wilderwild.item.FireflyBottle;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.registry.RegisterBlockEntities;
import net.frozenblock.wilderwild.registry.RegisterEntities;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class DisplayLanternBlockEntity
extends class_2586 {
    private final ArrayList<FireflyInLantern> fireflies = new ArrayList();
    public class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    public int age;
    public boolean clientHanging;

    public DisplayLanternBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 blockState) {
        super(RegisterBlockEntities.DISPLAY_LANTERN, pos, blockState);
    }

    public void serverTick(@NotNull class_1937 level, @NotNull class_2338 pos) {
        if (!this.fireflies.isEmpty()) {
            for (FireflyInLantern firefly : this.fireflies) {
                firefly.tick(level, pos);
            }
        }
    }

    public void clientTick(@NotNull class_1937 level, @NotNull class_2338 pos) {
        ++this.age;
        this.clientHanging = (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_16561);
        if (!this.fireflies.isEmpty()) {
            for (FireflyInLantern firefly : this.fireflies) {
                firefly.tick(level, pos);
            }
        }
    }

    public void updateSync() {
        class_2622 updatePacket = this.getUpdatePacket();
        if (updatePacket != null) {
            for (class_3222 player : PlayerLookup.tracking((class_2586)this)) {
                player.field_13987.method_14364((class_2596)updatePacket);
            }
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }

    public boolean invEmpty() {
        Optional<class_1799> stack = this.inventory.stream().findFirst();
        return stack.map(itemStack -> itemStack == class_1799.field_8037).orElse(true);
    }

    public Optional<class_1799> getItem() {
        return this.inventory.stream().findFirst();
    }

    public boolean noFireflies() {
        return this.getFireflies().isEmpty();
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("Fireflies", 9)) {
            this.fireflies.clear();
            DataResult var10000 = FireflyInLantern.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10554("Fireflies", 10)));
            Logger var10001 = WilderSharedConstants.LOGGER;
            Objects.requireNonNull(var10001);
            Optional list = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0));
            if (list.isPresent()) {
                List fireflyList = (List)list.get();
                this.fireflies.addAll(fireflyList);
            }
        }
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.inventory);
        this.age = tag.method_10550("age");
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        DataResult var10000 = FireflyInLantern.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.fireflies);
        Logger var10001 = WilderSharedConstants.LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(cursorsNbt -> tag.method_10566("Fireflies", cursorsNbt));
        class_1262.method_5426((class_2487)tag, this.inventory);
        tag.method_10569("age", this.age);
    }

    @NotNull
    public ArrayList<FireflyInLantern> getFireflies() {
        return this.fireflies;
    }

    public void addFirefly(@NotNull class_1936 levelAccessor, @NotNull FireflyBottle bottle, @NotNull String name) {
        class_5819 random = levelAccessor.method_8409();
        class_243 newVec = new class_243(0.5 + (0.15 - random.method_43058() * 0.3), 0.0, 0.5 + (0.15 - random.method_43058() * 0.3));
        FireflyInLantern firefly = new FireflyInLantern(newVec, bottle.color, name, random.method_43058() > 0.7, random.method_43048(20), 0.0);
        this.fireflies.add(firefly);
    }

    public void removeFirefly(@NotNull FireflyInLantern firefly) {
        this.fireflies.remove(firefly);
    }

    public void spawnFireflies() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.doFireflySpawns(this.field_11863);
        }
    }

    public void spawnFireflies(@NotNull class_1937 level) {
        this.doFireflySpawns(level);
    }

    private void doFireflySpawns(@NotNull class_1937 level) {
        double extraHeight = (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_16561) != false ? 0.155 : 0.0;
        for (FireflyInLantern firefly : this.getFireflies()) {
            Firefly entity = (Firefly)RegisterEntities.FIREFLY.method_5883(level);
            if (entity == null) continue;
            entity.method_5808((double)this.field_11867.method_10263() + firefly.pos.field_1352, (double)this.field_11867.method_10264() + firefly.y + extraHeight + 0.07, (double)this.field_11867.method_10260() + firefly.pos.field_1350, 0.0f, 0.0f);
            entity.setFromBottle(true);
            if (level.method_8649((class_1297)entity)) {
                entity.hasHome = true;
                FireflyAi.rememberHome((class_1309)entity, entity.method_24515());
                entity.setColor(firefly.color);
                entity.setScale(1.0f);
                if (Objects.equals(firefly.customName, "")) continue;
                entity.method_5665(class_2561.method_30163((String)firefly.customName));
                continue;
            }
            WilderSharedConstants.log("Couldn't spawn Firefly from lantern @ " + this.field_11867, WilderSharedConstants.UNSTABLE_LOGGING);
        }
    }

    public static class FireflyInLantern {
        public static final Codec<FireflyInLantern> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_243.field_38277.fieldOf("pos").forGetter(FireflyInLantern::getPos), (App)FireflyColor.CODEC.fieldOf("color").forGetter(FireflyInLantern::getColor), (App)Codec.STRING.fieldOf("customName").orElse((Object)"").forGetter(FireflyInLantern::getCustomName), (App)Codec.BOOL.fieldOf("flickers").orElse((Object)false).forGetter(FireflyInLantern::getFlickers), (App)Codec.INT.fieldOf("age").forGetter(FireflyInLantern::getAge), (App)Codec.DOUBLE.fieldOf("y").forGetter(FireflyInLantern::getY)).apply((Applicative)instance, FireflyInLantern::new));
        public class_243 pos;
        public FireflyColor color;
        public String customName;
        public boolean flickers;
        public int age;
        public double y;
        public boolean wasNamedNectar;

        public FireflyInLantern(@NotNull class_243 pos, @NotNull FireflyColor color, @NotNull String customName, boolean flickers, int age, double y) {
            this.pos = pos;
            this.color = color;
            this.customName = customName;
            this.flickers = flickers;
            this.age = age;
            this.y = y;
        }

        public void tick(class_1937 level, class_2338 pos) {
            ++this.age;
            this.y = Math.sin((double)this.age * 0.03) * 0.15;
            boolean isNectar = this.getCustomName().toLowerCase().contains("nectar");
            if (isNectar != this.wasNamedNectar) {
                if (isNectar) {
                    if (level.method_8510() % 70L == 0L) {
                        level.method_8396(null, pos, RegisterSounds.BLOCK_DISPLAY_LANTERN_NECTAR_LOOP, class_3419.field_15256, 0.5f, 1.0f);
                    }
                    this.wasNamedNectar = true;
                } else {
                    this.wasNamedNectar = false;
                }
            } else {
                this.wasNamedNectar = false;
            }
        }

        @NotNull
        public class_243 getPos() {
            return this.pos;
        }

        @NotNull
        public FireflyColor getColor() {
            return this.color;
        }

        @NotNull
        public String getCustomName() {
            return this.customName;
        }

        public boolean getFlickers() {
            return this.flickers;
        }

        public int getAge() {
            return this.age;
        }

        public double getY() {
            return this.y;
        }
    }
}

