/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.frozenblock.wilderwild.block.HangingTendrilBlock;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.registry.RegisterBlockEntities;
import net.frozenblock.wilderwild.registry.RegisterGameEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5703;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_8514;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HangingTendrilBlockEntity
extends class_2586
implements class_5714.class_8513<class_8514.class_8516>,
class_8514 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String BASE_TEXTURE = "textures/entity/hanging_tendril/";
    private final class_8514.class_8516 vibrationListener;
    private final class_8514.class_5719 vibrationUser = this.createVibrationUser();
    public int ticksToStopTwitching;
    public int storedXP;
    public int ringOutTicksLeft;
    public class_2960 texture = WilderSharedConstants.id("textures/entity/hanging_tendril/inactive1.png");
    public boolean twitching;
    public boolean active;
    public boolean milk;
    public int ticks;
    private class_8514.class_8515 vibrationData = new class_8514.class_8515();
    private int lastVibrationFrequency;

    public HangingTendrilBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        super(RegisterBlockEntities.HANGING_TENDRIL, pos, state);
        this.vibrationListener = new class_8514.class_8516((class_8514)this);
    }

    public void serverTick(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        if (this.ticksToStopTwitching <= 0) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)HangingTendrilBlock.TWITCHING, (Comparable)Boolean.valueOf(false)));
        }
        --this.ticksToStopTwitching;
        if (this.ringOutTicksLeft >= 0) {
            --this.ringOutTicksLeft;
        } else if (((Boolean)state.method_11654((class_2769)HangingTendrilBlock.WRINGING_OUT)).booleanValue()) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)HangingTendrilBlock.WRINGING_OUT, (Comparable)Boolean.valueOf(false)));
            if (this.storedXP > 0) {
                int droppedXP = this.storedXP > 1 ? this.storedXP / 2 : 1;
                class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)pos).method_1031(0.0, -0.5, 0.0), (int)droppedXP);
                this.storedXP -= droppedXP;
                level.method_33596(null, RegisterGameEvents.TENDRIL_EXTRACT_XP, pos);
            }
        }
        class_8514.class_8517.method_51406((class_1937)level, (class_8514.class_8515)this.method_51298(), (class_8514.class_5719)this.method_51299());
    }

    public void clientTick(@NotNull class_2680 state) {
        this.twitching = this.ticksToStopTwitching > 0;
        this.milk = this.ringOutTicksLeft > 0;
        this.active = !class_5703.method_32909((class_2680)state);
        ++this.ticks;
        int animSpeed = 6;
        if (this.milk) {
            animSpeed = 2;
            this.texture = WilderSharedConstants.id("textures/entity/hanging_tendril/milk" + (this.ticks / animSpeed % 4 + 1) + ".png");
        } else if (this.active) {
            animSpeed = 1;
            this.texture = WilderSharedConstants.id("textures/entity/hanging_tendril/active" + (this.ticks / animSpeed % 5 + 1) + ".png");
        } else if (this.twitching) {
            animSpeed = 50;
            this.texture = WilderSharedConstants.id("textures/entity/hanging_tendril/twitch" + (this.ticks / animSpeed % 4 + 1) + ".png");
        } else {
            this.texture = WilderSharedConstants.id("textures/entity/hanging_tendril/inactive" + (this.ticks / animSpeed % 6 + 1) + ".png");
        }
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public void setStoredXP(int i) {
        this.storedXP = i;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.lastVibrationFrequency = tag.method_10550("last_vibration_frequency");
        this.ticksToStopTwitching = tag.method_10550("ticksToStopTwitching");
        this.storedXP = tag.method_10550("storedXP");
        this.ringOutTicksLeft = tag.method_10550("ringOutTicksLeft");
        if (tag.method_10573("listener", 10)) {
            class_8514.class_8515.field_44640.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("last_vibration_frequency", this.lastVibrationFrequency);
        tag.method_10569("ticksToStopTwitching", this.ticksToStopTwitching);
        tag.method_10569("storedXP", this.storedXP);
        tag.method_10569("ringOutTicksLeft", this.ringOutTicksLeft);
        class_8514.class_8515.field_44640.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(nbt -> tag.method_10566("listener", nbt));
    }

    @NotNull
    public class_8514.class_5719 createVibrationUser() {
        return new VibrationUser(this.method_11016());
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    public void setLastVibrationFrequency(int lastVibrationFrequency) {
        this.lastVibrationFrequency = lastVibrationFrequency;
    }

    @NotNull
    public class_8514.class_8516 getListener() {
        return this.vibrationListener;
    }

    @NotNull
    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }

    @NotNull
    public class_8514.class_5719 method_51299() {
        return this.vibrationUser;
    }

    public class VibrationUser
    implements class_8514.class_5719 {
        public static final int LISTENER_RANGE = 4;
        protected final class_2338 blockPos;
        private final class_5716 positionSource;

        public VibrationUser(class_2338 pos) {
            this.blockPos = pos;
            this.positionSource = new class_5707(pos);
        }

        public int method_49797() {
            return 4;
        }

        @NotNull
        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_43695() {
            return true;
        }

        public boolean method_32970(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5712 gameEvent, @Nullable class_5712.class_7397 context) {
            if (pos.equals((Object)this.blockPos) && (gameEvent == class_5712.field_28165 || gameEvent == class_5712.field_28164)) {
                return false;
            }
            class_2680 state = level.method_8320(HangingTendrilBlockEntity.this.method_11016());
            return state.method_26204() instanceof HangingTendrilBlock && HangingTendrilBlock.canActivate(state) && (Boolean)state.method_11654((class_2769)HangingTendrilBlock.WRINGING_OUT) == false;
        }

        public void method_32969(@NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_5712 gameEvent, @Nullable class_1297 entity, @Nullable class_1297 entity2, float f) {
            class_2680 blockState = HangingTendrilBlockEntity.this.method_11010();
            if (class_5703.method_32909((class_2680)blockState)) {
                HangingTendrilBlockEntity.this.setLastVibrationFrequency(class_8514.method_51385((class_5712)gameEvent));
                int i = class_8514.method_51384((float)f, (int)this.method_49797());
                class_2248 block = blockState.method_26204();
                if (block instanceof HangingTendrilBlock) {
                    HangingTendrilBlock hangingTendrilBlock = (HangingTendrilBlock)block;
                    hangingTendrilBlock.activate(entity, (class_1937)world, this.blockPos, blockState, gameEvent, i, HangingTendrilBlockEntity.this.getLastVibrationFrequency());
                }
            }
        }

        public void method_42672() {
            HangingTendrilBlockEntity.this.method_5431();
        }

        public boolean method_51363() {
            return true;
        }
    }
}

