/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.entity;

import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.frozenblock.wilderwild.block.StoneChestBlock;
import net.frozenblock.wilderwild.config.BlockConfig;
import net.frozenblock.wilderwild.registry.RegisterBlockEntities;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5561;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneChestBlockEntity
extends class_2595 {
    private final class_5561 stoneStateManager = new class_5561(){

        protected void method_31681(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        }

        protected void method_31683(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        }

        protected void method_31682(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, int count, int openCount) {
            StoneChestBlockEntity.this.method_11049(level, pos, state, count, openCount);
        }

        protected boolean method_31679(@NotNull class_1657 player) {
            if (player.field_7512 instanceof class_1707) {
                class_1263 inventory = ((class_1707)player.field_7512).method_7629();
                return inventory == StoneChestBlockEntity.this || inventory instanceof class_1258 && ((class_1258)inventory).method_5405((class_1263)StoneChestBlockEntity.this);
            }
            return false;
        }
    };
    public float openProgress;
    public float prevOpenProgress;
    public float highestLidPoint;
    public int stillLidTicks;
    public int cooldownTicks;
    public boolean closing;
    protected long updateTime;

    public StoneChestBlockEntity(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        super(RegisterBlockEntities.STONE_CHEST, blockPos, blockState);
    }

    public static void serverStoneTick(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state, @NotNull StoneChestBlockEntity stoneChest) {
        class_3218 serverLevel = (class_3218)level;
        StoneChestBlockEntity otherChest = StoneChestBlock.getOtherChest((class_1936)serverLevel, pos, state);
        long gameTime = level.method_8510();
        if (gameTime != stoneChest.updateTime) {
            if (stoneChest.cooldownTicks > 0) {
                --stoneChest.cooldownTicks;
            }
            stoneChest.prevOpenProgress = stoneChest.openProgress;
            if (stoneChest.stillLidTicks > 0) {
                --stoneChest.stillLidTicks;
            } else if (stoneChest.openProgress > 0.0f) {
                serverLevel.method_33596(null, class_5712.field_28177, pos);
                stoneChest.openProgress = Math.max(0.0f, stoneChest.openProgress - 0.0425f);
                if (!stoneChest.closing) {
                    stoneChest.closing = true;
                    StoneChestBlockEntity.playSound((class_1937)serverLevel, pos, state, RegisterSounds.BLOCK_STONE_CHEST_CLOSE_START, RegisterSounds.BLOCK_STONE_CHEST_CLOSE_START_UNDERWATER, 0.3f);
                }
                if (stoneChest.openProgress <= 0.0f) {
                    stoneChest.onLidSlam((class_1937)serverLevel, pos, state, otherChest);
                }
            }
            stoneChest.updateTime = gameTime;
            if (otherChest != null) {
                stoneChest.syncLidValuesWith(otherChest);
            }
        }
    }

    public static void clientStoneTick(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull StoneChestBlockEntity stoneChest) {
        StoneChestBlockEntity otherChest = StoneChestBlock.getOtherChest((class_1936)level, pos, state);
        long gameTime = level.method_8510();
        if (gameTime != stoneChest.updateTime) {
            stoneChest.prevOpenProgress = stoneChest.openProgress;
            if (stoneChest.cooldownTicks > 0) {
                --stoneChest.cooldownTicks;
            }
            if (stoneChest.stillLidTicks > 0) {
                --stoneChest.stillLidTicks;
            } else if (stoneChest.openProgress > 0.0f) {
                stoneChest.closing = true;
                stoneChest.openProgress = Math.max(0.0f, stoneChest.openProgress - 0.0425f);
                if (stoneChest.openProgress <= 0.0f) {
                    stoneChest.onLidSlam(level, pos, state, otherChest);
                }
            }
            stoneChest.updateTime = gameTime;
            if (otherChest != null) {
                stoneChest.syncLidValuesWith(otherChest);
            }
        }
    }

    public static void playSound(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3414 soundEvent, @NotNull class_3414 waterloggedSoundEvent, float volume) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 0.5;
        double z = (double)pos.method_10260() + 0.5;
        if (chestType == class_2745.field_12571) {
            class_2350 direction = class_2281.method_9758((class_2680)state);
            x += (double)direction.method_10148() * 0.5;
            z += (double)direction.method_10165() * 0.5;
        } else if (chestType == class_2745.field_12574) {
            class_2350 direction = class_2281.method_9758((class_2680)state);
            x -= (double)direction.method_10148() * 0.5;
            z -= (double)direction.method_10165() * 0.5;
        }
        level.method_43128(null, x, y, z, (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? waterloggedSoundEvent : soundEvent, class_3419.field_15245, volume, level.field_9229.method_43057() * 0.18f + 0.9f);
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.openProgress = tag.method_10583("openProgress");
        this.highestLidPoint = tag.method_10583("highestLidPoint");
        this.stillLidTicks = tag.method_10550("stillLidTicks");
        this.cooldownTicks = tag.method_10550("cooldownTicks");
        this.closing = tag.method_10577("closing");
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10548("openProgress", this.openProgress);
        tag.method_10548("highestLidPoint", this.highestLidPoint);
        tag.method_10569("stillLidTicks", this.stillLidTicks);
        tag.method_10569("cooldownTicks", this.cooldownTicks);
        tag.method_10556("closing", this.closing);
    }

    public float getOpenProgress(float delta) {
        return class_3532.method_16439((float)delta, (float)this.prevOpenProgress, (float)this.openProgress);
    }

    public void liftLid(float liftAmount, boolean ancient) {
        this.highestLidPoint = this.openProgress = class_3532.method_15363((float)(this.openProgress + (!ancient ? liftAmount * 2.0f : liftAmount)), (float)0.0f, (float)0.5f);
        this.stillLidTicks = (int)(Math.max((double)this.openProgress, 0.2) * (double)(!ancient ? 220 : 160) * BlockConfig.get().stoneChest.getStoneChestTimer());
    }

    public void setLid(float liftAmount) {
        this.highestLidPoint = this.openProgress = class_3532.method_15363((float)liftAmount, (float)0.0f, (float)0.5f);
        this.stillLidTicks = (int)(Math.max((double)this.openProgress, 0.2) * 180.0 * BlockConfig.get().stoneChest.getStoneChestTimer());
    }

    public void onLidSlam(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable StoneChestBlockEntity otherStoneChest) {
        if (!level.field_9236 && level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            if (this.highestLidPoint > 0.2f) {
                server.method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.625, (double)pos.method_10260() + 0.5, level.field_9229.method_39332(3, (int)(this.highestLidPoint * 10.0f) + 2), 0.21875, 0.0, 0.21875, 0.05);
                if (otherStoneChest != null) {
                    class_2338 otherPos = otherStoneChest.field_11867;
                    server.method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)otherPos.method_10263() + 0.5, (double)otherPos.method_10264() + 0.625, (double)otherPos.method_10260() + 0.5, level.field_9229.method_39332(3, (int)(this.highestLidPoint * 10.0f) + ((Boolean)state.method_11654((class_2769)RegisterProperties.ANCIENT) != false ? 4 : 2)), 0.21875, 0.0, 0.21875, 0.05);
                }
            }
            StoneChestBlockEntity.playSound(level, pos, state, RegisterSounds.BLOCK_STONE_CHEST_SLAM, RegisterSounds.BLOCK_STONE_CHEST_SLAM_UNDERWATER, 0.5f + this.highestLidPoint / 5.0f);
        }
        this.closing = false;
        this.cooldownTicks = 15;
        this.highestLidPoint = 0.0f;
    }

    public boolean method_5443(@NotNull class_1657 player) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > 64.0) && !this.closing && (double)this.openProgress >= 0.3;
    }

    public void syncLidValuesWith(@Nullable StoneChestBlockEntity otherStoneChest) {
        if (otherStoneChest != null) {
            this.syncValues(otherStoneChest);
            otherStoneChest.updateSync();
        }
        this.updateSync();
    }

    public void updateSync() {
        class_2622 updatePacket;
        if (this.field_11863 != null && !this.field_11863.field_9236 && (updatePacket = this.getUpdatePacket()) != null) {
            for (class_3222 player : PlayerLookup.tracking((class_2586)this)) {
                player.field_13987.method_14364((class_2596)updatePacket);
            }
        }
    }

    private void syncValues(@NotNull StoneChestBlockEntity otherStoneChest) {
        otherStoneChest.openProgress = this.openProgress;
        otherStoneChest.prevOpenProgress = this.prevOpenProgress;
        otherStoneChest.highestLidPoint = this.highestLidPoint;
        otherStoneChest.stillLidTicks = this.stillLidTicks;
        otherStoneChest.cooldownTicks = this.cooldownTicks;
        otherStoneChest.closing = this.closing;
        otherStoneChest.updateTime = this.updateTime;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.stone_chest");
    }

    public void method_5435(@NotNull class_1657 player) {
    }

    public void method_5432(@NotNull class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.stoneStateManager.method_31685(player, Objects.requireNonNull(this.method_10997()), this.method_11016(), this.method_11010());
        }
    }

    @NotNull
    public ArrayList<class_1799> nonAncientItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1799 item : this.method_11282()) {
            if (item.method_7948().method_10580("wilderwild_is_ancient") != null || item.method_7960()) continue;
            items.add(item);
        }
        return items;
    }

    @NotNull
    public ArrayList<class_1799> ancientItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1799 item : this.method_11282()) {
            if (item.method_7948().method_10580("wilderwild_is_ancient") == null || item.method_7960()) continue;
            items.add(item);
        }
        return items;
    }
}

