/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.config.gui;

import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.config.clothconfig.FrozenClothConfig;
import net.frozenblock.wilderwild.config.EntityConfig;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class EntityConfigGui {
    private EntityConfigGui() {
        throw new UnsupportedOperationException("EntityConfigGui contains only static declarations.");
    }

    public static void setupEntries(ConfigCategory category, ConfigEntryBuilder entryBuilder) {
        EntityConfig config = EntityConfig.get(true);
        EntityConfig defaultConfig = (EntityConfig)EntityConfig.INSTANCE.defaultInstance();
        EntityConfig.AllayConfig allay = config.allay;
        EntityConfig.EnderManConfig enderMan = config.enderMan;
        EntityConfig.FireflyConfig firefly = config.firefly;
        EntityConfig.JellyfishConfig jellyfish = config.jellyfish;
        EntityConfig.TumbleweedConfig tumbleweed = config.tumbleweed;
        EntityConfig.WardenConfig warden = config.warden;
        category.setBackground(WilderSharedConstants.id("textures/config/entity.png"));
        ConfigCategory unpassableRail = category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(WilderSharedConstants.text("unpassable_rail"), config.unpassableRail).setDefaultValue(defaultConfig.unpassableRail).setSaveConsumer(newValue -> {
            config.unpassableRail = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("unpassable_rail")}).requireRestart().build());
        BooleanListEntry keyframeAllayDance = entryBuilder.startBooleanToggle(WilderSharedConstants.text("keyframe_allay_dance"), allay.keyframeAllayDance).setDefaultValue(defaultConfig.allay.keyframeAllayDance).setSaveConsumer(newValue -> {
            allay.keyframeAllayDance = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("keyframe_allay_dance")}).requireRestart().build();
        ConfigCategory allayCategory = FrozenClothConfig.createSubCategory((ConfigEntryBuilder)entryBuilder, (ConfigCategory)category, (class_2561)WilderSharedConstants.text("allay"), (boolean)false, (class_2561)WilderSharedConstants.tooltip("allay"), (AbstractConfigListEntry[])new AbstractConfigListEntry[]{keyframeAllayDance});
        BooleanListEntry angerLoopSound = entryBuilder.startBooleanToggle(WilderSharedConstants.text("anger_loop_sound"), enderMan.angerLoopSound).setDefaultValue(defaultConfig.enderMan.angerLoopSound).setSaveConsumer(newValue -> {
            enderMan.angerLoopSound = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("anger_loop_sound")}).build();
        BooleanListEntry movingStareSound = entryBuilder.startBooleanToggle(WilderSharedConstants.text("moving_stare_sound"), enderMan.movingStareSound).setDefaultValue(defaultConfig.enderMan.movingStareSound).setSaveConsumer(newValue -> {
            enderMan.movingStareSound = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("moving_stare_sound")}).build();
        ConfigCategory enderManCategory = FrozenClothConfig.createSubCategory((ConfigEntryBuilder)entryBuilder, (ConfigCategory)category, (class_2561)WilderSharedConstants.text("enderman"), (boolean)false, (class_2561)WilderSharedConstants.tooltip("enderman"), (AbstractConfigListEntry[])new AbstractConfigListEntry[]{angerLoopSound, movingStareSound});
        IntegerSliderEntry fireflySpawnCap = entryBuilder.startIntSlider(WilderSharedConstants.text("firefly_spawn_cap"), firefly.fireflySpawnCap, 0, 100).setDefaultValue(defaultConfig.firefly.fireflySpawnCap).setSaveConsumer(newValue -> {
            firefly.fireflySpawnCap = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("firefly_spawn_cap")}).requireRestart().build();
        ConfigCategory fireflyCategory = FrozenClothConfig.createSubCategory((ConfigEntryBuilder)entryBuilder, (ConfigCategory)category, (class_2561)WilderSharedConstants.text("firefly"), (boolean)false, (class_2561)WilderSharedConstants.tooltip("firefly"), (AbstractConfigListEntry[])new AbstractConfigListEntry[]{fireflySpawnCap});
        IntegerSliderEntry jellyfishSpawnCap = entryBuilder.startIntSlider(WilderSharedConstants.text("jellyfish_spawn_cap"), jellyfish.jellyfishSpawnCap, 0, 100).setDefaultValue(defaultConfig.jellyfish.jellyfishSpawnCap).setSaveConsumer(newValue -> {
            jellyfish.jellyfishSpawnCap = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("jellyfish_spawn_cap")}).requireRestart().build();
        IntegerSliderEntry jellyfishTentacles = entryBuilder.startIntSlider(WilderSharedConstants.text("jellyfish_tentacles"), jellyfish.jellyfishTentacles, 0, 100).setDefaultValue(defaultConfig.jellyfish.jellyfishTentacles).setSaveConsumer(newValue -> {
            jellyfish.jellyfishTentacles = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("jellyfish_tentacles")}).requireRestart().build();
        ConfigCategory jellyfishCategory = FrozenClothConfig.createSubCategory((ConfigEntryBuilder)entryBuilder, (ConfigCategory)category, (class_2561)WilderSharedConstants.text("jellyfish"), (boolean)false, (class_2561)WilderSharedConstants.tooltip("jellyfish"), (AbstractConfigListEntry[])new AbstractConfigListEntry[]{jellyfishSpawnCap, jellyfishTentacles});
        IntegerSliderEntry tumbleweedSpawnCap = entryBuilder.startIntSlider(WilderSharedConstants.text("tumbleweed_spawn_cap"), tumbleweed.tumbleweedSpawnCap, 0, 100).setDefaultValue(defaultConfig.tumbleweed.tumbleweedSpawnCap).setSaveConsumer(newValue -> {
            tumbleweed.tumbleweedSpawnCap = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("tumbleweed_spawn_cap")}).requireRestart().build();
        BooleanListEntry leashedTumbleweed = entryBuilder.startBooleanToggle(WilderSharedConstants.text("leashed_tumbleweed"), tumbleweed.leashedTumbleweed).setDefaultValue(defaultConfig.tumbleweed.leashedTumbleweed).setSaveConsumer(newValue -> {
            tumbleweed.leashedTumbleweed = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("leashed_tumbleweed")}).build();
        BooleanListEntry tumbleweedDestroysCrops = entryBuilder.startBooleanToggle(WilderSharedConstants.text("tumbleweed_destroys_crops"), tumbleweed.tumbleweedDestroysCrops).setDefaultValue(defaultConfig.tumbleweed.tumbleweedDestroysCrops).setSaveConsumer(newValue -> {
            tumbleweed.tumbleweedDestroysCrops = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("tumbleweed_destroys_crops")}).build();
        BooleanListEntry tumbleweedRotatesToLookDirection = entryBuilder.startBooleanToggle(WilderSharedConstants.text("tumbleweed_rotates_to_look_direction"), tumbleweed.tumbleweedRotatesToLookDirection).setDefaultValue(defaultConfig.tumbleweed.tumbleweedRotatesToLookDirection).setSaveConsumer(newValue -> {
            tumbleweed.tumbleweedRotatesToLookDirection = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("tumbleweed_rotates_to_look_direction")}).build();
        ConfigCategory tumbleweedCategory = FrozenClothConfig.createSubCategory((ConfigEntryBuilder)entryBuilder, (ConfigCategory)category, (class_2561)WilderSharedConstants.text("tumbleweed"), (boolean)false, (class_2561)WilderSharedConstants.tooltip("tumbleweed"), (AbstractConfigListEntry[])new AbstractConfigListEntry[]{tumbleweedSpawnCap, leashedTumbleweed, tumbleweedDestroysCrops, tumbleweedRotatesToLookDirection});
        BooleanListEntry instantAttack = entryBuilder.startBooleanToggle(WilderSharedConstants.text("warden_attacks_immediately"), warden.wardenAttacksImmediately).setDefaultValue(defaultConfig.warden.wardenAttacksImmediately).setSaveConsumer(newValue -> {
            warden.wardenAttacksImmediately = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("warden_attacks_immediately")}).build();
        BooleanListEntry dying = entryBuilder.startBooleanToggle(WilderSharedConstants.text("warden_dying_animation"), warden.wardenDyingAnimation).setDefaultValue(defaultConfig.warden.wardenDyingAnimation).setSaveConsumer(newValue -> {
            warden.wardenDyingAnimation = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("warden_dying_animation")}).build();
        BooleanListEntry command = entryBuilder.startBooleanToggle(WilderSharedConstants.text("warden_emerges_from_command"), warden.wardenEmergesFromCommand).setDefaultValue(defaultConfig.warden.wardenEmergesFromCommand).setSaveConsumer(newValue -> {
            warden.wardenEmergesFromCommand = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("warden_emerges_from_command")}).build();
        BooleanListEntry egg = entryBuilder.startBooleanToggle(WilderSharedConstants.text("warden_emerges_from_egg"), warden.wardenEmergesFromEgg).setDefaultValue(defaultConfig.warden.wardenEmergesFromEgg).setSaveConsumer(newValue -> {
            warden.wardenEmergesFromEgg = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("warden_emerges_from_egg")}).build();
        BooleanListEntry swimming = entryBuilder.startBooleanToggle(WilderSharedConstants.text("warden_swim_animation"), warden.wardenSwimAnimation).setDefaultValue(defaultConfig.warden.wardenSwimAnimation).setSaveConsumer(newValue -> {
            warden.wardenSwimAnimation = newValue;
        }).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("warden_swim_animation")}).build();
        BooleanListEntry tendrils = entryBuilder.startBooleanToggle(WilderSharedConstants.text("warden_custom_tendrils"), warden.wardenCustomTendrils).setDefaultValue(defaultConfig.warden.wardenCustomTendrils).setSaveConsumer(newValue -> {
            warden.wardenCustomTendrils = newValue;
        }).setYesNoTextSupplier(bool -> WilderSharedConstants.text("warden_custom_tendrils." + bool)).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("warden_custom_tendrils")}).build();
        BooleanListEntry sniff = entryBuilder.startBooleanToggle(WilderSharedConstants.text("warden_bedrock_sniff"), warden.wardenBedrockSniff).setDefaultValue(defaultConfig.warden.wardenBedrockSniff).setSaveConsumer(newValue -> {
            warden.wardenBedrockSniff = newValue;
        }).setYesNoTextSupplier(bool -> WilderSharedConstants.text("warden_bedrock_sniff." + bool)).setTooltip(new class_2561[]{WilderSharedConstants.tooltip("warden_bedrock_sniff")}).requireRestart().build();
        ConfigCategory wardenCategory = FrozenClothConfig.createSubCategory((ConfigEntryBuilder)entryBuilder, (ConfigCategory)category, (class_2561)WilderSharedConstants.text("warden"), (boolean)false, (class_2561)WilderSharedConstants.tooltip("warden"), (AbstractConfigListEntry[])new AbstractConfigListEntry[]{instantAttack, dying, command, egg, swimming, tendrils, sniff});
    }
}

