/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.frozenblock.lib.sound.api.FrozenSoundPackets;
import net.frozenblock.wilderwild.block.entity.HangingTendrilBlockEntity;
import net.frozenblock.wilderwild.config.ItemConfig;
import net.frozenblock.wilderwild.item.AncientHorn;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.misc.mod_compat.WilderModIntegrations;
import net.frozenblock.wilderwild.misc.mod_compat.scp.AbstractSimpleCopperPipesIntegration;
import net.frozenblock.wilderwild.misc.server.EasyPacket;
import net.frozenblock.wilderwild.registry.RegisterBlocks;
import net.frozenblock.wilderwild.registry.RegisterDamageTypes;
import net.frozenblock.wilderwild.registry.RegisterEntities;
import net.frozenblock.wilderwild.registry.RegisterGameEvents;
import net.frozenblock.wilderwild.registry.RegisterItems;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.frozenblock.wilderwild.tag.WilderBlockTags;
import net.frozenblock.wilderwild.tag.WilderEntityTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3709;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4262;
import net.minecraft.class_5703;
import net.minecraft.class_5704;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_7244;
import net.minecraft.class_7253;
import net.minecraft.class_7260;
import net.minecraft.class_7268;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AncientHornProjectile
extends class_1665 {
    public static final int DEFAULT_LIFESPAN = 300;
    public static final float MIN_SIZE = 0.01f;
    public static final float MAX_SIZE = 30.0f;
    private static final class_6862<class_2248> NON_COLLIDE = WilderBlockTags.ANCIENT_HORN_NON_COLLIDE;
    private static final class_2940<Float> BOUNDING_BOX_MULTIPLIER = class_2945.method_12791(AncientHornProjectile.class, (class_2941)class_2943.field_13320);
    public boolean canInteractWithPipe = true;
    private boolean shot;
    private boolean leftOwner;
    private int aliveTicks;
    private double vecX;
    private double vecY;
    private double vecZ;
    private boolean shotByPlayer;
    private int bubbles;
    private class_2680 inBlockState;
    private IntArrayList hitEntities = new IntArrayList();

    public AncientHornProjectile(@NotNull class_1299<? extends AncientHornProjectile> entityType, @NotNull class_1937 level) {
        super(entityType, level);
        this.method_7444(RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_DISSIPATE);
    }

    public AncientHornProjectile(@NotNull class_1937 level, double x, double y, double z) {
        super(RegisterEntities.ANCIENT_HORN_PROJECTILE_ENTITY, x, y, z, level);
        this.method_7444(RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_DISSIPATE);
    }

    private static void trySpawnWarden(@NotNull class_3218 level, @NotNull class_2338 pos) {
        if (level.method_8450().method_8355(class_1928.field_38975)) {
            Optional warden = class_7244.method_42122((class_1299)class_1299.field_38095, (class_3730)class_3730.field_16461, (class_3218)level, (class_2338)pos, (int)20, (int)5, (int)6, (class_7244.class_7502)class_7244.class_7502.field_39401);
            warden.ifPresent(wardenEntity -> wardenEntity.method_5783(class_3417.field_38061, 5.0f, 1.0f));
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BOUNDING_BOX_MULTIPLIER, (Object)Float.valueOf(0.0f));
    }

    public List<class_1297> collidingEntities() {
        return this.method_37908().method_8333((class_1297)this, this.method_5829().method_18804(this.method_18798()).method_1014(1.0), this::method_26958);
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public int getAliveTicks() {
        return this.aliveTicks;
    }

    public void setShotByPlayer(boolean bl) {
        this.shotByPlayer = bl;
    }

    public void setBubbles(int amount) {
        this.bubbles = amount;
    }

    public void method_5773() {
        class_1937 class_19372;
        class_1937 class_19373;
        this.method_5670();
        this.field_7574 = 0;
        if (this.bubbles > 0 && (class_19373 = this.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19373;
            --this.bubbles;
            EasyPacket.EasyFloatingSculkBubblePacket.createParticle((class_1937)server, this.method_19538(), server.field_9229.method_43058() > 0.7 ? 1.0 : 0.0, 20 + server.field_9229.method_43048(40), 0.05, server.field_9229.method_39332(1, 3));
        }
        if (this.aliveTicks > ItemConfig.get().ancientHorn.ancientHornLifespan) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        ++this.aliveTicks;
        if (!this.shot) {
            this.shot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        class_243 deltaMovement = this.method_18798();
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double horizontalDistance = deltaMovement.method_37267();
            this.method_36456((float)(class_3532.method_15349((double)deltaMovement.field_1352, (double)deltaMovement.field_1350) * 57.2957763671875));
            this.method_36457((float)(class_3532.method_15349((double)deltaMovement.field_1351, (double)horizontalDistance) * 57.2957763671875));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        class_2338 blockPos = this.method_24515();
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (this.method_5799() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            EasyPacket.EasyFloatingSculkBubblePacket.createParticle((class_1937)server, new class_243(this.field_6014, this.field_6036, this.field_5969), 0.0, 60, 0.05, 4);
        }
        if (this.method_5721() || blockState.method_27852(class_2246.field_27879)) {
            this.method_5646();
        }
        class_243 position = this.method_19538();
        class_243 deltaPosition = position.method_1019(deltaMovement);
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(position, deltaPosition, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (!this.method_31481() && this.canInteract()) {
            List<class_1297> entities = this.collidingEntities();
            class_1297 owner = this.method_24921();
            for (class_1297 entity : entities) {
                int uuid;
                if (this.method_31481() || entity == null || entity == owner) continue;
                boolean shouldDamage = true;
                if (entity instanceof class_1657) {
                    class_1657 playerOwner;
                    class_1657 player = (class_1657)entity;
                    if (player.method_7337()) {
                        shouldDamage = false;
                    }
                    if (owner instanceof class_1657 && !(playerOwner = (class_1657)owner).method_7256(player)) {
                        shouldDamage = false;
                    }
                }
                if (entity.method_5655()) {
                    shouldDamage = false;
                }
                if (this.hitEntities.contains(uuid = entity.method_5667().hashCode())) {
                    shouldDamage = false;
                }
                if (!shouldDamage) continue;
                this.hitEntities.add(uuid);
                this.hitEntity(entity);
            }
        }
        boolean noPhysics = this.method_7441();
        if (!this.method_31481() && !noPhysics) {
            this.method_7488((class_239)hitResult);
            if (this.method_31481()) {
                return;
            }
            this.field_6007 = true;
        }
        double deltaX = deltaMovement.field_1352;
        double deltaY = deltaMovement.field_1351;
        double deltaZ = deltaMovement.field_1350;
        if (this.method_7443()) {
            for (int i = 0; i < 4; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11205, this.method_23317() + deltaX * (double)i / 4.0, this.method_23318() + deltaY * (double)i / 4.0, this.method_23321() + deltaZ * (double)i / 4.0, -deltaX, -deltaY + 0.2, -deltaZ);
            }
        }
        float moveDivider = this.getBoundingBoxMultiplier() * 0.5f + 1.0f;
        double x = this.method_23317() + deltaX / (double)moveDivider;
        double y = this.method_23318() + deltaY / (double)moveDivider;
        double z = this.method_23321() + deltaZ / (double)moveDivider;
        double horizontalDistance = deltaMovement.method_37267();
        if (noPhysics) {
            this.method_36456((float)(class_3532.method_15349((double)(-deltaX), (double)(-deltaZ)) * 57.2957763671875));
        } else {
            this.method_36456((float)(class_3532.method_15349((double)deltaX, (double)deltaZ) * 57.2957763671875));
        }
        this.method_36457((float)(class_3532.method_15349((double)deltaY, (double)horizontalDistance) * 57.2957763671875));
        this.method_36457(AncientHornProjectile.method_26960((float)this.field_6004, (float)this.method_36455()));
        this.method_36456(AncientHornProjectile.method_26960((float)this.field_5982, (float)this.method_36454()));
        this.method_5814(x, y, z);
        this.method_5852();
        float size = this.getBoundingBoxMultiplier() + ItemConfig.get().ancientHorn.ancientHornSizeMultiplier;
        if (size > 0.01f && size < 30.0f) {
            this.setBoundingBoxMultiplier(size);
        }
    }

    @NotNull
    public class_238 method_33332() {
        return super.method_33332().method_1014((double)(this.getBoundingBoxMultiplier() / 2.0f));
    }

    public void setCooldown(int cooldownTicks) {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 user = (class_3222)class_12972;
            user.method_7357().method_7906((class_1792)RegisterItems.ANCIENT_HORN, cooldownTicks);
        }
    }

    public void addCooldown(int cooldownTicks) {
        class_3222 user;
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_3222 && !(user = (class_3222)class_12972).method_7337()) {
            class_1796 manager = user.method_7357();
            class_1796.class_1797 entry = (class_1796.class_1797)manager.field_8024.get((Object)RegisterItems.ANCIENT_HORN);
            if (entry != null) {
                manager.method_7900((class_1792)RegisterItems.ANCIENT_HORN);
                manager.method_7906((class_1792)RegisterItems.ANCIENT_HORN, entry.field_8027 - entry.field_8028 + cooldownTicks);
            } else {
                manager.method_7906((class_1792)RegisterItems.ANCIENT_HORN, cooldownTicks);
            }
        }
    }

    public boolean method_26958(@NotNull class_1297 entity) {
        if (!entity.method_7325() && entity.method_5805() && entity.method_5863() && !(entity instanceof class_1676)) {
            class_1297 owner = this.method_24921();
            return owner != null && (this.leftOwner || !owner.method_5794(entity));
        }
        return false;
    }

    public void method_5694(@NotNull class_1657 player) {
    }

    protected void method_24920(@NotNull class_3965 result) {
        class_1937 class_19372;
        this.inBlockState = this.method_37908().method_8320(result.method_17777());
        class_2680 blockState = this.method_37908().method_8320(result.method_17777());
        class_1297 owner = this.method_24921();
        if (this.canInteractWithPipe && ((AbstractSimpleCopperPipesIntegration)WilderModIntegrations.SIMPLE_COPPER_PIPES_INTEGRATION.getIntegration()).isCopperPipe(blockState) && owner != null && result.method_17780() == ((class_2350)blockState.method_11654((class_2769)class_2741.field_12525)).method_10153() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (((AbstractSimpleCopperPipesIntegration)WilderModIntegrations.SIMPLE_COPPER_PIPES_INTEGRATION.getIntegration()).addHornNbtToBlock(server, result.method_17777(), owner)) {
                this.method_31472();
            }
        }
        blockState.method_26175(this.method_37908(), blockState, result, (class_1676)this);
        class_243 hitVec = result.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(hitVec);
        class_243 hitNormal = hitVec.method_1029().method_1021((double)0.05f);
        this.method_23327(this.method_23317() - hitNormal.field_1352, this.method_23318() - hitNormal.field_1351, this.method_23321() - hitNormal.field_1350);
        this.method_5783(this.method_20011(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        this.field_7588 = true;
        this.method_7439(false);
        class_1937 class_19373 = this.method_37908();
        if (class_19373 instanceof class_3218) {
            class_3218 server = (class_3218)class_19373;
            if (this.canInteract()) {
                class_2248 block = blockState.method_26204();
                if (blockState.method_26204() == class_2246.field_37571) {
                    if (ItemConfig.get().ancientHorn.ancientHornCanSummonWarden) {
                        class_2338 pos = result.method_17777();
                        WilderSharedConstants.log(class_2246.field_37571, pos, "Horn Projectile Touched", WilderSharedConstants.UNSTABLE_LOGGING);
                        if ((Integer)blockState.method_11654((class_2769)RegisterProperties.SOULS_TAKEN) < 2 && !((Boolean)blockState.method_11654((class_2769)class_7268.field_38229)).booleanValue()) {
                            if (!((Boolean)blockState.method_11654((class_2769)class_7268.field_38422)).booleanValue()) {
                                server.method_8501(pos, (class_2680)blockState.method_11657((class_2769)RegisterProperties.SOULS_TAKEN, (Comparable)Integer.valueOf((Integer)blockState.method_11654((class_2769)RegisterProperties.SOULS_TAKEN) + 1)));
                            } else {
                                server.method_8501(pos, (class_2680)blockState.method_11657((class_2769)class_7268.field_38422, (Comparable)Boolean.valueOf(false)));
                            }
                            server.method_14199((class_2394)class_2398.field_38002, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.15, (double)pos.method_10260() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
                            AncientHornProjectile.trySpawnWarden(server, pos);
                            class_7260.method_42204((class_3218)server, (class_243)class_243.method_24953((class_2382)this.method_24515()), null, (int)40);
                            server.method_20290(3007, pos, 0);
                            server.method_43276(class_5712.field_38244, pos, class_5712.class_7397.method_43285((class_1297)owner));
                            this.setCooldown(AncientHorn.getCooldown(this.method_24921(), 1200));
                            this.method_7444(RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_DISSIPATE);
                            this.method_7442(false);
                            this.method_5650(class_1297.class_5529.field_26999);
                        }
                    }
                } else if (block instanceof class_5703) {
                    class_5703 sculkSensor = (class_5703)block;
                    class_2338 pos = result.method_17777();
                    class_5704 blockEntity = (class_5704)this.method_37908().method_8321(pos);
                    assert (blockEntity != null);
                    WilderSharedConstants.log(class_2246.field_28108, pos, "Horn Projectile Touched", WilderSharedConstants.UNSTABLE_LOGGING);
                    if (((Boolean)blockState.method_11654((class_2769)RegisterProperties.HICCUPPING)).booleanValue()) {
                        server.method_8501(pos, (class_2680)blockState.method_11657((class_2769)RegisterProperties.HICCUPPING, (Comparable)Boolean.valueOf(false)));
                    } else {
                        server.method_8501(pos, (class_2680)blockState.method_11657((class_2769)RegisterProperties.HICCUPPING, (Comparable)Boolean.valueOf(true)));
                    }
                    if (class_5703.method_32909((class_2680)blockState)) {
                        sculkSensor.method_32904(null, this.method_37908(), pos, this.method_37908().method_8320(pos), server.field_9229.method_43048(15), blockEntity.method_32912());
                        this.method_37908().method_33596(null, RegisterGameEvents.SCULK_SENSOR_ACTIVATE, pos);
                        this.setCooldown(AncientHorn.getCooldown(this.method_24921(), 800));
                    }
                }
            }
        }
        this.method_7444(RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_DISSIPATE);
        this.method_7442(false);
        this.method_5650(class_1297.class_5529.field_26999);
    }

    @NotNull
    protected class_3414 method_7440() {
        return RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_DISSIPATE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean method_7441() {
        block7: {
            class_2680 insideState;
            block6: {
                class_1937 class_19372;
                insideState = this.method_37908().method_8320(this.method_24515());
                if (!insideState.method_27852((class_2248)RegisterBlocks.HANGING_TENDRIL) || !((class_19372 = this.method_37908()) instanceof class_3218)) break block6;
                class_3218 server = (class_3218)class_19372;
                if (!this.canInteract()) break block6;
                class_2338 pos = this.method_24515();
                class_2586 entity = this.method_37908().method_8321(pos);
                if (entity instanceof HangingTendrilBlockEntity) {
                    HangingTendrilBlockEntity tendril = (HangingTendrilBlockEntity)entity;
                    WilderSharedConstants.log("Horn Projectile Found Hanging Tendril Entity", WilderSharedConstants.UNSTABLE_LOGGING);
                    this.method_5783(this.method_20011(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
                    int xp = tendril.getStoredXP();
                    if (xp > 0) {
                        tendril.setStoredXP(0);
                        this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 0.0f, class_1937.class_7867.field_40888);
                        FrozenSoundPackets.createLocalSound((class_1937)this.method_37908(), (class_2338)pos, (class_3414)RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_BLAST, (class_3419)class_3419.field_15254, (float)1.5f, (float)1.0f, (boolean)true);
                        this.method_37908().method_22352(this.method_24515(), false);
                        class_1303.method_31493((class_3218)server, (class_243)class_243.method_24953((class_2382)pos).method_1031(0.0, 0.0, 0.0), (int)xp);
                        this.setCooldown(AncientHorn.getCooldown(this.method_24921(), 780));
                        this.method_7442(false);
                        this.method_5650(class_1297.class_5529.field_26999);
                    }
                }
                break block7;
            }
            if (insideState.method_26164(NON_COLLIDE)) {
                class_1937 entity = this.method_37908();
                if (!(entity instanceof class_3218)) return true;
                class_3218 server = (class_3218)entity;
                class_2248 tendril = insideState.method_26204();
                if (tendril instanceof class_3709) {
                    class_3709 bell = (class_3709)tendril;
                    bell.method_19286((class_1937)server, insideState, this.method_37908().method_17742(new class_3959(this.method_19538(), new class_243((double)this.method_31477(), (double)this.method_31478(), (double)this.method_31479()), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)), (class_1676)this);
                    return true;
                }
                if (!(insideState.method_26204() instanceof class_4262) && !insideState.method_26164(ConventionalBlockTags.GLASS_BLOCKS)) {
                    if (!insideState.method_26164(ConventionalBlockTags.GLASS_PANES)) return true;
                }
                if (!ItemConfig.get().ancientHorn.ancientHornShattersGlass) {
                    if (!insideState.method_27852((class_2248)RegisterBlocks.ECHO_GLASS)) return true;
                }
                insideState.method_26175(this.method_37908(), insideState, this.method_37908().method_17742(new class_3959(this.method_19538(), new class_243((double)this.method_31477(), (double)this.method_31478(), (double)this.method_31479()), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)), (class_1676)this);
                this.method_37908().method_8651(this.method_24515(), false, (class_1297)this);
                return true;
            }
        }
        class_243 pos = this.method_19538();
        class_243 deltaMovement = this.method_18798();
        class_243 scaledDelta = pos.method_1019(deltaMovement.method_1021(0.08));
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(pos, scaledDelta, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (hitResult.method_17783() != class_239.class_240.field_1332) return false;
        class_2680 state = this.method_37908().method_8320(hitResult.method_17777());
        return state.method_26164(NON_COLLIDE);
    }

    private boolean checkLeftOwner() {
        class_1297 owner = this.method_24921();
        if (owner != null) {
            for (class_1297 entity2 : this.method_37908().method_8333((class_1297)this, this.method_5829().method_18804(this.method_18798()).method_1014(1.0), entityx -> !entityx.method_7325() && entityx.method_5863())) {
                if (entity2.method_5668() != owner.method_5668()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canInteract() {
        return this.method_24921() != null;
    }

    @NotNull
    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    public float getBoundingBoxMultiplier() {
        return ((Float)this.field_6011.method_12789(BOUNDING_BOX_MULTIPLIER)).floatValue();
    }

    public void setBoundingBoxMultiplier(float value) {
        this.field_6011.method_12778(BOUNDING_BOX_MULTIPLIER, (Object)Float.valueOf(value));
    }

    public void method_5652(@NotNull class_2487 compound) {
        if (!this.method_31481()) {
            if (this.inBlockState != null) {
                compound.method_10566("inBlockState", (class_2520)class_2512.method_10686((class_2680)this.inBlockState));
            }
            compound.method_10569("aliveTicks", this.aliveTicks);
            if (this.leftOwner) {
                compound.method_10556("LeftOwner", true);
            }
            compound.method_10556("HasBeenShot", this.shot);
            compound.method_10549("originX", this.vecX);
            compound.method_10549("originY", this.vecY);
            compound.method_10549("originZ", this.vecZ);
            compound.method_10556("shotByPlayer", this.shotByPlayer);
            compound.method_10569("bubbles", this.bubbles);
            compound.method_10548("boundingBoxMultiplier", this.getBoundingBoxMultiplier());
            compound.method_10572("hitEntities", (List)this.hitEntities);
            compound.method_10556("canInteractWithPipe", this.canInteractWithPipe);
        }
    }

    public void method_5749(@NotNull class_2487 compound) {
        if (!this.method_31481()) {
            if (compound.method_10573("inBlockState", 10)) {
                this.inBlockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)compound.method_10562("inBlockState"));
            }
            this.aliveTicks = compound.method_10550("aliveTicks");
            this.leftOwner = compound.method_10577("LeftOwner");
            this.shot = compound.method_10577("HasBeenShot");
            this.vecX = compound.method_10574("originX");
            this.vecY = compound.method_10574("originY");
            this.vecZ = compound.method_10574("originZ");
            this.shotByPlayer = compound.method_10577("shotByPlayer");
            this.bubbles = compound.method_10550("bubbles");
            this.setBoundingBoxMultiplier(compound.method_10583("boundingBoxMultiplier"));
            this.hitEntities = IntArrayList.wrap((int[])compound.method_10561("hitEntities"));
            if (compound.method_10545("canInteractWithPipe")) {
                this.canInteractWithPipe = compound.method_10577("canInteractWithPipe");
            }
        }
    }

    public void method_24919(@NotNull class_1297 shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float xRot = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float yRot = -class_3532.method_15374((float)((pitch + roll) * ((float)Math.PI / 180)));
        float zRot = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        this.method_7485(xRot, yRot, zRot, speed, divergence);
        this.vecX = shooter.method_23317();
        this.vecY = shooter.method_23320();
        this.vecZ = shooter.method_23321();
        this.method_7432(shooter);
    }

    protected void method_7488(@NotNull class_239 result) {
        class_239.class_240 type = result.method_17783();
        if (type == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)result;
            if (!this.method_37908().method_8320(blockHitResult.method_17777()).method_26164(NON_COLLIDE)) {
                this.method_24920(blockHitResult);
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    public float getDamage(@Nullable class_1297 entity) {
        int base = entity instanceof class_1657 ? ItemConfig.get().ancientHorn.ancientHornPlayerDamage : ItemConfig.get().ancientHorn.ancientHornMobDamage;
        return (float)base / (this.getBoundingBoxMultiplier() + 1.0f);
    }

    protected float method_7436() {
        return 1.0f;
    }

    public boolean method_5740() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void hitEntity(@NotNull class_1297 entity) {
        class_1282 damageSource;
        class_1937 level = this.method_37908();
        float damage = this.getDamage(entity);
        class_1297 owner = this.method_24921();
        if (entity == owner) return;
        if (owner == null) {
            damageSource = this.method_48923().method_48797(RegisterDamageTypes.ANCIENT_HORN, (class_1297)this, (class_1297)this);
        } else {
            damageSource = this.method_48923().method_48797(RegisterDamageTypes.ANCIENT_HORN, (class_1297)this, owner);
            if (owner instanceof class_1309) {
                class_1309 livingEntity = (class_1309)owner;
                livingEntity.method_6114(entity);
            }
        }
        int fireTicks = entity.method_20802();
        if (this.method_5809()) {
            entity.method_5639(5);
        }
        if (entity instanceof class_7260) {
            class_7260 warden = (class_7260)entity;
            if (owner != null && this.canInteract()) {
                warden.method_42212(owner, class_7253.field_38122.method_42170() + 20, true);
                warden.method_5783(class_3417.field_38078, 5.0f, warden.method_6017());
                this.method_31472();
                return;
            }
        }
        if (entity.method_5864().method_20210(WilderEntityTags.ANCIENT_HORN_IMMUNE)) {
            entity.method_20803(fireTicks);
            if (level.field_9236) return;
            if (!(this.method_18798().method_1027() < 1.0E-7)) return;
            this.method_31472();
            return;
        }
        if (!entity.method_5643(damageSource, damage)) {
            entity.method_20803(fireTicks);
            if (level.field_9236) return;
            if (!(this.method_18798().method_1027() < 1.0E-7)) return;
            this.method_31472();
            return;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (!level.field_9236 && owner instanceof class_1309) {
                class_1309 livingOwner = (class_1309)owner;
                class_1890.method_8210((class_1309)livingEntity, (class_1297)livingOwner);
                class_1890.method_8213((class_1309)livingOwner, (class_1297)livingEntity);
            }
            this.method_7450(livingEntity);
            if (livingEntity.method_29504() && level instanceof class_3218) {
                class_3218 server = (class_3218)level;
                server.method_14199((class_2394)class_2398.field_38002, livingEntity.method_23317(), livingEntity.method_23320(), livingEntity.method_23321(), 1, 0.2, 0.0, 0.2, 0.0);
                this.addCooldown(livingEntity.method_6110() * 10);
            }
        }
        this.method_5783(RegisterSounds.ENTITY_ANCIENT_HORN_PROJECTILE_DISSIPATE, 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
    }

    public void method_5650(@NotNull class_1297.class_5529 reason) {
        this.hitEntities.clear();
        super.method_5650(reason);
    }

    public boolean method_33189() {
        return true;
    }

    public void method_32876(@NotNull class_5712 event) {
    }

    public void method_32875(@NotNull class_5712 event, @Nullable class_1297 entity) {
    }

    public static class EntitySpawnPacket {
        public static class_2596<class_2602> create(@NotNull class_1297 entity, @NotNull class_2960 packetID) {
            if (entity.method_37908().field_9236) {
                throw new IllegalStateException("SpawnPacketUtil.create called on the logical client!");
            }
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.method_10804(class_7923.field_41177.method_10206((Object)entity.method_5864()));
            byteBuf.method_10797(entity.method_5667());
            byteBuf.method_10804(entity.method_5628());
            PacketBufUtil.writeVec3d(byteBuf, entity.method_19538());
            PacketBufUtil.writeAngle(byteBuf, entity.method_36455());
            PacketBufUtil.writeAngle(byteBuf, entity.method_36454());
            return ServerPlayNetworking.createS2CPacket((class_2960)packetID, (class_2540)byteBuf);
        }

        public static final class PacketBufUtil {
            public static byte packAngle(float angle) {
                return (byte)class_3532.method_15375((float)(angle * 256.0f / 360.0f));
            }

            public static float unpackAngle(byte angleByte) {
                return (float)(angleByte * 360) / 256.0f;
            }

            public static void writeAngle(@NotNull class_2540 byteBuf, float angle) {
                byteBuf.writeByte((int)PacketBufUtil.packAngle(angle));
            }

            public static float readAngle(@NotNull class_2540 byteBuf) {
                return PacketBufUtil.unpackAngle(byteBuf.readByte());
            }

            public static void writeVec3d(@NotNull class_2540 byteBuf, @NotNull class_243 vec3d) {
                byteBuf.writeDouble(vec3d.field_1352);
                byteBuf.writeDouble(vec3d.field_1351);
                byteBuf.writeDouble(vec3d.field_1350);
            }

            @NotNull
            public static class_243 readVec3d(@NotNull class_2540 byteBuf) {
                double x = byteBuf.readDouble();
                double y = byteBuf.readDouble();
                double z = byteBuf.readDouble();
                return new class_243(x, y, z);
            }
        }
    }
}

