/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.sound.api.FrozenSoundPackets;
import net.frozenblock.wilderwild.entity.ai.firefly.FireflyAi;
import net.frozenblock.wilderwild.entity.variant.FireflyColor;
import net.frozenblock.wilderwild.item.FireflyBottle;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.registry.RegisterCriteria;
import net.frozenblock.wilderwild.registry.RegisterItems;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.frozenblock.wilderwild.registry.WilderRegistry;
import net.frozenblock.wilderwild.tag.WilderBiomeTags;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Firefly
extends class_1314
implements class_1432 {
    protected static final List<class_4149<? extends class_4148<? super Firefly>>> SENSORS = List.of(class_4149.field_18466);
    protected static final List<class_4140<?>> MEMORY_MODULES = List.of(class_4140.field_18449, class_4140.field_18442, class_4140.field_18445, class_4140.field_19293, class_4140.field_18446, class_4140.field_18438);
    private static final class_2940<Boolean> FROM_BOTTLE = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FLICKERS = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> AGE = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> SCALE = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> PREV_SCALE = class_2945.method_12791(Firefly.class, (class_2941)class_2943.field_13320);
    private static final class_2940<FireflyColor> COLOR = class_2945.method_12791(Firefly.class, FireflyColor.SERIALIZER);
    public boolean natural;
    public boolean hasHome;
    public boolean despawning;
    public int homeCheckCooldown;
    public boolean wasNamedNectar;
    public boolean shouldCheckSpawn = true;

    public Firefly(@NotNull class_1299<? extends Firefly> entityType, @NotNull class_1937 level) {
        super(entityType, level);
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_25418, 0.0f);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.setFlickers(level.field_9229.method_43048(5) == 0);
        this.setFlickerAge(level.field_9229.method_39332(0, 19));
        this.setScale(1.5f);
        this.setColor(FireflyColor.ON);
    }

    public static boolean canSpawn(@NotNull class_1299<Firefly> type, @NotNull class_1936 level, class_3730 reason, @NotNull class_2338 pos, @NotNull class_5819 random) {
        boolean chance = random.method_43051(0, 75) == 0;
        class_6880 biomeHolder = level.method_23753(pos);
        if (biomeHolder.method_40220(WilderBiomeTags.FIREFLY_SPAWNABLE_CAVE)) {
            return chance && level.method_8314(class_1944.field_9284, pos) == 0;
        }
        return chance && (biomeHolder.method_40220(WilderBiomeTags.FIREFLY_SPAWNABLE_DURING_DAY) && level.method_8314(class_1944.field_9284, pos) >= 6 || !level.method_8597().method_29960() && level.method_8594() > 4 && level.method_8311(pos));
    }

    @NotNull
    public static class_5132.class_5133 addAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23719, (double)0.08f).method_26868(class_5134.field_23720, (double)0.08f).method_26868(class_5134.field_23717, 32.0);
    }

    public static boolean isValidHomePos(@NotNull class_1937 level, @NotNull class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (!state.method_26227().method_15769()) {
            return false;
        }
        if (state.method_26212((class_1922)level, pos)) {
            return false;
        }
        return state.method_26215() || !state.method_51366() && !state.method_51367();
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.natural = reason == class_3730.field_16459 || reason == class_3730.field_16472 || reason == class_3730.field_16469 || reason == class_3730.field_16465 || reason == class_3730.field_16462;
        this.hasHome = this.hasHome || !this.natural;
        FireflyAi.rememberHome((class_1309)this, this.method_24515());
        if (reason == class_3730.field_16462) {
            this.setScale(1.5f);
            this.setPrevScale(1.5f);
            this.setColor(FireflyColor.ON);
        }
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    public int method_6130(int currentAir) {
        int newSupply = super.method_6130(currentAir);
        return newSupply == currentAir - 1 ? newSupply - 1 : newSupply;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FROM_BOTTLE, (Object)false);
        this.field_6011.method_12784(FLICKERS, (Object)false);
        this.field_6011.method_12784(AGE, (Object)0);
        this.field_6011.method_12784(SCALE, (Object)Float.valueOf(1.5f));
        this.field_6011.method_12784(PREV_SCALE, (Object)Float.valueOf(1.5f));
        this.field_6011.method_12784(COLOR, (Object)FireflyColor.ON);
    }

    public boolean method_33189() {
        return true;
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        return !this.despawning ? this.tryCapture(player, hand).orElse(super.method_5992(player, hand)) : class_1269.field_5811;
    }

    @NotNull
    public Optional<class_1269> tryCapture(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8469 && this.method_5805()) {
            WilderSharedConstants.log("Firefly capture attempt starting @ " + this.method_24515().method_23854() + " by " + player.method_5476().getString(), WilderSharedConstants.UNSTABLE_LOGGING);
            FireflyColor color = this.getColor();
            Optional optionalItem = class_7923.field_41178.method_17966(new class_2960(color.key().method_12836(), (String)(Objects.equals(color, FireflyColor.ON) ? "firefly_bottle" : color.key().method_12832() + "_firefly_bottle")));
            FireflyBottle item = RegisterItems.FIREFLY_BOTTLE;
            if (optionalItem.isPresent()) {
                item = (class_1792)optionalItem.get();
            }
            this.method_5783(RegisterSounds.ITEM_BOTTLE_CATCH_FIREFLY, 1.0f, this.field_5974.method_43057() * 0.2f + 0.8f);
            if (!player.method_7337()) {
                player.method_5998(hand).method_7934(1);
            }
            class_1799 bottleStack = new class_1799((class_1935)item);
            if (this.method_16914()) {
                bottleStack.method_7977(this.method_5797());
            }
            player.method_31548().method_7398(bottleStack);
            class_1937 level = this.method_37908();
            this.method_31472();
            if (!level.field_9236) {
                RegisterCriteria.FIREFLY_BOTTLE.trigger((class_3222)player, bottleStack);
            }
            return Optional.of(class_1269.method_29236((boolean)level.field_9236));
        }
        return Optional.empty();
    }

    public boolean method_5727(double x, double y, double z) {
        return true;
    }

    public boolean method_5931(@NotNull class_1657 player) {
        return false;
    }

    @NotNull
    protected class_4095.class_5303<Firefly> method_28306() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    @NotNull
    protected class_4095<?> method_18867(@NotNull Dynamic<?> dynamic) {
        return FireflyAi.makeBrain(this, (class_4095<Firefly>)this.method_28306().method_28335(dynamic));
    }

    public boolean isFromBottle() {
        return (Boolean)this.field_6011.method_12789(FROM_BOTTLE);
    }

    public void setFromBottle(boolean value) {
        this.field_6011.method_12778(FROM_BOTTLE, (Object)value);
    }

    public boolean flickers() {
        return (Boolean)this.field_6011.method_12789(FLICKERS);
    }

    public void setFlickers(boolean value) {
        this.field_6011.method_12778(FLICKERS, (Object)value);
    }

    public int getFlickerAge() {
        return (Integer)this.field_6011.method_12789(AGE);
    }

    public void setFlickerAge(int value) {
        this.field_6011.method_12778(AGE, (Object)value);
    }

    public float method_17825() {
        return ((Float)this.field_6011.method_12789(SCALE)).floatValue();
    }

    public void setScale(float value) {
        this.field_6011.method_12778(SCALE, (Object)Float.valueOf(value));
    }

    public float getPrevScale() {
        return ((Float)this.field_6011.method_12789(PREV_SCALE)).floatValue();
    }

    public void setPrevScale(float value) {
        this.field_6011.method_12778(PREV_SCALE, (Object)Float.valueOf(value));
    }

    public FireflyColor getColor() {
        return (FireflyColor)this.field_6011.method_12789(COLOR);
    }

    public void setColor(FireflyColor color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public boolean method_17326() {
        return super.method_17326() || this.isFromBottle();
    }

    public float method_6144(@NotNull class_2338 pos, @NotNull class_4538 level) {
        return 0.0f;
    }

    @NotNull
    public class_4095<Firefly> method_18868() {
        return super.method_18868();
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    public boolean shouldHide() {
        return this.natural && !this.method_37908().method_23753(this.method_24515()).method_40220(WilderBiomeTags.FIREFLY_SPAWNABLE_DURING_DAY) && this.method_37908().method_8530() && this.method_37908().method_8314(class_1944.field_9284, this.method_24515()) >= 6;
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        class_1407 birdNavigation = new class_1407((class_1308)this, level);
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(true);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    public void method_6091(@NotNull class_243 travelVector) {
        if (this.method_6034() || this.method_5787()) {
            if (this.method_5805()) {
                if (this.method_5799()) {
                    this.method_5724(0.01f, travelVector);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021((double)0.8f));
                } else if (this.method_5771()) {
                    this.method_5724(0.01f, travelVector);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021(0.5));
                } else {
                    this.method_5724(this.method_6029(), travelVector);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021((double)0.91f));
                }
            } else {
                super.method_6091(travelVector);
            }
        }
    }

    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
    }

    protected void method_5623(double heightDifference, boolean onGround, @NotNull class_2680 state, @NotNull class_2338 landedPosition) {
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(@NotNull class_1282 source) {
        return RegisterSounds.ENTITY_FIREFLY_HURT;
    }

    protected class_3414 method_6002() {
        return RegisterSounds.ENTITY_FIREFLY_HURT;
    }

    public void method_5773() {
        super.method_5773();
        if (this.shouldCheckSpawn) {
            FireflyColor biomeColor;
            if (!this.isFromBottle() && (biomeColor = FireflyBiomeColorRegistry.getBiomeColor((class_6880<class_1959>)this.method_37908().method_23753(this.method_24515()))) != null) {
                this.setColor(biomeColor);
            }
            this.shouldCheckSpawn = false;
        }
        boolean nectar = this.method_16914() && Objects.requireNonNull(this.method_5797()).getString().toLowerCase().contains("nectar");
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (nectar != this.wasNamedNectar) {
                if (nectar) {
                    FrozenSoundPackets.createMovingRestrictionLoopingSound((class_1937)server, (class_1297)this, (class_3414)RegisterSounds.ENTITY_FIREFLY_NECTAR, (class_3419)class_3419.field_15254, (float)1.0f, (float)1.0f, (class_2960)WilderSharedConstants.id("nectar"), (boolean)true);
                    this.wasNamedNectar = true;
                } else {
                    this.wasNamedNectar = false;
                }
            }
        }
        if (!this.method_5805()) {
            this.method_5875(false);
        }
        this.setFlickerAge(this.getFlickerAge() + 1);
        if (this.hasHome) {
            if (this.homeCheckCooldown > 0) {
                --this.homeCheckCooldown;
            } else {
                this.homeCheckCooldown = 200;
                class_2338 home = FireflyAi.getHome(this);
                if (home != null && FireflyAi.isInHomeDimension(this) && !Firefly.isValidHomePos(this.method_37908(), home)) {
                    FireflyAi.rememberHome((class_1309)this, this.method_24515());
                }
            }
        }
        this.setPrevScale(this.method_17825());
        if (this.despawning) {
            this.setScale(this.method_17825() - 0.5f);
            if (this.method_17825() < 0.0f) {
                this.method_31472();
            }
        } else if (this.method_17825() < 1.5f) {
            this.setScale(Math.min(this.method_17825() + 0.025f, 1.5f));
        }
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("fireflyBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("fireflyActivityUpdate");
        FireflyAi.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public boolean method_18397(@NotNull class_1799 stack) {
        return false;
    }

    public boolean method_5776() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.isFromBottle() && !this.method_16914();
    }

    public void method_5982() {
        if (!this.despawning) {
            if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_23734()) {
                this.despawning = true;
                return;
            }
            if (this.method_5947() || this.method_17326()) {
                this.field_6278 = 0;
                return;
            }
            class_1657 entity = this.method_37908().method_18460((class_1297)this, -1.0);
            if (entity != null) {
                int i;
                int n;
                boolean caveKey;
                double d = entity.method_5858((class_1297)this);
                boolean dayKey = !this.method_37908().method_23753(this.method_24515()).method_40220(WilderBiomeTags.FIREFLY_SPAWNABLE_DURING_DAY) && this.method_37908().method_8530() && !this.method_37908().method_23753(this.method_24515()).method_40220(WilderBiomeTags.FIREFLY_SPAWNABLE_CAVE);
                boolean bl = caveKey = this.method_37908().method_23753(this.method_24515()).method_40220(WilderBiomeTags.FIREFLY_SPAWNABLE_CAVE) && this.method_37908().method_8314(class_1944.field_9284, this.method_24515()) >= 6;
                if (this.method_5974(d) && Math.sqrt(d) > 18.0) {
                    if (dayKey) {
                        this.despawning = true;
                    } else if (caveKey) {
                        this.despawning = true;
                    }
                }
                if (d > (double)(n * (i = this.method_5864().method_5891().method_27919())) && this.method_5974(d)) {
                    this.despawning = true;
                }
                int k = this.method_5864().method_5891().method_27920();
                int l = k * k;
                if (this.field_6278 > 600 && this.field_5974.method_43048(800) == 0 && d > (double)l && this.method_5974(d)) {
                    this.despawning = true;
                } else if (d < (double)l) {
                    this.field_6278 = 0;
                }
            }
        }
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("fromBottle", this.isFromBottle());
        compound.method_10556("natural", this.natural);
        compound.method_10556("flickers", this.flickers());
        compound.method_10569("flickerAge", this.getFlickerAge());
        compound.method_10556("hasHome", this.hasHome);
        compound.method_10548("scale", this.method_17825());
        compound.method_10548("prevScale", this.getPrevScale());
        compound.method_10556("despawning", this.despawning);
        compound.method_10582("color", Objects.requireNonNull(WilderRegistry.FIREFLY_COLOR.method_10221((Object)this.getColor())).toString());
        compound.method_10569("homeCheckCooldown", this.homeCheckCooldown);
        compound.method_10556("wasNamedNectar", this.wasNamedNectar);
        compound.method_10556("shouldCheckSpawn", this.shouldCheckSpawn);
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setFromBottle(compound.method_10577("fromBottle"));
        this.natural = compound.method_10577("natural");
        this.setFlickers(compound.method_10577("flickers"));
        this.setFlickerAge(compound.method_10550("flickerAge"));
        this.hasHome = compound.method_10577("hasHome");
        if (compound.method_10545("scale")) {
            this.setScale(compound.method_10583("scale"));
        }
        if (compound.method_10545("prevScale")) {
            this.setPrevScale(compound.method_10583("prevScale"));
        }
        this.despawning = compound.method_10577("despawning");
        FireflyColor color = (FireflyColor)WilderRegistry.FIREFLY_COLOR.method_10223(class_2960.method_12829((String)compound.method_10558("color")));
        if (color != null) {
            this.setColor(color);
        }
        this.homeCheckCooldown = compound.method_10550("homeCheckCooldown");
        this.wasNamedNectar = compound.method_10577("wasNamedNectar");
        this.shouldCheckSpawn = compound.method_10577("shouldCheckSpawn");
    }

    protected boolean method_43689() {
        return false;
    }

    public boolean method_42149() {
        return false;
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, @NotNull class_1282 source) {
        return false;
    }

    protected void method_6087(@NotNull class_1297 entity) {
    }

    protected void method_6070() {
    }

    public static class FireflyBiomeColorRegistry {
        public static ArrayList<class_2960> BIOMES = new ArrayList();
        public static ArrayList<FireflyColor> COLORS = new ArrayList();

        public static void addBiomeColor(@NotNull class_2960 biome, @NotNull FireflyColor color) {
            BIOMES.add(biome);
            COLORS.add(color);
        }

        public static void addBiomeColor(@NotNull class_5321<class_1959> biome, @NotNull FireflyColor color) {
            FireflyBiomeColorRegistry.addBiomeColor(biome.method_29177(), color);
        }

        @Nullable
        public static FireflyColor getBiomeColor(@NotNull class_6880<class_1959> biomeEntry) {
            ArrayList<FireflyColor> colors = new ArrayList<FireflyColor>();
            for (int i = 0; i < BIOMES.size(); ++i) {
                class_2960 biomeID = BIOMES.get(i);
                if (!biomeEntry.method_40226(biomeID)) continue;
                colors.add(COLORS.get(i));
            }
            if (colors.isEmpty()) {
                return null;
            }
            return (FireflyColor)colors.get(AdvancedMath.random().method_43048(colors.size()));
        }
    }
}

