/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.frozenblock.lib.entity.api.NoFlopAbstractFish;
import net.frozenblock.wilderwild.entity.ai.jellyfish.JellyfishAi;
import net.frozenblock.wilderwild.entity.ai.jellyfish.JellyfishTemptGoal;
import net.frozenblock.wilderwild.entity.variant.JellyfishVariant;
import net.frozenblock.wilderwild.misc.server.EasyPacket;
import net.frozenblock.wilderwild.registry.RegisterEntities;
import net.frozenblock.wilderwild.registry.RegisterItems;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.frozenblock.wilderwild.registry.WilderRegistry;
import net.frozenblock.wilderwild.tag.WilderBiomeTags;
import net.frozenblock.wilderwild.tag.WilderEntityTags;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jellyfish
extends NoFlopAbstractFish {
    public static final ArrayList<JellyfishVariant> COLORED_VARIANTS = new ArrayList(WilderRegistry.JELLYFISH_VARIANT.method_10220().filter(JellyfishVariant::isNormal).collect(Collectors.toList()));
    public static final ArrayList<JellyfishVariant> PEARLESCENT_VARIANTS = new ArrayList(WilderRegistry.JELLYFISH_VARIANT.method_10220().filter(JellyfishVariant::pearlescent).collect(Collectors.toList()));
    private static final float MAX_TARGET_DISTANCE = 15.0f;
    private static final class_2940<JellyfishVariant> VARIANT = class_2945.method_12791(Jellyfish.class, JellyfishVariant.SERIALIZER);
    private static final class_2940<Boolean> CAN_REPRODUCE = class_2945.method_12791(Jellyfish.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_BABY = class_2945.method_12791(Jellyfish.class, (class_2941)class_2943.field_13323);
    public final class_4051 targetingConditions = class_4051.method_36626().method_18424().method_36627().method_18420(this::canTargetEntity);
    private static final Map<class_5425, Integer> NON_PEARLESCENT_JELLYFISH_PER_LEVEL = new HashMap<class_5425, Integer>();
    public float xBodyRot;
    public float xRot1;
    public float xRot2;
    public float xRot3;
    public float xRot4;
    public float xRot5;
    public float xRot6;
    public boolean vanishing;
    public boolean growing;
    public float prevScale = 1.0f;
    public float scale = 1.0f;
    public int ticksSinceSpawn;
    public int age;
    public int fullness;
    public int reproductionCooldown;
    private int forcedAge;
    private int forcedAgeTimer;

    public Jellyfish(@NotNull class_1299<? extends Jellyfish> entityType, @NotNull class_1937 level) {
        super(entityType, level);
        this.method_5942().method_6354(false);
    }

    public static int getJellyfish(@NotNull class_3218 level, boolean pearlescent) {
        AtomicInteger count = new AtomicInteger();
        if (!NON_PEARLESCENT_JELLYFISH_PER_LEVEL.containsKey(level)) {
            level.field_26935.method_31841().method_31803().forEach(entity -> {
                if (entity instanceof Jellyfish) {
                    Jellyfish jellyfish = (Jellyfish)((Object)entity);
                    if (pearlescent ? jellyfish.getVariant().pearlescent() : jellyfish.getVariant().isNormal()) {
                        count.addAndGet(1);
                    }
                }
            });
            NON_PEARLESCENT_JELLYFISH_PER_LEVEL.put((class_5425)level, count.get());
        } else {
            count.set(NON_PEARLESCENT_JELLYFISH_PER_LEVEL.get(level));
        }
        return count.get();
    }

    public static void clearLevelToNonPearlescentCount() {
        NON_PEARLESCENT_JELLYFISH_PER_LEVEL.clear();
    }

    public static boolean canSpawn(@NotNull class_1299<Jellyfish> type, @NotNull class_5425 level, @NotNull class_3730 reason, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (reason == class_3730.field_16469) {
            return true;
        }
        class_6880 biome = level.method_23753(pos);
        if (biome.method_40220(WilderBiomeTags.PEARLESCENT_JELLYFISH) || Jellyfish.getJellyfish(level.method_8410(), false) >= type.method_5891().method_6134() / 3) {
            return false;
        }
        if (biome.method_40220(WilderBiomeTags.JELLYFISH_SPECIAL_SPAWN) && level.method_22335(pos, 0) <= 7 && random.method_43051(0, level.method_22335(pos, 0) + 3) >= 1) {
            return true;
        }
        int seaLevel = level.method_8615();
        return random.method_43051(0, 110) == 0 && pos.method_10264() <= seaLevel && pos.method_10264() >= seaLevel - 13;
    }

    @NotNull
    public static class_5132.class_5133 addAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23717, 15.0);
    }

    public static void spawnFromChest(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2338 pos) {
        Jellyfish jellyfish = new Jellyfish(RegisterEntities.JELLYFISH, level);
        jellyfish.setVariantFromPos(level, pos);
        double additionalX = 0.0;
        double additionalZ = 0.0;
        if (state.method_28498((class_2769)class_2741.field_12506) && state.method_11654((class_2769)class_2741.field_12506) != class_2745.field_12569) {
            class_2350 direction = class_2281.method_9758((class_2680)state);
            additionalX += (double)direction.method_10148() * 0.25;
            additionalZ += (double)direction.method_10165() * 0.25;
        }
        jellyfish.method_5814((double)pos.method_10263() + 0.5 + additionalX, (double)pos.method_10264() + 0.75, (double)pos.method_10260() + 0.5 + additionalZ);
        jellyfish.method_18800(0.0, 0.1 + level.field_9229.method_43058() * 0.07, 0.0);
        jellyfish.prevScale = 0.0f;
        jellyfish.scale = 0.0f;
        level.method_8649((class_1297)jellyfish);
        level.method_8421((class_1297)jellyfish, (byte)5);
    }

    public static int getSpeedUpSecondsWhenFeeding(int ticksUntilAdult) {
        return (int)((float)(ticksUntilAdult / 20) * 0.1f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(3, (class_1352)new JellyfishTemptGoal(this, 1.25));
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        JellyfishGroupData jellyfishGroupData;
        if (spawnData instanceof JellyfishGroupData) {
            JellyfishGroupData jellyGroupData = (JellyfishGroupData)spawnData;
            this.setVariant(jellyGroupData.variant);
            jellyfishGroupData = jellyGroupData;
        } else {
            jellyfishGroupData = new JellyfishGroupData(true, this.setVariant((class_6880<class_1959>)level.method_23753(this.method_24515()), level.method_8409()));
            spawnData = jellyfishGroupData;
        }
        if (jellyfishGroupData.isShouldSpawnBaby() && level.method_8409().method_43057() <= jellyfishGroupData.getBabySpawnChance()) {
            this.method_7217(true);
        }
        jellyfishGroupData.increaseGroupSizeByOne();
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    public void setVariantFromPos(@NotNull class_1937 level, @NotNull class_2338 pos) {
        this.setVariant((class_6880<class_1959>)level.method_23753(pos), level.method_8409());
    }

    @NotNull
    private JellyfishVariant setVariant(@NotNull class_6880<class_1959> biome, class_5819 randomSource) {
        this.setVariant(JellyfishVariant.PINK);
        if (biome.method_40220(WilderBiomeTags.PEARLESCENT_JELLYFISH) && !PEARLESCENT_VARIANTS.isEmpty()) {
            this.setVariant(PEARLESCENT_VARIANTS.get(randomSource.method_43048(PEARLESCENT_VARIANTS.size())));
        } else if (!COLORED_VARIANTS.isEmpty()) {
            this.setVariant(COLORED_VARIANTS.get(randomSource.method_43048(COLORED_VARIANTS.size())));
        }
        return this.getVariant();
    }

    public void method_5674(@NotNull class_2940<?> key) {
        if (IS_BABY.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    protected float method_18394(@NotNull class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 * 0.5f;
    }

    protected class_3414 method_5994() {
        return this.method_5816() ? RegisterSounds.ENTITY_JELLYFISH_AMBIENT_WATER : null;
    }

    @NotNull
    protected class_3414 method_5737() {
        return RegisterSounds.ENTITY_JELLYFISH_SWIM;
    }

    protected void method_5734(float volume) {
        super.method_5734(volume);
        if (this.field_5974.method_43057() < 0.5f) {
            this.spawnBubbles();
        }
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return this.method_5816() ? RegisterSounds.ENTITY_JELLYFISH_HURT_WATER : RegisterSounds.ENTITY_JELLYFISH_HURT;
    }

    protected class_3414 method_6002() {
        return this.method_5816() ? RegisterSounds.ENTITY_JELLYFISH_DEATH_WATER : RegisterSounds.ENTITY_JELLYFISH_DEATH;
    }

    public boolean method_5931(@NotNull class_1657 player) {
        return !this.method_5934();
    }

    protected float method_6107() {
        return 0.4f;
    }

    @NotNull
    public class_4095.class_5303<Jellyfish> method_28306() {
        return class_4095.method_28311(JellyfishAi.MEMORY_TYPES, JellyfishAi.SENSOR_TYPES);
    }

    @NotNull
    protected class_4095<Jellyfish> method_18867(@NotNull Dynamic<?> dynamic) {
        return JellyfishAi.makeBrain(this, (class_4095<Jellyfish>)this.method_28306().method_28335(dynamic));
    }

    @NotNull
    public class_4095<Jellyfish> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_18868().method_18904(class_4140.field_22355).orElse(null);
    }

    public void setAttackTarget(class_1309 entity) {
        this.method_18868().method_18878(class_4140.field_22355, (Object)entity);
    }

    public void method_6007() {
        this.prevScale = this.scale;
        super.method_6007();
        this.xRot6 = this.xRot5;
        this.xRot5 = this.xRot4;
        this.xRot4 = this.xRot3;
        this.xRot3 = this.xRot2;
        this.xRot2 = this.xRot1;
        this.xRot1 = this.xBodyRot;
        ++this.ticksSinceSpawn;
        if (this.method_5816()) {
            this.method_6025(0.02f);
            class_243 vec3 = this.method_18798();
            if (vec3.method_37267() > 0.005) {
                this.field_6283 += (float)((-class_3532.method_15349((double)vec3.field_1352, (double)vec3.field_1350) * 57.2957763671875 - (double)this.field_6283) * (double)0.1f);
                this.method_36456(this.field_6283);
            }
            this.xBodyRot += (float)((-class_3532.method_15349((double)vec3.method_37267(), (double)vec3.field_1351) * 57.2957763671875 - (double)this.xBodyRot) * (double)0.1f);
        } else {
            this.xBodyRot += (-90.0f - this.xBodyRot) * 0.02f;
        }
        this.stingEntities();
        class_1309 target = this.method_5968();
        if (target != null) {
            this.method_5942().method_6340();
            this.moveToAccurate((class_1297)target, 2.0);
        }
        if (this.growing) {
            if (this.scale < 1.0f) {
                this.scale += 0.5f;
            } else {
                this.scale = 1.0f;
                this.growing = false;
            }
        } else if (this.vanishing) {
            if (this.prevScale <= 0.0f) {
                this.method_31472();
                this.method_5783(RegisterSounds.ENTITY_JELLYFISH_HIDE, 0.8f, 0.9f + this.method_37908().field_9229.method_43057() * 0.2f);
            } else {
                this.scale -= 0.25f;
            }
        }
        if (this.method_37908().field_9236) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.method_5805()) {
            int i = this.getAge();
            if (i < 0) {
                this.setAge(++i);
            } else if (i > 0) {
                this.setAge(--i);
            }
        }
        this.reproductionCooldown = Math.max(0, this.reproductionCooldown - 1);
        this.setCanReproduce(this.reproductionCooldown == 0 && this.method_5816() && this.method_5869() && !this.vanishing && !this.growing && !this.method_6109() && this.method_5805() && !this.method_31481());
        class_1324 attributeInstance = this.method_6127().method_26842(class_5134.field_23719);
        if (attributeInstance != null) {
            attributeInstance.method_6192(this.method_6109() ? 0.25 : 0.5);
        }
    }

    public void method_5711(byte id) {
        if (id == 4) {
            this.vanishing = true;
        } else if (id == 5) {
            this.growing = true;
            this.scale = 0.0f;
            this.prevScale = 0.0f;
        } else if (id == 7) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        } else if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(id);
        }
    }

    public void stingEntities() {
        if (this.method_5805()) {
            List list = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(0.08));
            boolean baby = this.method_6109();
            float damage = baby ? 1.0f : 3.0f;
            int poisonDuration = baby ? this.method_37908().field_9229.method_43051(40, 100) : this.method_37908().field_9229.method_43051(100, 200);
            for (class_1309 entity : list) {
                class_1308 mob;
                if (!this.targetingConditions.method_18419((class_1309)this, entity)) continue;
                if (entity instanceof class_3222) {
                    class_3222 player = (class_3222)entity;
                    if (!player.method_5643(this.method_48923().method_48812((class_1309)this), damage)) continue;
                    player.method_37222(new class_1293(class_1294.field_5899, poisonDuration, 0, false, false), (class_1297)this);
                    EasyPacket.sendJellySting(player, baby);
                    continue;
                }
                if (!(entity instanceof class_1308) || !(mob = (class_1308)entity).method_5643(this.method_48923().method_48812((class_1309)this), damage)) continue;
                mob.method_37222(new class_1293(class_1294.field_5899, poisonDuration, 0), (class_1297)this);
                this.method_5783(RegisterSounds.ENTITY_JELLYFISH_STING, 0.4f, this.field_5974.method_43057() * 0.2f + (baby ? 1.2f : 0.9f));
            }
        }
    }

    protected void method_18249(@NotNull class_1657 player, @NotNull class_1308 child) {
        if (child instanceof Jellyfish) {
            Jellyfish jellyfish = (Jellyfish)child;
            jellyfish.setVariant(this.getVariant());
        }
    }

    public void moveToAccurate(@NotNull class_1297 entity, double speed) {
        class_11 path = this.method_5942().method_6349(entity, 0);
        if (path != null) {
            this.method_5942().method_6334(path, speed);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable class_1297 entity) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_37908() != livingEntity.method_37908()) return false;
        if (!class_1301.field_6156.test(livingEntity)) return false;
        if (this.method_5722((class_1297)livingEntity)) return false;
        if (livingEntity.method_5864() == class_1299.field_6131) return false;
        if (livingEntity.method_5864() == RegisterEntities.JELLYFISH) return false;
        if (livingEntity.method_5655()) return false;
        if (livingEntity.method_29504()) return false;
        if (livingEntity.method_31481()) return false;
        if (!(livingEntity.method_5739((class_1297)this) < 15.0f)) return false;
        if (livingEntity.method_5864().method_20210(WilderEntityTags.JELLYFISH_CANT_STING)) return false;
        if (!this.method_37908().method_8621().method_11966(livingEntity.method_5829())) return false;
        return true;
    }

    protected void method_5958() {
        class_3218 serverLevel = (class_3218)this.method_37908();
        serverLevel.method_16107().method_15396("jellyfishBrain");
        this.method_18868().method_19542(serverLevel, (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("jellyfishActivityUpdate");
        JellyfishAi.updateActivity(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public boolean shouldHide() {
        return this.method_37908().method_18460((class_1297)this, 24.0) == null && this.ticksSinceSpawn >= 150 && !this.method_17326() && !this.method_5947() && !this.method_16914() && !this.method_5934() && this.method_5685().isEmpty() && this.method_5968() == null && this.field_5974.method_43051(0, 50) <= 2;
    }

    @NotNull
    public class_3414 method_35171() {
        return RegisterSounds.ITEM_BUCKET_FILL_JELLYFISH;
    }

    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8705)) {
            return super.method_5992(player, hand);
        }
        if (!itemStack.method_31573(this.getVariant().reproductionFood())) {
            return class_1269.field_5811;
        }
        if (this.method_6109()) {
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.ageUp(Jellyfish.getSpeedUpSecondsWhenFeeding(-this.getAge()), true);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.canReproduce()) {
            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                ++this.fullness;
                this.ticksSinceSpawn = 0;
                if (this.fullness >= 8 && this.field_5974.method_43048(3) == 0) {
                    this.spawnChild(serverLevel);
                    this.fullness = 0;
                    this.method_37908().method_8421((class_1297)this, (byte)18);
                    this.reproductionCooldown = 6000;
                    this.setCanReproduce(false);
                    return class_1269.field_5812;
                }
                this.method_37908().method_8421((class_1297)this, (byte)7);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public void spawnChild(class_3218 level) {
        Jellyfish jellyfish = (Jellyfish)RegisterEntities.JELLYFISH.method_5883((class_1937)level);
        if (jellyfish == null) {
            return;
        }
        jellyfish.method_7217(true);
        float bbHeight = this.method_17682();
        class_243 vec3 = this.rotateVector(new class_243(0.0, (double)(-bbHeight), 0.0)).method_1031(this.method_23317(), this.method_23318(), this.method_23321());
        jellyfish.method_5808(vec3.field_1352, vec3.field_1351 + (double)bbHeight * 0.5, vec3.field_1350, -this.method_36454(), -this.method_36455());
        jellyfish.method_18799(this.method_18798().method_1021(-0.5));
        jellyfish.setVariant(this.getVariant());
        level.method_8421((class_1297)this, (byte)18);
        if (level.method_8450().method_8355(class_1928.field_19391)) {
            level.method_8649((class_1297)new class_1303((class_1937)level, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6051().method_43048(7) + 1));
        }
        level.method_30771((class_1297)jellyfish);
    }

    @NotNull
    private class_243 rotateVector(@NotNull class_243 vector) {
        class_243 vec3 = vector.method_1037(this.xRot1 * ((float)Math.PI / 180));
        vec3 = vec3.method_1024(-this.field_6220 * ((float)Math.PI / 180));
        return vec3;
    }

    private void spawnBubbles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (!this.method_6109()) {
                double deltaLength = this.method_18798().method_1033();
                float bbHeight = this.method_17682();
                class_243 vec3 = this.rotateVector(new class_243(0.0, (double)(-bbHeight), 0.0)).method_1031(this.method_23317(), this.method_23318(), this.method_23321());
                for (int i = 0; i < this.field_5974.method_43051(0, (int)(2.0 + deltaLength * 25.0)); ++i) {
                    class_243 vec32 = this.rotateVector(new class_243((double)this.field_5974.method_43057() * 0.6 - 0.3, -1.0, (double)this.field_5974.method_43057() * 0.6 - 0.3));
                    class_243 vec33 = vec32.method_1021(0.3 + (double)(this.field_5974.method_43057() * 2.0f));
                    serverLevel.method_14199((class_2394)class_2398.field_11247, vec3.field_1352, vec3.field_1351 + (double)bbHeight * 0.5, vec3.field_1350, 0, vec33.field_1352, vec33.field_1351, vec33.field_1350, deltaLength * 2.0 + 0.1);
                }
            }
        }
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (super.method_5643(source, amount)) {
            class_1309 target;
            if (!this.method_37908().field_9236 && this.method_37908().method_8407() != class_1267.field_5801 && !this.method_5987() && this.field_18321.method_18904(class_4140.field_22355).isEmpty() && this.canTargetEntity((class_1297)(target = this.method_6065()))) {
                this.setAttackTarget(target);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public class_2960 method_5991() {
        class_2960 resourceLocation = class_7923.field_41177.method_10221(RegisterEntities.JELLYFISH);
        return new class_2960(this.getVariant().key().method_12836(), "entities/" + resourceLocation.method_12832() + "_" + this.getVariant().key().method_12832());
    }

    @NotNull
    public class_1799 method_6452() {
        return new class_1799((class_1935)RegisterItems.JELLYFISH_BUCKET);
    }

    @NotNull
    public JellyfishVariant getVariant() {
        return (JellyfishVariant)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(@NotNull JellyfishVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public boolean canReproduce() {
        return (Boolean)this.field_6011.method_12789(CAN_REPRODUCE);
    }

    public void setCanReproduce(boolean bl) {
        this.field_6011.method_12778(CAN_REPRODUCE, (Object)bl);
    }

    public boolean isRGB() {
        String name = this.method_5477().getString();
        return this.method_16914() && (name.equalsIgnoreCase("I_am_Merp") || name.equals("AroundTheWorld"));
    }

    public void ageUp(int amount, boolean forced) {
        int i;
        int j = i = this.getAge();
        if ((i += amount * 20) > 0) {
            i = 0;
        }
        int k = i - j;
        this.setAge(i);
        if (forced) {
            this.forcedAge += k;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int amount) {
        this.ageUp(amount, false);
    }

    public int getAge() {
        if (this.method_37908().field_9236) {
            return (Boolean)this.field_6011.method_12789(IS_BABY) != false ? -1 : 1;
        }
        return this.age;
    }

    public void setAge(int age) {
        int i = this.getAge();
        this.age = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.field_6011.method_12778(IS_BABY, (Object)(age < 0 ? 1 : 0));
            this.ageBoundaryReached();
        }
    }

    public void ageBoundaryReached() {
        class_1690 boat;
        class_1297 class_12972;
        if (!this.method_6109() && this.method_5765() && (class_12972 = this.method_5854()) instanceof class_1690 && !(boat = (class_1690)class_12972).method_49182((class_1297)this)) {
            this.method_5848();
        }
    }

    public boolean method_6109() {
        return this.getAge() < 0;
    }

    public void method_7217(boolean baby) {
        this.setAge(baby ? -24000 : 0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)JellyfishVariant.PINK);
        this.field_6011.method_12784(CAN_REPRODUCE, (Object)false);
        this.field_6011.method_12784(IS_BABY, (Object)false);
    }

    public void method_6455(@NotNull class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        class_2487 compoundTag = stack.method_7948();
        compoundTag.method_10582("variant", Objects.requireNonNull(WilderRegistry.JELLYFISH_VARIANT.method_10221((Object)this.getVariant())).toString());
        compoundTag.method_10556("canReproduce", this.canReproduce());
        compoundTag.method_10569("fullness", this.fullness);
        compoundTag.method_10569("reproductionCooldown", this.reproductionCooldown);
        compoundTag.method_10569("age", this.getAge());
        compoundTag.method_10569("forcedAge", this.forcedAge);
        compoundTag.method_10556("isBaby", this.method_6109());
    }

    public void method_35170(@NotNull class_2487 tag) {
        JellyfishVariant variant;
        class_5761.method_35168((class_1308)this, (class_2487)tag);
        if (tag.method_10545("variant") && (variant = (JellyfishVariant)WilderRegistry.JELLYFISH_VARIANT.method_10223(class_2960.method_12829((String)tag.method_10558("variant")))) != null) {
            this.setVariant(variant);
        }
        if (tag.method_10545("canReproduce")) {
            this.setCanReproduce(tag.method_10577("canReproduce"));
        }
        this.fullness = tag.method_10550("fullness");
        this.reproductionCooldown = tag.method_10550("reproductionCooldown");
        this.setAge(tag.method_10550("age"));
        this.forcedAge = tag.method_10550("forcedAge");
        this.method_7217(tag.method_10577("isBaby"));
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("variant", Objects.requireNonNull(WilderRegistry.JELLYFISH_VARIANT.method_10221((Object)this.getVariant())).toString());
        compound.method_10569("ticksSinceSpawn", this.ticksSinceSpawn);
        compound.method_10556("canReproduce", this.canReproduce());
        compound.method_10569("fullness", this.fullness);
        compound.method_10569("reproductionCooldown", this.reproductionCooldown);
        compound.method_10569("age", this.getAge());
        compound.method_10569("forcedAge", this.forcedAge);
        compound.method_10556("isBaby", this.method_6109());
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        JellyfishVariant variant = (JellyfishVariant)WilderRegistry.JELLYFISH_VARIANT.method_10223(class_2960.method_12829((String)compound.method_10558("variant")));
        if (variant != null) {
            this.setVariant(variant);
        }
        this.ticksSinceSpawn = compound.method_10550("ticksSinceSpawn");
        if (compound.method_10545("canReproduce")) {
            this.setCanReproduce(compound.method_10577("canReproduce"));
        }
        this.fullness = compound.method_10550("fullness");
        this.reproductionCooldown = compound.method_10550("reproductionCooldown");
        this.setAge(compound.method_10550("age"));
        this.forcedAge = compound.method_10550("forcedAge");
        this.method_7217(compound.method_10577("isBaby"));
    }

    public static class JellyfishGroupData
    implements class_1315 {
        private final boolean shouldSpawnBaby;
        private final float babySpawnChance;
        private final JellyfishVariant variant;
        private int groupSize;

        private JellyfishGroupData(boolean shouldSpawnBaby, float babySpawnChance, JellyfishVariant variant) {
            this.shouldSpawnBaby = shouldSpawnBaby;
            this.babySpawnChance = babySpawnChance;
            this.variant = variant;
        }

        public JellyfishGroupData(boolean shouldSpawnBaby, JellyfishVariant variant) {
            this(shouldSpawnBaby, 0.15f, variant);
        }

        public JellyfishGroupData(float babySpawnChance, JellyfishVariant variant) {
            this(true, babySpawnChance, variant);
        }

        public int getGroupSize() {
            return this.groupSize;
        }

        public void increaseGroupSizeByOne() {
            ++this.groupSize;
        }

        public boolean isShouldSpawnBaby() {
            return this.shouldSpawnBaby;
        }

        public float getBabySpawnChance() {
            return this.babySpawnChance;
        }
    }
}

