/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import java.util.List;
import net.frozenblock.lib.entity.impl.EntityStepOnBlockInterface;
import net.frozenblock.lib.tag.api.TagUtils;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.wilderwild.block.MesogleaBlock;
import net.frozenblock.wilderwild.config.EntityConfig;
import net.frozenblock.wilderwild.registry.RegisterBlocks;
import net.frozenblock.wilderwild.registry.RegisterDamageTypes;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.frozenblock.wilderwild.tag.WilderBlockTags;
import net.frozenblock.wilderwild.tag.WilderItemTags;
import net.minecraft.class_1262;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tumbleweed
extends class_1308
implements EntityStepOnBlockInterface {
    private static final double windMultiplier = 1.4;
    private static final double windClamp = 0.2;
    private static final float rotationAmount = 55.0f;
    private static final class_2940<class_1799> ITEM_STACK = class_2945.method_12791(Tumbleweed.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Float> ITEM_X = class_2945.method_12791(Tumbleweed.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ITEM_Z = class_2945.method_12791(Tumbleweed.class, (class_2941)class_2943.field_13320);
    private static final float maxItemOffset = 0.25f;
    public class_2371<class_1799> inventory;
    public boolean spawnedFromShears;
    public int ticksSinceActive;
    public boolean isItemNatural;
    public boolean isTouchingStickingBlock;
    public boolean isTouchingStoppingBlock;
    public float prevPitch;
    public float prevRoll;
    public float pitch;
    public float roll;
    public float prevTumble;
    public float tumble;
    public float itemX;
    public float itemZ;
    private float lookRot;

    public Tumbleweed(@NotNull class_1299<Tumbleweed> entityType, @NotNull class_1937 level) {
        super(entityType, level);
        this.field_23807 = true;
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    }

    public static boolean canSpawn(class_1299<Tumbleweed> type, @NotNull class_5425 level, class_3730 reason, @NotNull class_2338 pos, @NotNull class_5819 random) {
        return level.method_8314(class_1944.field_9284, pos) > 7 && random.method_43051(0, 60) == 1 && pos.method_10264() > level.method_8615();
    }

    @NotNull
    public static class_5132.class_5133 addAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0);
    }

    public static boolean isSilkTouchOrShears(@NotNull class_1282 damageSource) {
        class_1297 class_12972 = damageSource.method_5526();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            class_1799 stack = player.method_6047();
            return class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) > 0 || stack.method_31574(class_1802.field_8868);
        }
        return false;
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        if (((class_1799)this.inventory.get(0)).method_7960() && reason == class_3730.field_16459) {
            int diff = difficulty.method_5454().method_5461();
            if (level.method_8409().method_43051(0, diff == 0 ? 32 : 27 / diff) == 0) {
                int tagSelector = level.method_8409().method_43051(1, 6);
                class_6862<class_1792> itemTag = tagSelector <= 1 ? WilderItemTags.TUMBLEWEED_RARE : (tagSelector <= 3 ? WilderItemTags.TUMBLEWEED_MEDIUM : WilderItemTags.TUMBLEWEED_COMMON);
                class_1935 itemLike = (class_1935)TagUtils.getRandomEntry((class_5819)level.method_8409(), itemTag);
                if (itemLike != null) {
                    this.setItem(new class_1799(itemLike), true);
                }
            } else if (level.method_8409().method_43051(0, 15) == 0) {
                this.setItem(new class_1799((class_1935)RegisterBlocks.TUMBLEWEED_PLANT), true);
            }
        }
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    protected void method_6087(@NotNull class_1297 entity) {
        boolean isSmall;
        boolean bl = isSmall = entity.method_5829().method_995() < this.method_5829().method_995() * 0.9;
        if (entity instanceof Tumbleweed) {
            super.method_6087(entity);
        }
        double d = this.getDeltaPos().method_1033();
        double d2 = isSmall ? 0.2 : 0.3;
        if (d > d2 && this.isMovingTowards(entity) && !(entity instanceof Tumbleweed)) {
            boolean hurt = entity.method_5643(this.method_48923().method_48796(RegisterDamageTypes.TUMBLEWEED, (class_1297)this), 2.0f);
            boolean bl2 = isSmall = isSmall || !entity.method_5805() || !hurt;
            if (!isSmall) {
                this.destroy(false);
            }
        }
    }

    protected void method_16080(@NotNull class_1282 damageSource) {
        if (!Tumbleweed.isSilkTouchOrShears(damageSource)) {
            super.method_16080(damageSource);
        }
    }

    protected void method_5622(@NotNull class_2680 state) {
        if (state.method_26204() instanceof class_2397) {
            this.isTouchingStickingBlock = true;
        }
    }

    public void method_5773() {
        class_1937 class_19372;
        if (this.isTouchingStickingBlock) {
            this.method_18799(class_243.field_1353);
            this.isTouchingStickingBlock = false;
        }
        this.isTouchingStoppingBlock = false;
        if (!this.method_37908().field_9236 && this.method_36601().method_26164(class_3481.field_20341) && this.method_37908().method_8450().method_8355(class_1928.field_19388) && !this.method_24828() && EntityConfig.get().tumbleweed.tumbleweedDestroysCrops) {
            this.method_37908().method_8651(this.method_24515(), true, (class_1297)this);
        }
        super.method_5773();
        class_243 deltaPos = this.getDeltaPos();
        this.setAngles(deltaPos);
        if (this.method_37908().field_9236) {
            this.itemX = this.getItemX();
            this.itemZ = this.getItemZ();
        } else if (!this.method_31481() && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.method_6025(1.0f);
            double brightness = this.method_37908().method_8314(class_1944.field_9284, class_2338.method_49638((class_2374)this.method_33571()));
            this.checkActive(brightness);
            this.moveWithWind(serverLevel, brightness, deltaPos);
            this.tickAfterWindLeash();
            this.pickupItem();
        }
    }

    public void setAngles(@NotNull class_243 deltaPos) {
        if (deltaPos.method_37267() > 0.01) {
            this.lookRot = -((float)class_3532.method_15349((double)deltaPos.field_1352, (double)deltaPos.field_1350)) * 57.295776f;
        }
        float yRot = this.method_36454();
        yRot += (this.lookRot - yRot) * 0.25f;
        this.method_36456(yRot);
        this.field_6283 = yRot;
        this.prevPitch = this.pitch;
        this.prevRoll = this.roll;
        this.prevTumble = this.tumble;
        float yRotAmount = (float)(Math.abs(deltaPos.field_1351) * 0.5 * 55.0);
        this.pitch -= (float)(deltaPos.field_1350 * 55.0);
        this.roll -= (float)(deltaPos.field_1352 * 55.0);
        this.pitch += yRotAmount;
        this.roll += yRotAmount;
        this.tumble += (float)((Math.abs(deltaPos.field_1350) + Math.abs(deltaPos.field_1352) + Math.abs(deltaPos.field_1352) * 0.5) * 0.5 * 55.0);
        if (this.pitch > 360.0f) {
            this.pitch -= 360.0f;
            this.prevPitch -= 360.0f;
        } else if (this.pitch < 0.0f) {
            this.pitch += 360.0f;
            this.prevPitch += 360.0f;
        }
        if (this.roll > 360.0f) {
            this.roll -= 360.0f;
            this.prevRoll -= 360.0f;
        } else if (this.roll < 0.0f) {
            this.roll += 360.0f;
            this.prevRoll += 360.0f;
        }
        if (this.tumble > 360.0f) {
            this.tumble -= 360.0f;
            this.prevTumble -= 360.0f;
        } else if (this.tumble < 0.0f) {
            this.tumble += 360.0f;
            this.prevTumble += 360.0f;
        }
    }

    private void checkActive(double brightness) {
        class_1657 entity = this.method_37908().method_18460((class_1297)this, -1.0);
        if (!this.method_17326() && (brightness < 7.0 && (entity == null || entity.method_5739((class_1297)this) > 24.0f) || this.isTouchingStoppingBlock || this.isTouchingStickingBlock || this.field_5957 && !(this.method_36601().method_26204() instanceof MesogleaBlock))) {
            ++this.ticksSinceActive;
            if (this.ticksSinceActive >= 200) {
                this.destroy(false);
            }
        } else {
            this.ticksSinceActive = 0;
        }
    }

    private void moveWithWind(@NotNull class_3218 serverLevel, double brightness, @NotNull class_243 deltaPos) {
        if (!this.isTouchingStoppingBlock && !this.isTouchingStickingBlock) {
            class_243 deltaMovement = this.method_18798();
            WindManager windManager = WindManager.getWindManager((class_3218)serverLevel);
            double multiplier = Math.max(brightness - Math.max(15.0 - brightness, 0.0), 0.0) * 0.0667 * (this.field_5957 ? 0.16777216 : 1.0);
            double windX = class_3532.method_15350((double)(windManager.windX * 1.4), (double)-0.2, (double)0.2);
            double windZ = class_3532.method_15350((double)(windManager.windZ * 1.4), (double)-0.2, (double)0.2);
            deltaMovement = deltaMovement.method_1031(windX * 0.2 * multiplier, 0.0, windZ * 0.2 * multiplier);
            deltaMovement = new class_243(deltaMovement.field_1352, deltaMovement.field_1351 < 0.0 ? deltaMovement.field_1351 * 0.88 : deltaMovement.field_1351, deltaMovement.field_1350);
            if (deltaPos.field_1351 <= 0.0 && this.method_24828()) {
                deltaMovement = deltaMovement.method_1031(0.0, Math.min(0.65, deltaPos.method_37267() * 1.2) * multiplier, 0.0);
            }
            if (deltaPos.field_1352 == 0.0) {
                double nonNegX = deltaMovement.field_1352 < 0.0 ? -deltaMovement.field_1352 : deltaMovement.field_1352;
                deltaMovement = deltaMovement.method_1031(0.0, nonNegX * 1.8 * multiplier, 0.0);
            }
            if (deltaPos.field_1350 == 0.0) {
                double nonNegZ = deltaMovement.field_1350 < 0.0 ? -deltaMovement.field_1350 : deltaMovement.field_1350;
                deltaMovement = deltaMovement.method_1031(0.0, nonNegZ * 1.8 * multiplier, 0.0);
            }
            if (this.field_6000) {
                deltaMovement = deltaMovement.method_1031(0.0, 0.01, 0.0);
            }
            this.method_18799(deltaMovement);
        }
    }

    protected void tickAfterWindLeash() {
        class_1297 entity = this.method_5933();
        if (entity != null && entity.method_37908() == this.method_37908()) {
            this.method_18408(entity.method_24515(), 5);
            float f = this.method_5739(entity);
            if (f > 10.0f) {
                this.method_5932(true, true);
            } else if (f > 6.0f) {
                double d = (entity.method_23317() - this.method_23317()) / (double)f;
                double e = (entity.method_23318() - this.method_23318()) / (double)f;
                double g = (entity.method_23321() - this.method_23321()) / (double)f;
                this.method_18799(this.method_18798().method_1031(Math.copySign(d * d * 0.4, d), Math.copySign(e * e * 0.4, e), Math.copySign(g * g * 0.4, g)));
            }
        }
    }

    public void pickupItem() {
        class_1799 inventoryStack = (class_1799)this.inventory.get(0);
        if (inventoryStack.method_7947() > 1) {
            this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), inventoryStack.method_7971(inventoryStack.method_7947() - 1)));
        }
        if (!this.method_37908().field_9236 && inventoryStack.method_7960() && this.method_37908().method_8450().method_8355(class_1928.field_19388) && !this.method_31481()) {
            List list = this.method_37908().method_18467(class_1542.class, this.method_5829().method_1014(0.15));
            for (class_1542 item : list) {
                class_1799 stack;
                if (!this.isMovingTowards((class_1297)item) || (stack = item.method_6983()).method_7960()) continue;
                this.inventory.set(0, (Object)stack.method_7971(1));
                this.isItemNatural = false;
                this.randomizeItemOffsets();
                break;
            }
        }
        this.setVisibleItem((class_1799)this.inventory.get(0));
    }

    public void dropItem(boolean killed) {
        if (!this.isItemNatural || killed) {
            this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23318() + 0.4375, this.method_23321(), ((class_1799)this.inventory.get(0)).method_7971(1)));
        }
    }

    public void destroy(boolean killed) {
        if (this.method_5805()) {
            this.method_5783(RegisterSounds.ENTITY_TUMBLEWEED_BREAK, this.method_6107(), this.method_6017());
        }
        this.dropItem(killed);
        this.spawnBreakParticles();
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public void setItem(@NotNull class_1799 stack, boolean natural) {
        this.inventory.set(0, (Object)stack);
        this.isItemNatural = natural;
        this.randomizeItemOffsets();
    }

    public boolean isMovingTowards(@NotNull class_1297 entity) {
        return entity.method_30950(0.0f).method_1022(this.method_30950(0.0f)) > entity.method_30950(1.0f).method_1022(this.method_30950(1.0f));
    }

    @NotNull
    public class_243 getDeltaPos() {
        return this.method_30950(1.0f).method_1020(this.method_30950(0.0f));
    }

    public boolean method_5679(@NotNull class_1282 source) {
        return source.method_48789(class_8103.field_42248) || source.method_49708(class_8111.field_42344) || source.method_49708(class_8111.field_42354) || source.method_49708(class_8111.field_42353) || source.method_49708(class_8111.field_42350) || super.method_5679(source);
    }

    public boolean method_32316() {
        return false;
    }

    public boolean method_5931(@NotNull class_1657 player) {
        return EntityConfig.get().tumbleweed.leashedTumbleweed;
    }

    public boolean method_6049(@NotNull class_1293 effectInstance) {
        return false;
    }

    public boolean method_33190() {
        return false;
    }

    protected boolean method_5860(@NotNull class_1297 vehicle) {
        return false;
    }

    protected float method_18394(@NotNull class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 * 0.5f;
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return RegisterSounds.ENTITY_TUMBLEWEED_DAMAGE;
    }

    protected class_3414 method_6002() {
        return RegisterSounds.ENTITY_TUMBLEWEED_BREAK;
    }

    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
        this.method_5783(RegisterSounds.ENTITY_TUMBLEWEED_BOUNCE, 0.2f, 1.0f);
    }

    public boolean method_5747(float fallDistance, float multiplier, @NotNull class_1282 source) {
        return false;
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return new class_2604(this.method_5628(), this.method_5667(), this.method_23317(), this.method_23318(), this.method_23321(), this.pitch, this.roll, this.method_5864(), 0, this.method_18798(), (double)this.tumble);
    }

    public void method_31471(@NotNull class_2604 packet) {
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        this.roll = packet.method_11168();
        this.pitch = packet.method_11171();
        this.method_43391(d, e, f);
        this.field_6283 = packet.method_43233();
        this.tumble = packet.method_43233();
        this.field_6220 = this.field_6283;
        this.field_6259 = this.field_6241;
        this.method_5838(packet.method_11167());
        this.method_5826(packet.method_11164());
        this.method_5641(d, e, f, 0.0f, 0.0f);
        this.method_18800(packet.method_11170(), packet.method_11172(), packet.method_11173());
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.spawnedFromShears = compound.method_10577("SpawnedFromShears");
        this.ticksSinceActive = compound.method_10550("TicksSinceActive");
        this.isItemNatural = compound.method_10577("IsTumbleweedItemNatural");
        this.setItemX(compound.method_10583("ItemX"));
        this.setItemZ(compound.method_10583("ItemZ"));
        this.pitch = compound.method_10583("TumblePitch");
        this.roll = compound.method_10583("TumbleRoll");
        this.isTouchingStickingBlock = compound.method_10577("isTouchingStickingBlock");
        this.isTouchingStoppingBlock = compound.method_10577("IsTouchingStoppingBlock");
        this.lookRot = compound.method_10583("LookRot");
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compound, this.inventory);
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("SpawnedFromShears", this.spawnedFromShears);
        compound.method_10569("TicksSinceActive", this.ticksSinceActive);
        compound.method_10556("IsTumbleweedItemNatural", this.isItemNatural);
        compound.method_10548("ItemX", this.getItemX());
        compound.method_10548("ItemZ", this.getItemZ());
        compound.method_10548("TumblePitch", this.pitch);
        compound.method_10548("TumbleRoll", this.roll);
        compound.method_10556("isTouchingStickingBlock", this.isTouchingStickingBlock);
        compound.method_10556("IsTouchingStoppingBlock", this.isTouchingStoppingBlock);
        compound.method_10548("LookRot", this.lookRot);
        class_1262.method_5426((class_2487)compound, this.inventory);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ITEM_STACK, (Object)class_1799.field_8037);
        this.field_6011.method_12784(ITEM_X, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(ITEM_Z, (Object)Float.valueOf(0.0f));
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)RegisterBlocks.TUMBLEWEED);
    }

    public void method_6078(@NotNull class_1282 damageSource) {
        super.method_6078(damageSource);
        if (!this.method_37908().field_9236 && damageSource.method_5526() instanceof class_1657 && this.method_37908().method_8450().method_8355(class_1928.field_19391) && !damageSource.method_5530() && Tumbleweed.isSilkTouchOrShears(damageSource)) {
            this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)RegisterBlocks.TUMBLEWEED)));
        }
        this.destroy(true);
    }

    public void spawnBreakParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            level.method_14199((class_2394)new class_2388(class_2398.field_11217, RegisterBlocks.TUMBLEWEED.method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 20, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    public boolean method_17326() {
        return super.method_17326() || this.spawnedFromShears || this.method_5934() || this.method_16914();
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.spawnedFromShears;
    }

    public class_1799 getVisibleItem() {
        return (class_1799)this.field_6011.method_12789(ITEM_STACK);
    }

    public void setVisibleItem(class_1799 itemStack) {
        this.method_5841().method_12778(ITEM_STACK, (Object)itemStack);
    }

    public void randomizeItemOffsets() {
        this.setItemX(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? 1 : -1) * 0.25f);
        this.setItemZ(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? 1 : -1) * 0.25f);
    }

    public float getItemX() {
        return ((Float)this.field_6011.method_12789(ITEM_X)).floatValue();
    }

    public void setItemX(float f) {
        this.method_5841().method_12778(ITEM_X, (Object)Float.valueOf(f));
    }

    public float getItemZ() {
        return ((Float)this.field_6011.method_12789(ITEM_Z)).floatValue();
    }

    public void setItemZ(float f) {
        this.method_5841().method_12778(ITEM_Z, (Object)Float.valueOf(f));
    }

    protected void method_23733(@Nullable class_1309 entitySource) {
    }

    protected void method_5734(float volume) {
    }

    @NotNull
    public Iterable<class_1799> method_5661() {
        return class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    }

    @NotNull
    public class_1799 method_6118(@NotNull class_1304 slot) {
        return class_1799.field_8037;
    }

    public void method_5673(@NotNull class_1304 slot, @NotNull class_1799 stack) {
    }

    @NotNull
    public class_1306 method_6068() {
        return class_1306.field_6182;
    }

    public void frozenLib$onSteppedOnBlock(class_1937 level, class_2338 blockPos, @NotNull class_2680 blockState) {
        if (blockState.method_26164(WilderBlockTags.STOPS_TUMBLEWEED)) {
            this.isTouchingStoppingBlock = true;
        }
    }
}

