/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity.ai;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.wilderwild.block.HollowedLogBlock;
import net.frozenblock.wilderwild.config.BlockConfig;
import net.frozenblock.wilderwild.misc.WilderSharedConstants;
import net.frozenblock.wilderwild.misc.server.EasyPacket;
import net.frozenblock.wilderwild.registry.RegisterBlocks;
import net.frozenblock.wilderwild.registry.RegisterProperties;
import net.frozenblock.wilderwild.registry.RegisterSounds;
import net.frozenblock.wilderwild.tag.WilderBlockTags;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TermiteManager {
    private final ArrayList<Termite> termites = new ArrayList();
    public int ticksToNextTermite;
    public int highestID;

    public static int maxTermites(boolean natural, boolean awake, boolean canSpawn) {
        if (!canSpawn) {
            return 0;
        }
        if (!awake) {
            return natural ? 0 : 1;
        }
        return natural ? 3 : 5;
    }

    public static boolean areTermitesSafe(@NotNull class_1937 level, @NotNull class_2338 pos) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        for (class_2350 direction : class_2350.values()) {
            if (!TermiteManager.isPosSafeForTermites((class_1936)level, (class_2338)mutableBlockPos.method_10098(direction))) {
                return false;
            }
            mutableBlockPos.method_10104(direction, -1);
        }
        return true;
    }

    public static boolean isPosSafeForTermites(@NotNull class_1936 level, @NotNull class_2338 pos) {
        return TermiteManager.isStateSafeForTermites(level.method_8320(pos)) && level.method_8316(pos).method_15769();
    }

    public static boolean isPosSafeForTermites(@NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return TermiteManager.isStateSafeForTermites(state) && level.method_8316(pos).method_15769();
    }

    public static boolean isStateSafeForTermites(@NotNull class_2680 state) {
        return !state.method_26164(WilderBlockTags.KILLS_TERMITE) && (!state.method_28498((class_2769)class_2741.field_12508) || (Boolean)state.method_11654((class_2769)class_2741.field_12508) == false);
    }

    public void addTermite(@NotNull class_2338 pos) {
        Termite termite = new Termite(pos, pos, 0, 0, 0, false, ++this.highestID);
        this.termites.add(termite);
    }

    public void tick(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural, boolean awake, boolean canSpawn) {
        int maxTermites = TermiteManager.maxTermites(natural, awake, canSpawn);
        ArrayList<Termite> termitesToRemove = new ArrayList<Termite>();
        for (Termite termite : this.termites) {
            if (termite.tick(level, natural)) {
                EasyPacket.EasyTermitePacket.createParticle(level, class_243.method_24953((class_2382)termite.pos), termite.eating ? 4 : 6);
                continue;
            }
            level.method_8396(null, termite.pos, RegisterSounds.BLOCK_TERMITE_MOUND_ENTER, class_3419.field_15254, 0.6f, 1.0f);
            termitesToRemove.add(termite);
        }
        for (Termite termite : termitesToRemove) {
            level.method_43275(null, class_5712.field_37676, class_243.method_24953((class_2382)termite.pos));
            this.termites.remove(termite);
            level.method_43275(null, class_5712.field_28733, class_243.method_24953((class_2382)pos));
        }
        if (this.termites.size() < maxTermites) {
            if (this.ticksToNextTermite > 0) {
                --this.ticksToNextTermite;
            } else {
                this.addTermite(pos);
                level.method_43275(null, class_5712.field_28733, class_243.method_24953((class_2382)pos));
                level.method_8396(null, pos, RegisterSounds.BLOCK_TERMITE_MOUND_EXIT, class_3419.field_15254, 0.6f, 1.0f);
                int n = this.ticksToNextTermite = natural ? 320 : 200;
            }
        }
        while (this.termites.size() > maxTermites) {
            Termite termite = this.termites.get(AdvancedMath.random().method_43048(this.termites.size()));
            level.method_8396(null, termite.pos, RegisterSounds.BLOCK_TERMITE_MOUND_ENTER, class_3419.field_15254, 0.6f, 1.0f);
            level.method_43275(null, class_5712.field_39446, class_243.method_24953((class_2382)termite.pos));
            this.termites.remove(termite);
            level.method_43275(null, class_5712.field_28733, class_243.method_24953((class_2382)pos));
        }
        termitesToRemove.clear();
    }

    public void clearTermites(@NotNull class_1937 level) {
        for (Termite termite : this.termites) {
            level.method_43275(null, class_5712.field_37676, class_243.method_24953((class_2382)termite.pos));
            level.method_8396(null, termite.pos, RegisterSounds.BLOCK_TERMITE_MOUND_ENTER, class_3419.field_15254, 0.6f, 1.0f);
        }
        this.termites.clear();
    }

    public ArrayList<Termite> termites() {
        return this.termites;
    }

    public void saveAdditional(@NotNull class_2487 tag) {
        tag.method_10569("ticksToNextTermite", this.ticksToNextTermite);
        tag.method_10569("highestID", this.highestID);
        Logger logger = WilderSharedConstants.LOGGER;
        DataResult var10000 = Termite.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.termites);
        Objects.requireNonNull(logger);
        var10000.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbt -> tag.method_10566("termites", nbt));
    }

    public void load(@NotNull class_2487 tag) {
        this.ticksToNextTermite = tag.method_10550("ticksToNextTermite");
        this.highestID = tag.method_10550("highestID");
        if (tag.method_10573("termites", 9)) {
            this.termites.clear();
            DataResult var10000 = Termite.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10554("termites", 10)));
            Logger logger = WilderSharedConstants.LOGGER;
            Objects.requireNonNull(logger);
            Optional list = var10000.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            if (list.isPresent()) {
                List termiteList = (List)list.get();
                this.termites.addAll(termiteList);
            }
        }
    }

    public static class Termite {
        public static final Codec<Termite> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("mound").forGetter(Termite::getMoundPos), (App)class_2338.field_25064.fieldOf("pos").forGetter(Termite::getPos), (App)Codec.intRange((int)0, (int)10000).fieldOf("blockDestroyPower").orElse((Object)0).forGetter(Termite::getPower), (App)Codec.intRange((int)0, (int)2002).fieldOf("aliveTicks").orElse((Object)0).forGetter(Termite::getAliveTicks), (App)Codec.intRange((int)0, (int)5).fieldOf("update").orElse((Object)0).forGetter(Termite::getUpdateTicks), (App)Codec.BOOL.fieldOf("eating").orElse((Object)true).forGetter(Termite::getEating), (App)Codec.INT.fieldOf("id").orElse((Object)0).forGetter(Termite::getID)).apply((Applicative)instance, Termite::new));
        public static final Map<class_2248, class_2248> DEGRADABLE_BLOCKS = new Object2ObjectOpenHashMap();
        public static final Map<class_2248, class_2248> NATURAL_DEGRADABLE_BLOCKS = new Object2ObjectOpenHashMap();
        public class_2338 mound;
        public class_2338 pos;
        public int blockDestroyPower;
        public int aliveTicks;
        public int update;
        public boolean eating;
        public int id;

        public Termite(@NotNull class_2338 mound, @NotNull class_2338 pos, int blockDestroyPower, int aliveTicks, int update) {
            this.mound = mound;
            this.pos = pos;
            this.blockDestroyPower = blockDestroyPower;
            this.aliveTicks = aliveTicks;
            this.update = update;
        }

        public Termite(@NotNull class_2338 mound, @NotNull class_2338 pos, int blockDestroyPower, int aliveTicks, int update, boolean eating, int id) {
            this.mound = mound;
            this.pos = pos;
            this.blockDestroyPower = blockDestroyPower;
            this.aliveTicks = aliveTicks;
            this.update = update;
            this.eating = eating;
            this.id = id;
        }

        @Nullable
        public static class_2338 ledgePos(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural) {
            class_2338.class_2339 mutableBlockPos = pos.method_25503();
            class_2680 state = level.method_8320((class_2338)mutableBlockPos);
            if (DEGRADABLE_BLOCKS.containsKey(state.method_26204()) || state.method_26164(WilderBlockTags.TERMITE_BREAKABLE)) {
                return mutableBlockPos;
            }
            mutableBlockPos.method_10098(class_2350.field_11033);
            state = level.method_8320((class_2338)mutableBlockPos);
            if (!state.method_26215() && Termite.isBlockMovable(state, class_2350.field_11033) && Termite.exposedToAir(level, (class_2338)mutableBlockPos, natural)) {
                return mutableBlockPos;
            }
            mutableBlockPos.method_10104(class_2350.field_11036, 2);
            state = level.method_8320((class_2338)mutableBlockPos);
            if (!state.method_26215() && Termite.isBlockMovable(state, class_2350.field_11036) && Termite.exposedToAir(level, (class_2338)mutableBlockPos, natural)) {
                return mutableBlockPos;
            }
            return null;
        }

        @Nullable
        public static class_2338 degradableBreakablePos(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural) {
            class_2338.class_2339 mutableBlockPos = pos.method_25503();
            List directions = class_156.method_43253((Object[])class_2350.values(), (class_5819)level.field_9229);
            class_2680 upState = level.method_8320((class_2338)mutableBlockPos.method_10098(class_2350.field_11036));
            if (Termite.canEatBlock(natural, mutableBlockPos, upState)) {
                return mutableBlockPos;
            }
            mutableBlockPos.method_10098(class_2350.field_11033);
            for (class_2350 direction : directions) {
                class_2680 state = level.method_8320((class_2338)mutableBlockPos.method_10098(direction));
                if (Termite.canEatBlock(natural, mutableBlockPos, state)) {
                    return mutableBlockPos;
                }
                mutableBlockPos.method_10104(direction, -1);
            }
            return null;
        }

        private static boolean canEatBlock(boolean natural, @NotNull class_2338.class_2339 mutableBlockPos, @NotNull class_2680 state) {
            if (((natural ? NATURAL_DEGRADABLE_BLOCKS.containsKey(state.method_26204()) : DEGRADABLE_BLOCKS.containsKey(state.method_26204())) || state.method_26164(WilderBlockTags.TERMITE_BREAKABLE)) && Termite.isEdibleProperty(state)) {
                if (state.method_28498((class_2769)class_2741.field_12533) && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609) {
                    mutableBlockPos.method_10098(class_2350.field_11033);
                }
                return true;
            }
            return false;
        }

        public static boolean isEdibleProperty(@NotNull class_2680 state) {
            return !BlockConfig.get().termite.onlyEatNaturalBlocks || (state.method_28498((class_2769)RegisterProperties.TERMITE_EDIBLE) ? (Boolean)state.method_11654((class_2769)RegisterProperties.TERMITE_EDIBLE) != false : !state.method_26164(class_3481.field_15503) || !state.method_28498((class_2769)class_2741.field_12514) || (Boolean)state.method_11654((class_2769)class_2741.field_12514) == false);
        }

        public static boolean exposedToAir(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural) {
            class_2338.class_2339 mutableBlockPos = pos.method_25503();
            for (class_2350 direction : class_2350.values()) {
                class_2680 state = level.method_8320((class_2338)mutableBlockPos.method_10098(direction));
                if (state.method_26215() || !state.method_26212((class_1922)level, (class_2338)mutableBlockPos) && !state.method_26164(WilderBlockTags.BLOCKS_TERMITE) || (!natural && DEGRADABLE_BLOCKS.containsKey(state.method_26204()) || natural && NATURAL_DEGRADABLE_BLOCKS.containsKey(state.method_26204()) || state.method_26164(WilderBlockTags.TERMITE_BREAKABLE)) && Termite.isEdibleProperty(state)) {
                    return true;
                }
                mutableBlockPos.method_10104(direction, -1);
            }
            return false;
        }

        public static boolean canMove(@NotNull class_1936 level, @NotNull class_2338 pos) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                return serverLevel.method_41411(pos);
            }
            return false;
        }

        public static boolean isBlockMovable(@NotNull class_2680 state, @NotNull class_2350 direction) {
            if (state.method_26164(WilderBlockTags.BLOCKS_TERMITE)) {
                return false;
            }
            boolean moveableUp = direction != class_2350.field_11036 || !state.method_26164(class_3481.field_28040) && !state.method_26164(class_3481.field_44470) && !state.method_26164(class_3481.field_20339);
            boolean moveableDown = direction != class_2350.field_11033 || !state.method_27852(class_2246.field_10382) && !state.method_27852(class_2246.field_10164) && (!state.method_28498((class_2769)class_2741.field_12508) || (Boolean)state.method_11654((class_2769)class_2741.field_12508) == false);
            return moveableUp && moveableDown;
        }

        public static boolean isTooFar(boolean natural, @NotNull class_2338 mound, @NotNull class_2338 pos) {
            return !mound.method_19771((class_2382)pos, natural ? (double)BlockConfig.get().termite.maxNaturalDistance : (double)BlockConfig.get().termite.maxDistance);
        }

        public static void addDegradableBlocks() {
            Termite.addDegradable(class_2246.field_10533, class_2246.field_10622);
            Termite.addDegradable(class_2246.field_10622, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_ACACIA_LOG);
            Termite.addDegradable((class_2248)RegisterBlocks.HOLLOWED_ACACIA_LOG, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_ACACIA_LOG);
            Termite.addDegradable(class_2246.field_9999, class_2246.field_10103);
            Termite.addDegradable(class_2246.field_10511, class_2246.field_10366);
            Termite.addDegradable(class_2246.field_10366, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_BIRCH_LOG);
            Termite.addDegradable((class_2248)RegisterBlocks.HOLLOWED_BIRCH_LOG, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_BIRCH_LOG);
            Termite.addDegradable(class_2246.field_10307, class_2246.field_10204);
            Termite.addDegradable(class_2246.field_10431, class_2246.field_10519);
            Termite.addDegradable(class_2246.field_10519, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_OAK_LOG);
            Termite.addDegradable((class_2248)RegisterBlocks.HOLLOWED_OAK_LOG, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_OAK_LOG);
            Termite.addDegradable(class_2246.field_10126, class_2246.field_10250);
            Termite.addDegradable(class_2246.field_10010, class_2246.field_10244);
            Termite.addDegradable(class_2246.field_10244, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_DARK_OAK_LOG);
            Termite.addDegradable((class_2248)RegisterBlocks.HOLLOWED_DARK_OAK_LOG, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_DARK_OAK_LOG);
            Termite.addDegradable(class_2246.field_10178, class_2246.field_10374);
            Termite.addDegradable(class_2246.field_10306, class_2246.field_10254);
            Termite.addDegradable(class_2246.field_10254, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_JUNGLE_LOG);
            Termite.addDegradable((class_2248)RegisterBlocks.HOLLOWED_JUNGLE_LOG, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_JUNGLE_LOG);
            Termite.addDegradable(class_2246.field_10303, class_2246.field_10084);
            Termite.addDegradable(class_2246.field_10037, class_2246.field_10436);
            Termite.addDegradable(class_2246.field_10436, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_SPRUCE_LOG);
            Termite.addDegradable((class_2248)RegisterBlocks.HOLLOWED_SPRUCE_LOG, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_SPRUCE_LOG);
            Termite.addDegradable(class_2246.field_10155, class_2246.field_10558);
            Termite.addDegradable(class_2246.field_37545, class_2246.field_37548);
            Termite.addDegradable(class_2246.field_37548, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_MANGROVE_LOG);
            Termite.addDegradable((class_2248)RegisterBlocks.HOLLOWED_MANGROVE_LOG, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_MANGROVE_LOG);
            Termite.addDegradable(class_2246.field_37549, class_2246.field_37550);
            Termite.addDegradable(class_2246.field_42729, class_2246.field_42732);
            Termite.addDegradable(class_2246.field_42732, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_CHERRY_LOG);
            Termite.addDegradable((class_2248)RegisterBlocks.HOLLOWED_CHERRY_LOG, (class_2248)RegisterBlocks.STRIPPED_HOLLOWED_CHERRY_LOG);
            Termite.addDegradable(class_2246.field_42733, class_2246.field_42730);
        }

        public static void addDegradable(class_2248 degradable, class_2248 result) {
            DEGRADABLE_BLOCKS.put(degradable, result);
        }

        public static void addNaturalDegradableBlocks() {
            Termite.addNaturalDegradable(class_2246.field_10533, class_2246.field_10622);
            Termite.addNaturalDegradable(class_2246.field_10431, class_2246.field_10519);
            Termite.addNaturalDegradable(class_2246.field_10511, class_2246.field_10366);
            Termite.addNaturalDegradable(class_2246.field_10010, class_2246.field_10244);
            Termite.addNaturalDegradable(class_2246.field_10306, class_2246.field_10254);
            Termite.addNaturalDegradable(class_2246.field_37545, class_2246.field_37548);
            Termite.addNaturalDegradable(class_2246.field_10037, class_2246.field_10436);
            Termite.addNaturalDegradable(class_2246.field_9999, class_2246.field_10103);
            Termite.addNaturalDegradable(class_2246.field_10126, class_2246.field_10250);
            Termite.addNaturalDegradable(class_2246.field_10307, class_2246.field_10204);
            Termite.addNaturalDegradable(class_2246.field_10178, class_2246.field_10374);
            Termite.addNaturalDegradable(class_2246.field_10303, class_2246.field_10084);
            Termite.addNaturalDegradable(class_2246.field_37549, class_2246.field_37550);
            Termite.addNaturalDegradable(class_2246.field_10155, class_2246.field_10558);
        }

        public static void addNaturalDegradable(@NotNull class_2248 degradable, @NotNull class_2248 result) {
            NATURAL_DEGRADABLE_BLOCKS.put(degradable, result);
        }

        public static void spawnGnawParticles(@NotNull class_1937 level, @NotNull class_2680 eatState, @NotNull class_2338 pos) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                if (level.field_9229.method_43051(0, 4) == 3) {
                    serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, eatState), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, level.field_9229.method_43051(0, 3), (double)0.3f, (double)0.3f, (double)0.3f, 0.05);
                }
            }
        }

        public static void spawnEatParticles(class_1937 level, @NotNull class_2680 eatState, @NotNull class_2338 pos) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, eatState), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, level.field_9229.method_43051(18, 25), (double)0.3f, (double)0.3f, (double)0.3f, 0.05);
            }
        }

        public boolean tick(@NotNull class_1937 level, boolean natural) {
            boolean exit = false;
            ++this.aliveTicks;
            if (this.aliveTicks > (natural ? 1200 : 2000) || Termite.isTooFar(natural, this.mound, this.pos)) {
                return false;
            }
            if (!TermiteManager.areTermitesSafe(level, this.pos)) {
                return false;
            }
            if (Termite.canMove((class_1936)level, this.pos)) {
                class_2680 blockState = level.method_8320(this.pos);
                class_2248 block = blockState.method_26204();
                boolean degradable = !natural ? DEGRADABLE_BLOCKS.containsKey(block) : NATURAL_DEGRADABLE_BLOCKS.containsKey(block);
                boolean breakable = blockState.method_26164(WilderBlockTags.TERMITE_BREAKABLE);
                boolean leaves = blockState.method_26164(class_3481.field_15503);
                if ((degradable || breakable) && Termite.isEdibleProperty(blockState)) {
                    this.eating = true;
                    exit = true;
                    int additionalPower = breakable ? (leaves ? 4 : 2) : 1;
                    this.blockDestroyPower += additionalPower;
                    Termite.spawnGnawParticles(level, blockState, this.pos);
                    if (this.blockDestroyPower > 200) {
                        this.blockDestroyPower = 0;
                        int n = this.aliveTicks = natural ? Math.max(0, this.aliveTicks - 200 / additionalPower) : 0;
                        if (breakable) {
                            level.method_22352(this.pos, true);
                        } else {
                            level.method_31595(this.pos, blockState);
                            class_2248 setBlock = !natural ? DEGRADABLE_BLOCKS.get(block) : NATURAL_DEGRADABLE_BLOCKS.get(block);
                            class_2680 setState = setBlock.method_34725(blockState);
                            level.method_8501(this.pos, setState);
                            if (setBlock instanceof HollowedLogBlock) {
                                boolean nether = new class_1799((class_1935)setBlock.method_8389()).method_31573(class_3489.field_23211);
                                level.method_8396(null, this.pos, nether ? RegisterSounds.STEM_HOLLOWED : RegisterSounds.LOG_HOLLOWED, class_3419.field_15245, 0.6f, 0.95f + level.field_9229.method_43057() * 0.2f);
                            }
                        }
                        Termite.spawnEatParticles(level, blockState, this.pos);
                        level.method_8396(null, this.pos, RegisterSounds.BLOCK_TERMITE_MOUND_TERMITE_GNAW_FINISH, class_3419.field_15245, 0.6f, 0.9f + level.field_9229.method_43057() * 0.25f);
                    }
                } else {
                    class_2338 offset;
                    class_2680 state;
                    this.eating = false;
                    this.blockDestroyPower = 0;
                    class_2350 direction = class_2350.method_10162((class_5819)level.method_8409());
                    if (blockState.method_26215()) {
                        direction = class_2350.field_11033;
                    }
                    if (!TermiteManager.isStateSafeForTermites(state = level.method_8320(offset = this.pos.method_10093(direction)))) {
                        return false;
                    }
                    if (this.update > 0 && !blockState.method_26215()) {
                        --this.update;
                        return true;
                    }
                    this.update = 1;
                    class_2338 priority = Termite.degradableBreakablePos(level, this.pos, natural);
                    if (priority != null) {
                        this.pos = priority;
                        exit = true;
                    } else {
                        class_2338 ledge = Termite.ledgePos(level, offset, natural);
                        class_2338 posUp = this.pos.method_10084();
                        class_2680 stateUp = level.method_8320(posUp);
                        if (Termite.exposedToAir(level, offset, natural) && Termite.isBlockMovable(state, direction) && (direction == class_2350.field_11033 || !state.method_26215() || this.mound.method_19771((class_2382)this.pos, 1.5) || ledge != null)) {
                            this.pos = offset;
                            if (ledge != null) {
                                this.pos = ledge;
                            }
                            exit = true;
                        } else if (ledge != null && Termite.exposedToAir(level, ledge, natural)) {
                            this.pos = ledge;
                            exit = true;
                        } else if (!stateUp.method_26215() && Termite.isBlockMovable(stateUp, class_2350.field_11036) && Termite.exposedToAir(level, posUp, natural)) {
                            this.pos = posUp;
                            exit = true;
                        }
                    }
                }
            }
            return exit || Termite.exposedToAir(level, this.pos, natural);
        }

        @NotNull
        public class_2338 getMoundPos() {
            return this.mound;
        }

        @NotNull
        public class_2338 getPos() {
            return this.pos;
        }

        public int getPower() {
            return this.blockDestroyPower;
        }

        public int getAliveTicks() {
            return this.aliveTicks;
        }

        public int getUpdateTicks() {
            return this.update;
        }

        public boolean getEating() {
            return this.eating;
        }

        public int getID() {
            return this.id;
        }
    }
}

