/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity.render.model;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.entity.api.rendering.FrozenRenderType;
import net.frozenblock.wilderwild.config.EntityConfig;
import net.frozenblock.wilderwild.entity.Jellyfish;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5597;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class JellyfishModel<T extends Jellyfish>
extends class_5597<T> {
    private static final int JELLYFISH_TENTACLES = EntityConfig.get().jellyfish.jellyfishTentacles;
    private static final float pi180 = (float)Math.PI / 180;
    private static final float eightPi = -0.13962634f;
    private final class_630 root;
    private final class_630 body;
    private final class_630 tentacleBase;
    private final class_630[] tentacles = new class_630[JELLYFISH_TENTACLES];
    public float xRot;
    public float tentXRot;
    public float red;
    public float green;
    public float blue;
    public float scale = 1.0f;

    public JellyfishModel(@NotNull class_630 root) {
        super(FrozenRenderType::entityTranslucentEmissiveFixed);
        this.root = root;
        class_630 bone = root.method_32086("bone");
        this.body = bone.method_32086("body");
        this.tentacleBase = bone.method_32086("tentacleBase");
        Arrays.setAll(this.tentacles, i -> this.tentacleBase.method_32086(JellyfishModel.createTentacleName(i)));
    }

    @NotNull
    public static class_5607 createBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        class_5610 bone = partDefinition.method_32117("bone", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)14.0f, (float)0.0f));
        bone.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0f, -2.0f, -4.0f, 8.0f, 5.0f, 8.0f, new class_5605(0.0f)).method_32101(4, 13).method_32098(-3.0f, -1.0f, -3.0f, 6.0f, 3.0f, 6.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 tentacleBase = bone.method_32117("tentacleBase", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)6.0f, (float)0.0f));
        JellyfishModel.makeTentacles(tentacleBase, JELLYFISH_TENTACLES);
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    private static void makeTentacles(class_5610 partDefinition, int amount) {
        class_5606 tentacle = class_5606.method_32108().method_32101(0, 13).method_32098(-0.5f, 0.0f, 0.0f, 1.0f, 10.0f, 1.0f, new class_5605(0.0f));
        for (int i = 0; i < amount; ++i) {
            double rot = (double)i * Math.PI * 2.0 / (double)amount;
            partDefinition.method_32117(JellyfishModel.createTentacleName(i), tentacle, class_5603.method_32091((float)((float)Math.cos(rot) * 2.5f), (float)0.0f, (float)((float)Math.sin(rot) * 2.5f), (float)0.0f, (float)((float)((double)i * Math.PI * -2.0 / (double)amount + 1.5707963267948966)), (float)0.0f));
        }
    }

    @NotNull
    private static String createTentacleName(int i) {
        return "tentacle" + i;
    }

    private static float fasterRotLerp(float f, float g, float h) {
        float angleCalc = (h - g) % 360.0f;
        if (angleCalc >= 180.0f) {
            angleCalc -= 360.0f;
        }
        if (angleCalc < -180.0f) {
            angleCalc += 360.0f;
        }
        return g + f * angleCalc;
    }

    public void method_2828(@NotNull class_4587 poseStack, @NotNull class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.method_22905(this.scale, this.scale, this.scale);
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(this.xRot));
        this.body.method_22699(poseStack, buffer, packedLight, packedOverlay, this.red, this.green, this.blue, alpha);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(this.tentXRot));
        this.tentacleBase.method_22699(poseStack, buffer, packedLight, packedOverlay, this.red, this.green, this.blue, alpha);
        poseStack.method_22909();
    }

    public void prepareMobModel(@NotNull T jelly, float limbSwing, float limbSwimgAmount, float partialTick) {
        this.xRot = -(((Jellyfish)((Object)jelly)).xRot1 + partialTick * (((Jellyfish)((Object)jelly)).xBodyRot - ((Jellyfish)((Object)jelly)).xRot1));
        this.tentXRot = -(((Jellyfish)((Object)jelly)).xRot6 + partialTick * (((Jellyfish)((Object)jelly)).xRot5 - ((Jellyfish)((Object)jelly)).xRot6));
        this.scale = (((Jellyfish)((Object)jelly)).prevScale + partialTick * (((Jellyfish)((Object)jelly)).scale - ((Jellyfish)((Object)jelly)).prevScale)) * jelly.method_17825();
    }

    public void setupAnim(@NotNull T jellyfish, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float squash;
        float animation = limbSwing * 2.0f;
        float movementDelta = Math.min(limbSwingAmount * 26.666666f, 1.0f);
        float sin = (float)(-Math.sin(animation));
        float sinIdle = (float)(Math.sin(ageInTicks * 0.1f) * (double)0.2f);
        float squashStretch = 1.0f + -sin * 0.25f;
        this.body.field_37938 = squash = class_3532.method_16439((float)movementDelta, (float)(sinIdle + 1.0f), (float)squashStretch);
        this.body.field_37940 = squash;
        float yScaleSin = -sinIdle + 1.0f;
        this.body.field_37939 = yScaleSin + movementDelta * (1.25f + sin * 0.75f - yScaleSin);
        this.body.field_3656 = movementDelta * (3.5f - squashStretch * 3.5f);
        float sinPivotY = -sinIdle * 2.0f + 1.8f;
        this.tentacleBase.field_3656 = sinPivotY + movementDelta * ((6.0f - squashStretch * 5.0f) * 2.0f - sinPivotY);
        float tentRot = -JellyfishModel.fasterRotLerp(movementDelta, (float)(-Math.sin((ageInTicks - 10.0f) * 0.1f) * (double)0.2f) + -0.13962634f, (float)(-Math.sin(animation + 5.0f) * 20.0 - 7.5) * ((float)Math.PI / 180));
        for (class_630 modelPart : this.tentacles) {
            class_5603 initialPose = modelPart.method_41921();
            modelPart.field_3657 = initialPose.field_27702 * squash;
            modelPart.field_3655 = initialPose.field_27704 * squash;
            modelPart.field_3654 = tentRot;
        }
    }

    @NotNull
    public class_630 method_32008() {
        return this.root;
    }
}

